/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.table.api.FormatDescriptor;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TableDescriptor {
    @Nullable
    private final Schema schema;
    private final Map<String, String> options;
    @Nullable
    private final TableDistribution distribution;
    private final List<String> partitionKeys;
    @Nullable
    private final String comment;

    protected TableDescriptor(@Nullable Schema schema, Map<String, String> options, @Nullable TableDistribution distribution, List<String> partitionKeys, @Nullable String comment) {
        this.schema = schema;
        this.options = Collections.unmodifiableMap(options);
        this.distribution = distribution;
        this.partitionKeys = Collections.unmodifiableList(partitionKeys);
        this.comment = comment;
    }

    public static Builder forConnector(String connector) {
        Preconditions.checkNotNull((Object)connector, (String)"Table descriptors require a connector identifier.");
        Builder descriptorBuilder = new Builder();
        descriptorBuilder.option(FactoryUtil.CONNECTOR, connector);
        return descriptorBuilder;
    }

    public Optional<Schema> getSchema() {
        return Optional.ofNullable(this.schema);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Optional<TableDistribution> getDistribution() {
        return Optional.ofNullable(this.distribution);
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public CatalogTable toCatalogTable() {
        Schema schema = this.getSchema().orElseThrow(() -> new ValidationException("Missing schema in TableDescriptor. A schema is typically required. It can only be omitted at certain documented locations."));
        return CatalogTable.newBuilder().schema(schema).options(this.getOptions()).distribution(this.distribution).partitionKeys(this.partitionKeys).comment((String)this.getComment().orElse(null)).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        String escapedPartitionKeys = this.partitionKeys.stream().map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", "));
        String distributedBy = this.distribution == null ? "" : this.distribution.toString();
        String partitionedBy = !this.partitionKeys.isEmpty() ? String.format("PARTITIONED BY (%s)", escapedPartitionKeys) : "";
        String serializedOptions = this.options.entrySet().stream().map(entry -> String.format("  '%s' = '%s'", EncodingUtils.escapeSingleQuotes((String)((String)entry.getKey())), EncodingUtils.escapeSingleQuotes((String)((String)entry.getValue())))).collect(Collectors.joining(String.format(",%n", new Object[0])));
        return String.format("%s%nCOMMENT '%s'%n%s%s%nWITH (%n%s%n)", this.schema != null ? this.schema : "", this.comment != null ? this.comment : "", distributedBy, partitionedBy, serializedOptions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableDescriptor that = (TableDescriptor)obj;
        return Objects.equals(this.schema, that.schema) && this.options.equals(that.options) && Objects.equals(this.distribution, that.distribution) && this.partitionKeys.equals(that.partitionKeys) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.options, this.distribution, this.partitionKeys, this.comment);
    }

    @PublicEvolving
    public static class Builder {
        @Nullable
        private Schema schema;
        private final Map<String, String> options;
        @Nullable
        private TableDistribution distribution;
        private final List<String> partitionKeys;
        @Nullable
        private String comment;

        protected Builder() {
            this.options = new HashMap<String, String>();
            this.partitionKeys = new ArrayList<String>();
        }

        protected Builder(TableDescriptor descriptor) {
            this.schema = descriptor.getSchema().orElse(null);
            this.options = new HashMap<String, String>(descriptor.getOptions());
            this.distribution = descriptor.getDistribution().orElse(null);
            this.partitionKeys = new ArrayList<String>(descriptor.getPartitionKeys());
            this.comment = descriptor.getComment().orElse(null);
        }

        public Builder schema(@Nullable Schema schema) {
            this.schema = schema;
            return this;
        }

        public <T> Builder option(ConfigOption<T> configOption, T value) {
            Preconditions.checkNotNull(configOption, (String)"Config option must not be null.");
            Preconditions.checkNotNull(value, (String)"Value must not be null.");
            this.options.put(configOption.key(), (String)ConfigurationUtils.convertValue(value, String.class));
            return this;
        }

        public Builder option(String key, String value) {
            Preconditions.checkNotNull((Object)key, (String)"Key must not be null.");
            Preconditions.checkNotNull((Object)value, (String)"Value must not be null.");
            this.options.put(key, value);
            return this;
        }

        public Builder format(String format) {
            return this.format((ConfigOption<String>)FactoryUtil.FORMAT, FormatDescriptor.forFormat(format).build());
        }

        public Builder format(FormatDescriptor formatDescriptor) {
            return this.format((ConfigOption<String>)FactoryUtil.FORMAT, formatDescriptor);
        }

        public Builder format(ConfigOption<String> formatOption, FormatDescriptor formatDescriptor) {
            Preconditions.checkNotNull(formatOption, (String)"Format option must not be null.");
            Preconditions.checkNotNull((Object)formatDescriptor, (String)"Format descriptor must not be null.");
            this.option(formatOption, formatDescriptor.getFormat());
            String optionPrefix = FactoryUtil.getFormatPrefix(formatOption, (String)formatDescriptor.getFormat());
            formatDescriptor.getOptions().forEach((key, value) -> {
                if (key.startsWith(optionPrefix)) {
                    throw new ValidationException(String.format("Format options set using #format(FormatDescriptor) should not contain the prefix '%s', but found '%s'.", optionPrefix, key));
                }
                String prefixedKey = optionPrefix + key;
                this.option(prefixedKey, (String)value);
            });
            return this;
        }

        public Builder distributedByHash(String ... bucketKeys) {
            Builder.validateBucketKeys(bucketKeys);
            this.distribution = TableDistribution.ofHash(Arrays.asList(bucketKeys), null);
            return this;
        }

        public Builder distributedByHash(int numberOfBuckets, String ... bucketKeys) {
            Builder.validateBucketKeys(bucketKeys);
            this.distribution = TableDistribution.ofHash(Arrays.asList(bucketKeys), (Integer)numberOfBuckets);
            return this;
        }

        public Builder distributedByRange(String ... bucketKeys) {
            Builder.validateBucketKeys(bucketKeys);
            this.distribution = TableDistribution.ofRange(Arrays.asList(bucketKeys), null);
            return this;
        }

        public Builder distributedByRange(int numberOfBuckets, String ... bucketKeys) {
            Builder.validateBucketKeys(bucketKeys);
            this.distribution = TableDistribution.ofRange(Arrays.asList(bucketKeys), (Integer)numberOfBuckets);
            return this;
        }

        public Builder distributedBy(String ... bucketKeys) {
            Builder.validateBucketKeys(bucketKeys);
            this.distribution = TableDistribution.ofUnknown(Arrays.asList(bucketKeys), null);
            return this;
        }

        public Builder distributedBy(int numberOfBuckets, String ... bucketKeys) {
            Builder.validateBucketKeys(bucketKeys);
            this.distribution = TableDistribution.ofUnknown(Arrays.asList(bucketKeys), (Integer)numberOfBuckets);
            return this;
        }

        public Builder distributedInto(int numberOfBuckets) {
            this.distribution = TableDistribution.ofUnknown((int)numberOfBuckets);
            return this;
        }

        private static void validateBucketKeys(String[] bucketKeys) {
            Preconditions.checkNotNull((Object)bucketKeys, (String)"Bucket keys must not be null.");
            if (bucketKeys.length == 0) {
                throw new ValidationException("At least one bucket key must be defined for a distribution.");
            }
        }

        public Builder partitionedBy(String ... partitionKeys) {
            this.partitionKeys.addAll(Arrays.asList(partitionKeys));
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public TableDescriptor build() {
            return new TableDescriptor(this.schema, this.options, this.distribution, this.partitionKeys, this.comment);
        }
    }
}

