/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.operations.utils.OperationExpressionsUtils;

@Internal
final class ColumnOperationUtils {
    private static final DropColumnsExtractor dropColumnsExtractor = new DropColumnsExtractor();
    private static final RenameColumnExtractor renameColumnExtractor = new RenameColumnExtractor();

    static List<Expression> renameColumns(List<String> inputFields, List<Expression> newAliases) {
        LinkedHashMap finalFields = new LinkedHashMap();
        inputFields.forEach(field -> finalFields.put(field, ApiExpressionUtils.unresolvedRef(field)));
        newAliases.forEach(expr -> {
            String name = (String)expr.accept((ExpressionVisitor)renameColumnExtractor);
            finalFields.put(name, expr);
        });
        return new ArrayList<Expression>(finalFields.values());
    }

    static List<Expression> addOrReplaceColumns(List<String> inputFields, List<Expression> newExpressions) {
        LinkedHashMap finalFields = new LinkedHashMap();
        inputFields.forEach(field -> finalFields.put(field, ApiExpressionUtils.unresolvedRef(field)));
        newExpressions.forEach(expr -> {
            String name = OperationExpressionsUtils.extractName(expr).orElse(expr.toString());
            finalFields.put(name, expr);
        });
        return new ArrayList<Expression>(finalFields.values());
    }

    static List<Expression> dropFields(List<String> inputFields, List<Expression> dropExpressions) {
        Set<String> columnsToDrop = dropExpressions.stream().map(expr -> (String)expr.accept((ExpressionVisitor)dropColumnsExtractor)).collect(Collectors.toSet());
        columnsToDrop.forEach(c -> {
            if (!inputFields.contains(c)) {
                throw new ValidationException(String.format("Field %s does not exist in source table", c));
            }
        });
        return inputFields.stream().filter(oldName -> !columnsToDrop.contains(oldName)).map(ApiExpressionUtils::unresolvedRef).collect(Collectors.toList());
    }

    private ColumnOperationUtils() {
    }

    private static class RenameColumnExtractor
    extends ApiExpressionDefaultVisitor<String> {
        private RenameColumnExtractor() {
        }

        @Override
        public String visit(UnresolvedCallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.AS && unresolvedCall.getChildren().get(0) instanceof UnresolvedReferenceExpression) {
                UnresolvedReferenceExpression resolvedFieldReference = (UnresolvedReferenceExpression)unresolvedCall.getChildren().get(0);
                return resolvedFieldReference.getName();
            }
            return this.defaultMethod(unresolvedCall);
        }

        @Override
        protected String defaultMethod(Expression expression) {
            throw new ValidationException(String.format("Invalid alias for a renaming column operation. Renaming must add an alias to anexisting field. E.g.: 'a as a1'. But was: %s", expression));
        }
    }

    private static class DropColumnsExtractor
    extends ApiExpressionDefaultVisitor<String> {
        private DropColumnsExtractor() {
        }

        @Override
        public String visit(UnresolvedReferenceExpression unresolvedReference) {
            return unresolvedReference.getName();
        }

        @Override
        protected String defaultMethod(Expression expression) {
            throw new ValidationException("Unexpected drop column expression: " + expression);
        }
    }
}

