/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.types.Row;

public class UserDefinedFunctions {
    public static final String GENERATED_LOWER_UDF_CLASS = "LowerUDF";
    public static final String GENERATED_UPPER_UDF_CLASS = "UpperUDF";
    public static final String GENERATED_LOWER_UDF_CODE = "public class %s extends org.apache.flink.table.functions.ScalarFunction {\n  public String eval(String str) {\n    return str.toLowerCase();\n  }\n}\n";
    public static final String GENERATED_UPPER_UDF_CODE = "public class %s extends org.apache.flink.table.functions.ScalarFunction {\n  public String eval(String str) {\n    return str.toUpperCase();\n  }\n}\n";

    public static class TableUDF
    extends TableFunction<Row> {
        public void eval(String str, Long extra) {
            for (String s : str.split(" ")) {
                Row r = new Row(2);
                r.setField(0, (Object)s);
                r.setField(1, (Object)((long)s.length() + extra));
                this.collect(r);
            }
        }

        public TypeInformation<Row> getResultType() {
            return Types.ROW((TypeInformation[])new TypeInformation[]{Types.STRING(), Types.LONG()});
        }
    }

    public static class AggregateUDF
    extends AggregateFunction<Long, Long> {
        public Long createAccumulator() {
            return 0L;
        }

        public Long getValue(Long accumulator) {
            return 100L;
        }

        public void accumulate(Long acc, Long value) {
        }

        public TypeInformation<Long> getResultType() {
            return BasicTypeInfo.LONG_TYPE_INFO;
        }
    }

    public static class ScalarUDF
    extends ScalarFunction {
        public String eval(Integer i, Integer offset) {
            return String.valueOf(i + offset);
        }
    }
}

