/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.table.operations.OperationUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OperationUtilsTest {
    OperationUtilsTest() {
    }

    @Test
    void testSimpleIndent() {
        String sourceQuery = "SELECT * FROM source_t";
        String s = String.format("SELECT * FROM (%s\n) WHERE a > 5", OperationUtils.indent((String)sourceQuery));
        Assertions.assertThat((String)s).isEqualTo("SELECT * FROM (\n    SELECT * FROM source_t\n) WHERE a > 5");
    }

    @Test
    void testIndentChildWithLiteralWithNewline() {
        String sourceQuery = "SELECT *, '\n' FROM source_t";
        String s = String.format("SELECT * FROM (%s\n) WHERE a > 5", OperationUtils.indent((String)sourceQuery));
        Assertions.assertThat((String)s).isEqualTo("SELECT * FROM (\n    SELECT *, '\n' FROM source_t\n) WHERE a > 5");
    }

    @Test
    void testIndentChildWithEscapedQuotes() {
        String sourceQuery = "SELECT *, '',\n'' FROM source_t";
        String s = String.format("SELECT * FROM (%s\n) WHERE a > 5", OperationUtils.indent((String)sourceQuery));
        Assertions.assertThat((String)s).isEqualTo("SELECT * FROM (\n    SELECT *, '',\n    '' FROM source_t\n) WHERE a > 5");
    }
}

