/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FunctionCatalogTest {
    private static final ScalarFunction FUNCTION_1 = new TestFunction1();
    private static final ScalarFunction FUNCTION_2 = new TestFunction2();
    private static final ScalarFunction FUNCTION_3 = new TestFunction3();
    private static final ScalarFunction FUNCTION_4 = new TestFunction4();
    private static final ScalarFunction FUNCTION_INVALID = new InvalidTestFunction();
    private static final TableFunction<?> TABLE_FUNCTION = new TestTableFunction();
    private static final AggregateFunction<?, ?> AGGREGATE_FUNCTION = new TestAggregateFunction();
    private static final String NAME = "test_function";
    private static final ObjectIdentifier IDENTIFIER = ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"test_function");
    private static final UnresolvedIdentifier FULL_UNRESOLVED_IDENTIFIER = UnresolvedIdentifier.of((String[])new String[]{CatalogManagerMocks.DEFAULT_CATALOG, CatalogManagerMocks.DEFAULT_DATABASE, "test_function"});
    private static final UnresolvedIdentifier PARTIAL_UNRESOLVED_IDENTIFIER = UnresolvedIdentifier.of((String[])new String[]{"test_function"});
    private ModuleManager moduleManager;
    private FunctionCatalog functionCatalog;
    private Catalog catalog;

    FunctionCatalogTest() {
    }

    @BeforeEach
    void init() {
        this.catalog = new GenericInMemoryCatalog(CatalogManagerMocks.DEFAULT_CATALOG, CatalogManagerMocks.DEFAULT_DATABASE);
        this.moduleManager = new ModuleManager();
        Configuration configuration = new Configuration();
        this.functionCatalog = new FunctionCatalog((ReadableConfig)configuration, ResourceManager.createResourceManager((URL[])new URL[0], (ClassLoader)FunctionCatalogTest.class.getClassLoader(), (ReadableConfig)configuration), CatalogManagerMocks.preparedCatalogManager().defaultCatalog(CatalogManagerMocks.DEFAULT_CATALOG, this.catalog).build(), this.moduleManager);
    }

    @Test
    void testGetBuiltInFunctions() {
        HashSet actual = new HashSet();
        Collections.addAll(actual, this.functionCatalog.getFunctions());
        Set expected = new ModuleManager().listFunctions();
        Assertions.assertThat((boolean)actual.containsAll(expected)).isTrue();
    }

    @Test
    void testPreciseFunctionReference() throws Exception {
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).isEmpty();
        this.catalog.createFunction(IDENTIFIER.toObjectPath(), (CatalogFunction)new CatalogFunctionImpl(FUNCTION_1.getClass().getName()), false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_2, false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
    }

    @Test
    void testAmbiguousFunctionReference() throws Exception {
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).isEmpty();
        this.catalog.createFunction(IDENTIFIER.toObjectPath(), (CatalogFunction)new CatalogFunctionImpl(FUNCTION_1.getClass().getName()), false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_2, false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
        this.moduleManager.loadModule("test_module", (Module)new TestModule());
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_3));
        this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_4, false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_4));
    }

    @Test
    void testTemporarySystemFunction() {
        this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_1, false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_2, true);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_1));
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_2, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"A function named 'test_function' does already exist.")});
        Assertions.assertThat((boolean)this.functionCatalog.dropTemporarySystemFunction(NAME, false)).isTrue();
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).isEmpty();
        Assertions.assertThat((boolean)this.functionCatalog.dropTemporarySystemFunction(NAME, true)).isFalse();
        Assertions.assertThatThrownBy(() -> this.functionCatalog.dropTemporarySystemFunction(NAME, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"A function named 'test_function' doesn't exist.")});
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_INVALID, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Could not register temporary system function 'test_function' due to implementation errors.")});
    }

    @Test
    void testUninstantiatedTemporarySystemFunction() {
        this.functionCatalog.registerTemporarySystemFunction(NAME, FUNCTION_1.getClass().getName(), FunctionLanguage.JAVA, false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporarySystemFunction(NAME, FUNCTION_2.getClass().getName(), FunctionLanguage.JAVA, true);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_1));
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerTemporarySystemFunction(NAME, FUNCTION_2.getClass().getName(), FunctionLanguage.JAVA, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"A function named 'test_function' does already exist.")});
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerTemporarySystemFunction(NAME, FUNCTION_INVALID.getClass().getName(), FunctionLanguage.JAVA, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Could not register temporary system function 'test_function' due to implementation errors.")});
        this.functionCatalog.dropTemporarySystemFunction(NAME, true);
        this.functionCatalog.registerTemporarySystemFunction(NAME, TABLE_FUNCTION.getClass().getName(), FunctionLanguage.JAVA, false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((String)NAME), TABLE_FUNCTION));
        this.functionCatalog.dropTemporarySystemFunction(NAME, true);
        this.functionCatalog.registerTemporarySystemFunction(NAME, AGGREGATE_FUNCTION.getClass().getName(), FunctionLanguage.JAVA, false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((String)NAME), AGGREGATE_FUNCTION));
    }

    @Test
    void testCatalogFunction() {
        this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_1.getClass(), false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), true);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("A function '" + IDENTIFIER.asSummaryString() + "' does already exist."))});
        Assertions.assertThat((boolean)this.functionCatalog.dropCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, false)).isTrue();
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).isEmpty();
        Assertions.assertThat((boolean)this.functionCatalog.dropCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true)).isFalse();
        Assertions.assertThatThrownBy(() -> this.functionCatalog.dropCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("A function '" + IDENTIFIER.asSummaryString() + "' doesn't exist."))});
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_INVALID.getClass(), false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("Could not register catalog function '" + IDENTIFIER.asSummaryString() + "' due to implementation errors."))});
    }

    @Test
    void testTemporaryCatalogFunction() {
        this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_1, false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        Assertions.assertThatThrownBy(() -> this.functionCatalog.dropCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("A temporary function '" + IDENTIFIER.asSummaryString() + "' does already exist. Please drop the temporary function first."))});
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("A temporary function '" + IDENTIFIER.asSummaryString() + "' does already exist. Please drop the temporary function first."))});
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_1, true);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_2, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("A function '" + IDENTIFIER.asSummaryString() + "' does already exist."))});
        Assertions.assertThat((boolean)this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, false)).isTrue();
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
        Assertions.assertThat((boolean)this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true)).isFalse();
        Assertions.assertThatThrownBy(() -> this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("Temporary catalog function " + IDENTIFIER.toString() + " doesn't exist"))});
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_INVALID, false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("Could not register temporary catalog function '" + IDENTIFIER.asSummaryString() + "' due to implementation errors."))});
    }

    @Test
    void testUninstantiatedTemporaryCatalogFunction() {
        this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.permanent((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(FUNCTION_1.getClass().getName()), false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(FUNCTION_1.getClass().getName()), true);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        Assertions.assertThatThrownBy(() -> this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(FUNCTION_2.getClass().getName()), false)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("A function '" + IDENTIFIER.asSummaryString() + "' does already exist."))});
        Assertions.assertThatThrownBy(() -> {
            this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true);
            this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(FUNCTION_INVALID.getClass().getName()), false);
        }).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)("Could not register temporary catalog function '" + IDENTIFIER.asSummaryString() + "' due to implementation errors."))});
        this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true);
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(TABLE_FUNCTION.getClass().getName()), false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), TABLE_FUNCTION));
        this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true);
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(AGGREGATE_FUNCTION.getClass().getName()), false);
        Assertions.assertThat((Optional)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER)).hasValue((Object)ContextResolvedFunction.temporary((FunctionIdentifier)FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), AGGREGATE_FUNCTION));
    }

    public static class TestAggregateFunction
    extends AggregateFunction<String, String> {
        public String getValue(String accumulator) {
            return null;
        }

        public String createAccumulator() {
            return null;
        }

        public void accumulate(String in) {
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class TestTableFunction
    extends TableFunction<String> {
        public void eval(String in) {
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class InvalidTestFunction
    extends ScalarFunction {
    }

    public static class TestFunction4
    extends ScalarFunction {
        public String eval() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class TestFunction3
    extends ScalarFunction {
        public String eval() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class TestFunction2
    extends ScalarFunction {
        public String eval() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class TestFunction1
    extends ScalarFunction {
        public String eval() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    private static class TestModule
    implements Module {
        private TestModule() {
        }

        public Set<String> listFunctions() {
            return new HashSet<String>(){
                {
                    this.add(FunctionCatalogTest.NAME);
                }
            };
        }

        public Optional<FunctionDefinition> getFunctionDefinition(String name) {
            return Optional.of(FUNCTION_3);
        }
    }
}

