/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.legacy.api.TableSchema;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CatalogTableImpTest {
    private static final String TEST = "test";

    CatalogTableImpTest() {
    }

    @Test
    void testToProperties() {
        TableSchema schema = CatalogTableImpTest.createTableSchema();
        Map<String, String> prop = CatalogTableImpTest.createProperties();
        CatalogTableImpl table = new CatalogTableImpl(schema, CatalogTableImpTest.createPartitionKeys(), prop, TEST);
        DescriptorProperties descriptorProperties = new DescriptorProperties(false);
        descriptorProperties.putProperties(table.toProperties());
        Assertions.assertThat((Object)descriptorProperties.getTableSchema("schema")).isEqualTo((Object)schema);
    }

    @Test
    void testFromProperties() {
        TableSchema schema = CatalogTableImpTest.createTableSchema();
        Map<String, String> prop = CatalogTableImpTest.createProperties();
        CatalogTableImpl table = new CatalogTableImpl(schema, CatalogTableImpTest.createPartitionKeys(), prop, TEST);
        CatalogTableImpl tableFromProperties = CatalogTableImpl.fromProperties((Map)table.toProperties());
        Assertions.assertThat((Map)table.getOptions()).isEqualTo((Object)tableFromProperties.getOptions());
        Assertions.assertThat((List)table.getPartitionKeys()).isEqualTo((Object)tableFromProperties.getPartitionKeys());
        Assertions.assertThat((Object)table.getSchema()).isEqualTo((Object)tableFromProperties.getSchema());
    }

    @Test
    void testNullComment() {
        TableSchema schema = CatalogTableImpTest.createTableSchema();
        Map<String, String> prop = CatalogTableImpTest.createProperties();
        CatalogTableImpl table = new CatalogTableImpl(schema, CatalogTableImpTest.createPartitionKeys(), prop, null);
        Assertions.assertThat((String)table.getComment()).isEmpty();
        Assertions.assertThat((Optional)table.getDescription()).isEqualTo(Optional.of(""));
    }

    private static Map<String, String> createProperties() {
        return new HashMap<String, String>(){
            {
                this.put("k", "v");
                this.put("K1", "V1");
            }
        };
    }

    private static TableSchema createTableSchema() {
        return TableSchema.builder().field("first", DataTypes.STRING()).field("second", DataTypes.INT()).field("third", DataTypes.DOUBLE()).field("Fourth", DataTypes.BOOLEAN()).build();
    }

    private static List<String> createPartitionKeys() {
        return Arrays.asList("second", "third");
    }
}

