/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.utils;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.LookupCallExpression;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.DataType;

@Internal
public final class ApiExpressionUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;

    private ApiExpressionUtils() {
    }

    public static ValueLiteralExpression valueLiteral(Object value) {
        return new ValueLiteralExpression(value);
    }

    public static ValueLiteralExpression valueLiteral(Object value, DataType dataType) {
        return new ValueLiteralExpression(value, dataType);
    }

    public static TypeLiteralExpression typeLiteral(DataType dataType) {
        return new TypeLiteralExpression(dataType);
    }

    public static UnresolvedReferenceExpression unresolvedRef(String name) {
        return new UnresolvedReferenceExpression(name);
    }

    public static UnresolvedCallExpression unresolvedCall(FunctionDefinition functionDefinition, Expression ... args) {
        return new UnresolvedCallExpression(functionDefinition, Arrays.asList(args));
    }

    public static TableReferenceExpression tableRef(String name, Table table) {
        return new TableReferenceExpression(name, table.getQueryOperation());
    }

    public static LookupCallExpression lookupCall(String name, Expression ... args) {
        return new LookupCallExpression(name, Arrays.asList(args));
    }

    public static Expression toMonthInterval(Expression e, int multiplier) {
        return (Expression)ExpressionUtils.extractValue((Expression)e, Integer.class).map(v -> ApiExpressionUtils.intervalOfMonths(v * multiplier)).orElseThrow(() -> new ValidationException("Invalid constant for year-month interval: " + e));
    }

    public static ValueLiteralExpression intervalOfMillis(long millis) {
        return ApiExpressionUtils.valueLiteral(millis, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).notNull().bridgedTo(Long.class));
    }

    public static Expression toMilliInterval(Expression e, long multiplier) {
        return (Expression)ExpressionUtils.extractValue((Expression)e, Long.class).map(v -> ApiExpressionUtils.intervalOfMillis(v * multiplier)).orElseThrow(() -> new ValidationException("Invalid constant for day-time interval: " + e));
    }

    public static ValueLiteralExpression intervalOfMonths(int months) {
        return ApiExpressionUtils.valueLiteral(months, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).notNull().bridgedTo(Integer.class));
    }

    public static Expression toRowInterval(Expression e) {
        return (Expression)ExpressionUtils.extractValue((Expression)e, Long.class).map(ApiExpressionUtils::valueLiteral).orElseThrow(() -> new ValidationException("Invalid constant for row interval: " + e));
    }

    public static boolean isFunctionOfKind(Expression expression, FunctionKind kind) {
        if (expression instanceof UnresolvedCallExpression) {
            return ((UnresolvedCallExpression)expression).getFunctionDefinition().getKind() == kind;
        }
        if (expression instanceof CallExpression) {
            return ((CallExpression)expression).getFunctionDefinition().getKind() == kind;
        }
        return false;
    }

    public static boolean isFunction(Expression expression, BuiltInFunctionDefinition functionDefinition) {
        if (expression instanceof UnresolvedCallExpression) {
            return ((UnresolvedCallExpression)expression).getFunctionDefinition() == functionDefinition;
        }
        if (expression instanceof CallExpression) {
            return ((CallExpression)expression).getFunctionDefinition() == functionDefinition;
        }
        return false;
    }
}

