/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;

@Internal
public interface FunctionLookup {
    public Optional<Result> lookupFunction(String var1);

    default public Result lookupBuiltInFunction(BuiltInFunctionDefinition definition) {
        return this.lookupFunction(definition.getName()).orElseThrow(() -> new TableException(String.format("Required built-in function [%s] could not be found in any catalog.", definition.getName())));
    }

    public PlannerTypeInferenceUtil getPlannerTypeInferenceUtil();

    public static class Result {
        private final ObjectIdentifier objectIdentifier;
        private final FunctionDefinition functionDefinition;

        public Result(ObjectIdentifier objectIdentifier, FunctionDefinition functionDefinition) {
            this.objectIdentifier = objectIdentifier;
            this.functionDefinition = functionDefinition;
        }

        public ObjectIdentifier getObjectIdentifier() {
            return this.objectIdentifier;
        }

        public FunctionDefinition getFunctionDefinition() {
            return this.functionDefinition;
        }
    }
}

