/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.test.program.ConfigOptionTestStep;
import org.apache.flink.table.test.program.FunctionTestStep;
import org.apache.flink.table.test.program.SinkTestStep;
import org.apache.flink.table.test.program.SourceTestStep;
import org.apache.flink.table.test.program.SqlTestStep;
import org.apache.flink.table.test.program.StatementSetTestStep;
import org.apache.flink.table.test.program.TableApiTestStep;
import org.apache.flink.table.test.program.TemporalFunctionTestStep;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.util.Preconditions;

public class TableTestProgram {
    public final String id;
    public final String description;
    public final List<TestStep> setupSteps;
    public final List<TestStep> runSteps;

    private TableTestProgram(String id, String description, List<TestStep> setupSteps, List<TestStep> runSteps) {
        this.id = id;
        this.description = description;
        this.setupSteps = setupSteps;
        this.runSteps = runSteps;
    }

    public String toString() {
        return this.id;
    }

    public static Builder of(String id, String description) {
        return new Builder(id, description);
    }

    public List<SourceTestStep> getSetupSourceTestSteps() {
        EnumSet<TestStep.TestKind> sourceKinds = EnumSet.of(TestStep.TestKind.SOURCE_WITHOUT_DATA, TestStep.TestKind.SOURCE_WITH_DATA, TestStep.TestKind.SOURCE_WITH_RESTORE_DATA);
        return this.setupSteps.stream().filter(s -> sourceKinds.contains((Object)s.getKind())).map(SourceTestStep.class::cast).collect(Collectors.toList());
    }

    public List<SinkTestStep> getSetupSinkTestSteps() {
        EnumSet<TestStep.TestKind> sinkKinds = EnumSet.of(TestStep.TestKind.SINK_WITHOUT_DATA, TestStep.TestKind.SINK_WITH_DATA, TestStep.TestKind.SINK_WITH_RESTORE_DATA);
        return this.setupSteps.stream().filter(s -> sinkKinds.contains((Object)s.getKind())).map(SinkTestStep.class::cast).collect(Collectors.toList());
    }

    public List<ConfigOptionTestStep<?>> getSetupConfigOptionTestSteps() {
        return this.setupSteps.stream().filter(s -> s.getKind() == TestStep.TestKind.CONFIG).map(s -> (ConfigOptionTestStep)s).collect(Collectors.toList());
    }

    public List<FunctionTestStep> getSetupFunctionTestSteps() {
        return this.setupSteps.stream().filter(s -> s.getKind() == TestStep.TestKind.FUNCTION).map(FunctionTestStep.class::cast).collect(Collectors.toList());
    }

    public List<TemporalFunctionTestStep> getSetupTemporalFunctionTestSteps() {
        return this.setupSteps.stream().filter(s -> s.getKind() == TestStep.TestKind.TEMPORAL_FUNCTION).map(TemporalFunctionTestStep.class::cast).collect(Collectors.toList());
    }

    public SqlTestStep getRunSqlTestStep() {
        List sqlSteps = this.runSteps.stream().filter(s -> s.getKind() == TestStep.TestKind.SQL).collect(Collectors.toList());
        Preconditions.checkArgument((sqlSteps.size() == 1 ? 1 : 0) != 0, (Object)"Single SQL step expected.");
        return (SqlTestStep)sqlSteps.get(0);
    }

    public StatementSetTestStep getRunStatementSetTestStep() {
        List statementSetSteps = this.runSteps.stream().filter(s -> s.getKind() == TestStep.TestKind.STATEMENT_SET).collect(Collectors.toList());
        Preconditions.checkArgument((statementSetSteps.size() == 1 ? 1 : 0) != 0, (Object)"Single StatementSet step expected.");
        return (StatementSetTestStep)statementSetSteps.get(0);
    }

    public static class Builder {
        private final String id;
        private final String description;
        private final List<TestStep> setupSteps = new ArrayList<TestStep>();
        private final List<TestStep> runSteps = new ArrayList<TestStep>();

        private Builder(String id, String description) {
            this.id = id;
            this.description = description;
        }

        public Builder setupSql(String sql) {
            this.setupSteps.add(new SqlTestStep(sql));
            return this;
        }

        public <T> Builder setupConfig(ConfigOption<T> option, T value) {
            this.setupSteps.add(new ConfigOptionTestStep<T>(option, value));
            return this;
        }

        public Builder setupTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> function) {
            this.setupSteps.add(new FunctionTestStep(FunctionTestStep.FunctionPersistence.TEMPORARY, FunctionTestStep.FunctionBehavior.SYSTEM, name, function));
            return this;
        }

        public Builder setupTemporarySystemTemporalTableFunction(String name, String table, Expression timeAttribute, Expression primaryKey) {
            this.setupSteps.add(new TemporalFunctionTestStep(TemporalFunctionTestStep.FunctionBehavior.SYSTEM, name, table, timeAttribute, primaryKey));
            return this;
        }

        public Builder setupTemporaryCatalogFunction(String name, Class<? extends UserDefinedFunction> function) {
            this.setupSteps.add(new FunctionTestStep(FunctionTestStep.FunctionPersistence.TEMPORARY, FunctionTestStep.FunctionBehavior.CATALOG, name, function));
            return this;
        }

        public Builder setupCatalogFunction(String name, Class<? extends UserDefinedFunction> function) {
            this.setupSteps.add(new FunctionTestStep(FunctionTestStep.FunctionPersistence.PERSISTENT, FunctionTestStep.FunctionBehavior.CATALOG, name, function));
            return this;
        }

        public Builder setupTableSource(SourceTestStep sourceTestStep) {
            this.setupSteps.add(sourceTestStep);
            return this;
        }

        public Builder setupTableSink(SinkTestStep sinkTestStep) {
            this.setupSteps.add(sinkTestStep);
            return this;
        }

        public Builder runSql(String sql) {
            this.runSteps.add(new SqlTestStep(sql));
            return this;
        }

        public Builder runTableApi(Function<TableApiTestStep.TableEnvAccessor, Table> toTable, String sinkName) {
            this.runSteps.add(new TableApiTestStep(toTable, sinkName));
            return this;
        }

        public Builder runStatementSet(String ... sql) {
            this.runSteps.add(new StatementSetTestStep(Arrays.asList(sql)));
            return this;
        }

        public TableTestProgram build() {
            return new TableTestProgram(this.id, this.description, this.setupSteps, this.runSteps);
        }
    }
}

