/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.JsonExistsOnError;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.api.JsonQueryOnEmptyOrError;
import org.apache.flink.table.api.JsonQueryWrapper;
import org.apache.flink.table.api.JsonType;
import org.apache.flink.table.api.JsonValueOnEmptyOrError;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ValuesQueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.table.utils.FunctionLookupMock;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ExpressionSerializationTest {
    public static Stream<TestSpec> testData() {
        return Stream.of(TestSpec.forExpr((Expression)Expressions.uuid()).expectStr("UUID()"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").abs()).withField("f0", DataTypes.BIGINT()).expectStr("ABS(`f0`)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isLess((Object)123)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` < 123"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isLessOrEqual((Object)123)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` <= 123"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isEqual((Object)123)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` = 123"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isNotEqual((Object)123)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` <> 123"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isGreaterOrEqual((Object)123)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` >= 123"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isGreater((Object)123)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` > 123"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isNull()).withField("f0", DataTypes.BOOLEAN()).expectStr("`f0` IS NULL"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isNotNull()).withField("f0", DataTypes.BOOLEAN()).expectStr("`f0` IS NOT NULL"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isTrue()).withField("f0", DataTypes.BOOLEAN()).expectStr("`f0` IS TRUE"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isNotTrue()).withField("f0", DataTypes.BOOLEAN()).expectStr("`f0` IS NOT TRUE"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isFalse()).withField("f0", DataTypes.BOOLEAN()).expectStr("`f0` IS FALSE"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isNotFalse()).withField("f0", DataTypes.BOOLEAN()).expectStr("`f0` IS NOT FALSE"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").not()).withField("f0", DataTypes.BOOLEAN()).expectStr("NOT `f0`"), TestSpec.forExpr((Expression)Expressions.and((Object)Expressions.$((String)"f0").isNotNull(), (Object)Expressions.$((String)"f0").isLess((Object)420), (Object[])new Object[]{Expressions.$((String)"f0").isGreater((Object)123)})).withField("f0", DataTypes.BIGINT()).expectStr("(`f0` IS NOT NULL) AND (`f0` < 420) AND (`f0` > 123)"), TestSpec.forExpr((Expression)Expressions.or((Object)Expressions.$((String)"f0").isNotNull(), (Object)Expressions.$((String)"f0").isLess((Object)420), (Object[])new Object[]{Expressions.$((String)"f0").isGreater((Object)123)})).withField("f0", DataTypes.BIGINT()).expectStr("(`f0` IS NOT NULL) OR (`f0` < 420) OR (`f0` > 123)"), TestSpec.forExpr((Expression)Expressions.ifThenElse((Object)Expressions.$((String)"f0").isNotNull(), (Object)Expressions.$((String)"f0").plus((Object)420), (Object)Expressions.$((String)"f0").minus((Object)123))).withField("f0", DataTypes.BIGINT()).expectStr("CASE WHEN `f0` IS NOT NULL THEN `f0` + 420 ELSE `f0` - 123 END"), TestSpec.forExpr((Expression)((ApiExpression)Expressions.$((String)"f0").times((Object)3)).dividedBy((Object)Expressions.$((String)"f1"))).withField("f0", DataTypes.BIGINT()).withField("f1", DataTypes.BIGINT()).expectStr("(`f0` * 3) / `f1`"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").mod((Object)5)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` % 5"), TestSpec.forExpr((Expression)Expressions.negative((Object)Expressions.$((String)"f0"))).withField("f0", DataTypes.BIGINT()).expectStr("- `f0`"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").in(new Object[]{1, 2, 3, 4, 5})).withField("f0", DataTypes.INT()).expectStr("`f0` IN (1, 2, 3, 4, 5)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").cast(DataTypes.SMALLINT())).withField("f0", DataTypes.BIGINT()).expectStr("CAST(`f0` AS SMALLINT)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").tryCast(DataTypes.SMALLINT())).withField("f0", DataTypes.BIGINT()).expectStr("TRY_CAST(`f0` AS SMALLINT)"), TestSpec.forExpr((Expression)Expressions.array((Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f1"), "ABC"})).withField("f0", DataTypes.STRING()).withField("f1", DataTypes.STRING()).expectStr("ARRAY[`f0`, `f1`, 'ABC']"), TestSpec.forExpr((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object[])new Object[]{"ABC", "DEF"})).withField("f0", DataTypes.STRING()).withField("f1", DataTypes.STRING()).expectStr("MAP[`f0`, `f1`, 'ABC', 'DEF']"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").at((Object)2)).withField("f0", DataTypes.ARRAY((DataType)DataTypes.STRING())).expectStr("`f0`[2]"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").at((Object)"abc")).withField("f0", DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT())).expectStr("`f0`['abc']"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").between((Object)1, (Object)10)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` BETWEEN 1 AND 10"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").notBetween((Object)1, (Object)10)).withField("f0", DataTypes.BIGINT()).expectStr("`f0` NOT BETWEEN 1 AND 10"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").like((Object)"ABC")).withField("f0", DataTypes.STRING()).expectStr("`f0` LIKE 'ABC'"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").similar((Object)"ABC")).withField("f0", DataTypes.STRING()).expectStr("`f0` SIMILAR TO 'ABC'"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").position((Object)"ABC")).withField("f0", DataTypes.STRING()).expectStr("POSITION(`f0` IN 'ABC')"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").trim((Object)"ABC")).withField("f0", DataTypes.STRING()).expectStr("TRIM BOTH 'ABC' FROM `f0`"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").trimLeading((Object)"ABC")).withField("f0", DataTypes.STRING()).expectStr("TRIM LEADING 'ABC' FROM `f0`"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").trimTrailing((Object)"ABC")).withField("f0", DataTypes.STRING()).expectStr("TRIM TRAILING 'ABC' FROM `f0`"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").overlay((Object)"ABC", (Object)2)).withField("f0", DataTypes.STRING()).expectStr("OVERLAY(`f0` PLACING 'ABC' FROM 2)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").overlay((Object)"ABC", (Object)2, (Object)5)).withField("f0", DataTypes.STRING()).expectStr("OVERLAY(`f0` PLACING 'ABC' FROM 2 FOR 5)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").substr((Object)2)).withField("f0", DataTypes.STRING()).expectStr("SUBSTR(`f0`, 2)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").substr((Object)2, (Object)5)).withField("f0", DataTypes.STRING()).expectStr("SUBSTR(`f0`, 2, 5)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").substring((Object)2)).withField("f0", DataTypes.STRING()).expectStr("SUBSTRING(`f0` FROM 2)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").substring((Object)2, (Object)5)).withField("f0", DataTypes.STRING()).expectStr("SUBSTRING(`f0` FROM 2 FOR 5)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.HOUR)).withField("f0", DataTypes.TIMESTAMP()).expectStr("EXTRACT(HOUR FROM `f0`)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").floor(TimeIntervalUnit.HOUR)).withField("f0", DataTypes.TIMESTAMP()).expectStr("FLOOR(`f0` TO HOUR)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").ceil(TimeIntervalUnit.HOUR)).withField("f0", DataTypes.TIMESTAMP()).expectStr("CEIL(`f0` TO HOUR)"), TestSpec.forExpr((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f3"))).withField("f0", DataTypes.TIMESTAMP()).withField("f1", DataTypes.TIMESTAMP()).withField("f2", DataTypes.TIMESTAMP()).withField("f3", DataTypes.TIMESTAMP()).expectStr("(`f0`, `f1`) OVERLAPS (`f2`, `f3`)"), TestSpec.forExpr((Expression)((ApiExpression)Expressions.$((String)"f0").get("g0")).plus(((ApiExpression)Expressions.$((String)"f0").get("g1")).get("h1"))).withField("f0", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"g0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"g1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"h1", (DataType)DataTypes.BIGINT())}))})).expectStr("(`f0`.`g0`) + (`f0`.`g1`.`h1`)"), TestSpec.forExpr((Expression)((ApiExpression)Expressions.$((String)"f0").abs()).as("absolute`F0", new String[0])).withField("f0", DataTypes.BIGINT()).expectStr("(ABS(`f0`)) AS `absolute``F0`"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isJson()).withField("f0", DataTypes.STRING()).expectStr("`f0` IS JSON"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").isJson(JsonType.SCALAR)).withField("f0", DataTypes.STRING()).expectStr("`f0` IS JSON SCALAR"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").jsonExists("$.a")).withField("f0", DataTypes.STRING()).expectStr("JSON_EXISTS(`f0`, '$.a')"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").jsonExists("$.a", JsonExistsOnError.UNKNOWN)).withField("f0", DataTypes.STRING()).expectStr("JSON_EXISTS(`f0`, '$.a' UNKNOWN ON ERROR)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").jsonValue("$.a")).withField("f0", DataTypes.STRING()).expectStr("JSON_VALUE(`f0`, '$.a' RETURNING VARCHAR(2147483647) NULL ON EMPTY NULL ON ERROR)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").jsonValue("$.a", DataTypes.BOOLEAN(), (Object)false)).withField("f0", DataTypes.STRING()).expectStr("JSON_VALUE(`f0`, '$.a' RETURNING BOOLEAN DEFAULT FALSE ON EMPTY DEFAULT FALSE ON ERROR)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").jsonValue("$.a", DataTypes.BIGINT(), JsonValueOnEmptyOrError.DEFAULT, (Object)1, JsonValueOnEmptyOrError.ERROR, null)).withField("f0", DataTypes.STRING()).expectStr("JSON_VALUE(`f0`, '$.a' RETURNING BIGINT DEFAULT 1 ON EMPTY ERROR ON ERROR)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").jsonQuery("$.a")).withField("f0", DataTypes.STRING()).expectStr("JSON_QUERY(`f0`, '$.a' RETURNING VARCHAR(2147483647) WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").jsonQuery("$.a", JsonQueryWrapper.UNCONDITIONAL_ARRAY)).withField("f0", DataTypes.STRING()).expectStr("JSON_QUERY(`f0`, '$.a' RETURNING VARCHAR(2147483647) WITH UNCONDITIONAL ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)"), TestSpec.forExpr((Expression)Expressions.$((String)"f0").jsonQuery("$.a", JsonQueryWrapper.CONDITIONAL_ARRAY, JsonQueryOnEmptyOrError.EMPTY_OBJECT, JsonQueryOnEmptyOrError.EMPTY_ARRAY)).withField("f0", DataTypes.STRING()).expectStr("JSON_QUERY(`f0`, '$.a' RETURNING VARCHAR(2147483647) WITH CONDITIONAL ARRAY WRAPPER EMPTY OBJECT ON EMPTY EMPTY ARRAY ON ERROR)"), TestSpec.forExpr((Expression)Expressions.jsonObject((JsonOnNull)JsonOnNull.ABSENT, (Object[])new Object[]{"k1", Expressions.$((String)"f0"), "k2", 123})).withField("f0", DataTypes.STRING()).expectStr("JSON_OBJECT(KEY 'k1' VALUE `f0`, KEY 'k2' VALUE 123 ABSENT ON NULL)"), TestSpec.forExpr((Expression)Expressions.jsonArray((JsonOnNull)JsonOnNull.ABSENT, (Object[])new Object[]{"k1", Expressions.$((String)"f0"), "k2"})).withField("f0", DataTypes.STRING()).expectStr("JSON_ARRAY('k1', `f0`, 'k2' ABSENT ON NULL)"), TestSpec.forExpr((Expression)Expressions.jsonArrayAgg((JsonOnNull)JsonOnNull.ABSENT, (Object)Expressions.$((String)"f0"))).withField("f0", DataTypes.STRING()).expectStr("JSON_ARRAYAGG(`f0` ABSENT ON NULL)"), TestSpec.forExpr((Expression)Expressions.jsonArrayAgg((JsonOnNull)JsonOnNull.NULL, (Object)Expressions.$((String)"f0"))).withField("f0", DataTypes.STRING()).expectStr("JSON_ARRAYAGG(`f0` NULL ON NULL)"), TestSpec.forExpr((Expression)Expressions.jsonObjectAgg((JsonOnNull)JsonOnNull.ABSENT, (Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"))).withField("f0", DataTypes.STRING()).withField("f1", DataTypes.STRING()).expectStr("JSON_OBJECTAGG(KEY `f0` VALUE `f1` ABSENT ON NULL)"), TestSpec.forExpr((Expression)Expressions.jsonObjectAgg((JsonOnNull)JsonOnNull.NULL, (Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"))).withField("f0", DataTypes.STRING()).withField("f1", DataTypes.STRING()).expectStr("JSON_OBJECTAGG(KEY `f0` VALUE `f1` NULL ON NULL)"), TestSpec.forExpr((Expression)((ApiExpression)((ApiExpression)((ApiExpression)Expressions.$((String)"f0").count()).distinct()).plus(((ApiExpression)Expressions.$((String)"f0").avg()).distinct())).plus(Expressions.$((String)"f0").max())).withField("f0", DataTypes.BIGINT()).expectStr("((COUNT(DISTINCT `f0`)) + (AVG(DISTINCT `f0`))) + (MAX(`f0`))"));
    }

    @ParameterizedTest
    @MethodSource(value={"testData"})
    void testSerialization(TestSpec spec) {
        List resolved = ExpressionResolver.resolverFor((TableConfig)TableConfig.getDefault(), (ClassLoader)Thread.currentThread().getContextClassLoader(), name -> Optional.empty(), (FunctionLookup)new FunctionLookupMock(Collections.emptyMap()), (DataTypeFactory)new DataTypeFactoryMock(), (sqlExpression, inputRowType, outputType) -> null, (QueryOperation[])new QueryOperation[]{new ValuesQueryOperation(Collections.emptyList(), ResolvedSchema.of(new ArrayList(spec.columns.values())))}).build().resolve(Collections.singletonList(spec.expr));
        ((ListAssert)Assertions.assertThat((List)resolved).hasSize(1)).extracting(ResolvedExpression::asSerializableString).containsOnly((Object[])new String[]{spec.expectedStr});
    }

    private static class TestSpec {
        private final Expression expr;
        private String expectedStr;
        private final Map<String, Column> columns = new HashMap<String, Column>();

        public TestSpec(Expression expr) {
            this.expr = expr;
        }

        public static TestSpec forExpr(Expression expr) {
            return new TestSpec(expr);
        }

        public TestSpec withField(String name, DataType dataType) {
            this.columns.put(name, (Column)Column.physical((String)name, (DataType)dataType));
            return this;
        }

        public TestSpec expectStr(String expected) {
            this.expectedStr = expected;
            return this;
        }

        public String toString() {
            return this.expr.asSummaryString();
        }
    }
}

