/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogChange;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.CatalogStoreHolder;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalogStore;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.listener.AlterDatabaseEvent;
import org.apache.flink.table.catalog.listener.AlterTableEvent;
import org.apache.flink.table.catalog.listener.CatalogModificationEvent;
import org.apache.flink.table.catalog.listener.CatalogModificationListener;
import org.apache.flink.table.catalog.listener.CreateDatabaseEvent;
import org.apache.flink.table.catalog.listener.CreateTableEvent;
import org.apache.flink.table.catalog.listener.DropDatabaseEvent;
import org.apache.flink.table.catalog.listener.DropTableEvent;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.table.utils.ExpressionResolverMocks;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

class CatalogManagerTest {
    CatalogManagerTest() {
    }

    @Test
    void testDatabaseModificationEvent() throws Exception {
        CompletableFuture<CreateDatabaseEvent> createFuture = new CompletableFuture<CreateDatabaseEvent>();
        CompletableFuture<AlterDatabaseEvent> alterFuture = new CompletableFuture<AlterDatabaseEvent>();
        CompletableFuture<DropDatabaseEvent> dropFuture = new CompletableFuture<DropDatabaseEvent>();
        CatalogManager catalogManager = this.createCatalogManager(new TestingDatabaseModificationListener(createFuture, alterFuture, dropFuture));
        catalogManager.createDatabase(catalogManager.getCurrentCatalog(), "database1", (CatalogDatabase)new CatalogDatabaseImpl(Collections.singletonMap("key1", "val1"), "database1 comment"), true);
        CreateDatabaseEvent createDatabaseEvent = createFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((String)createDatabaseEvent.context().getCatalogName()).isEqualTo(catalogManager.getCurrentCatalog());
        Assertions.assertThat((boolean)createDatabaseEvent.ignoreIfExists()).isTrue();
        Assertions.assertThat((String)createDatabaseEvent.databaseName()).isEqualTo("database1");
        Assertions.assertThat((String)createDatabaseEvent.database().getComment()).isEqualTo("database1 comment");
        Assertions.assertThat((Map)createDatabaseEvent.database().getProperties()).isEqualTo(Collections.singletonMap("key1", "val1"));
        Assertions.assertThat((boolean)alterFuture.isDone()).isFalse();
        Assertions.assertThat((boolean)dropFuture.isDone()).isFalse();
        catalogManager.alterDatabase(catalogManager.getCurrentCatalog(), "database1", (CatalogDatabase)new CatalogDatabaseImpl(Collections.singletonMap("key1", "val_val1"), "database1 comment modified"), false);
        AlterDatabaseEvent alterDatabaseEvent = alterFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((String)alterDatabaseEvent.context().getCatalogName()).isEqualTo(catalogManager.getCurrentCatalog());
        Assertions.assertThat((boolean)alterDatabaseEvent.ignoreIfNotExists()).isFalse();
        Assertions.assertThat((String)alterDatabaseEvent.databaseName()).isEqualTo("database1");
        Assertions.assertThatThrownBy(() -> ((AlterDatabaseEvent)alterDatabaseEvent).database()).hasMessage("There is no database in AlterDatabaseEvent, use database name instead.");
        Assertions.assertThat((String)alterDatabaseEvent.newDatabase().getComment()).isEqualTo("database1 comment modified");
        Assertions.assertThat((Map)alterDatabaseEvent.newDatabase().getProperties()).isEqualTo(Collections.singletonMap("key1", "val_val1"));
        catalogManager.dropDatabase(catalogManager.getCurrentCatalog(), "database1", true, true);
        DropDatabaseEvent dropDatabaseEvent = dropFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((String)dropDatabaseEvent.context().getCatalogName()).isEqualTo(catalogManager.getCurrentCatalog());
        Assertions.assertThat((boolean)dropDatabaseEvent.ignoreIfNotExists()).isTrue();
        Assertions.assertThat((String)dropDatabaseEvent.databaseName()).isEqualTo("database1");
        Assertions.assertThatThrownBy(() -> ((DropDatabaseEvent)dropDatabaseEvent).database()).hasMessage("There is no database in DropDatabaseEvent, use database name instead.");
        Assertions.assertThat((boolean)dropDatabaseEvent.cascade()).isTrue();
    }

    @Test
    void testTableModificationListener() throws Exception {
        CompletableFuture<CreateTableEvent> createFuture = new CompletableFuture<CreateTableEvent>();
        CompletableFuture<CreateTableEvent> createTemporaryFuture = new CompletableFuture<CreateTableEvent>();
        CompletableFuture<AlterTableEvent> alterFuture = new CompletableFuture<AlterTableEvent>();
        CompletableFuture<DropTableEvent> dropFuture = new CompletableFuture<DropTableEvent>();
        CompletableFuture<DropTableEvent> dropTemporaryFuture = new CompletableFuture<DropTableEvent>();
        CatalogManager catalogManager = this.createCatalogManager(new TestingTableModificationListener(createFuture, createTemporaryFuture, alterFuture, dropFuture, dropTemporaryFuture));
        catalogManager.initSchemaResolver(true, ExpressionResolverMocks.dummyResolver());
        catalogManager.createTable((CatalogBaseTable)CatalogView.of((Schema)Schema.newBuilder().build(), null, (String)"", (String)"", Collections.emptyMap()), ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"view1"), true);
        Assertions.assertThat((boolean)createFuture.isDone()).isFalse();
        catalogManager.createTable((CatalogBaseTable)CatalogTable.of((Schema)Schema.newBuilder().build(), null, Collections.emptyList(), Collections.emptyMap()), ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"table1"), true);
        CreateTableEvent createEvent = createFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)createEvent.isTemporary()).isFalse();
        Assertions.assertThat((String)createEvent.identifier().getObjectName()).isEqualTo("table1");
        Assertions.assertThat((boolean)createEvent.ignoreIfExists()).isTrue();
        catalogManager.createTemporaryTable((CatalogBaseTable)CatalogTable.of((Schema)Schema.newBuilder().build(), null, Collections.emptyList(), Collections.emptyMap()), ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"table2"), false);
        CreateTableEvent createTemporaryEvent = createTemporaryFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)createTemporaryEvent.isTemporary()).isTrue();
        Assertions.assertThat((String)createTemporaryEvent.identifier().getObjectName()).isEqualTo("table2");
        Assertions.assertThat((boolean)createTemporaryEvent.ignoreIfExists()).isFalse();
        catalogManager.alterTable((CatalogBaseTable)CatalogTable.of((Schema)Schema.newBuilder().build(), (String)"table1 comment", Collections.emptyList(), Collections.emptyMap()), ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"table1"), false);
        AlterTableEvent alterEvent = alterFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)alterEvent.isTemporary()).isFalse();
        Assertions.assertThat((String)alterEvent.identifier().getObjectName()).isEqualTo("table1");
        Assertions.assertThat((String)alterEvent.newTable().getComment()).isEqualTo("table1 comment");
        Assertions.assertThat((boolean)alterEvent.ignoreIfNotExists()).isFalse();
        catalogManager.dropView(ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"table1"), true);
        Assertions.assertThat((boolean)dropFuture.isDone()).isFalse();
        catalogManager.dropTable(ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"table1"), true);
        DropTableEvent dropEvent = dropFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)dropEvent.isTemporary()).isFalse();
        Assertions.assertThat((boolean)dropEvent.ignoreIfNotExists()).isTrue();
        Assertions.assertThat((String)dropEvent.identifier().getObjectName()).isEqualTo("table1");
        catalogManager.createTemporaryTable((CatalogBaseTable)CatalogView.of((Schema)Schema.newBuilder().build(), null, (String)"", (String)"", Collections.emptyMap()), ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"view2"), false);
        catalogManager.dropTemporaryView(ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"view2"), true);
        Assertions.assertThat((boolean)dropTemporaryFuture.isDone()).isFalse();
        catalogManager.dropTemporaryTable(ObjectIdentifier.of((String)catalogManager.getCurrentCatalog(), (String)catalogManager.getCurrentDatabase(), (String)"table2"), false);
        DropTableEvent dropTemporaryEvent = dropTemporaryFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)dropTemporaryEvent.isTemporary()).isTrue();
        Assertions.assertThat((boolean)dropTemporaryEvent.ignoreIfNotExists()).isFalse();
        Assertions.assertThat((String)dropTemporaryEvent.identifier().getObjectName()).isEqualTo("table2");
    }

    @Test
    public void testDropCurrentDatabase() throws Exception {
        CatalogManager catalogManager = this.createCatalogManager(null);
        catalogManager.createDatabase("default", "dummy", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), null), false);
        catalogManager.setCurrentDatabase("dummy");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalogManager.dropDatabase("default", "dummy", false, false)).isInstanceOf(ValidationException.class)).hasMessage("Cannot drop a database which is currently in use.");
    }

    private CatalogManager createCatalogManager(@Nullable CatalogModificationListener listener) {
        CatalogManager.Builder builder = CatalogManager.newBuilder().classLoader(CatalogManagerTest.class.getClassLoader()).config((ReadableConfig)new Configuration()).defaultCatalog("default", (Catalog)new GenericInMemoryCatalog("default")).catalogStoreHolder(CatalogStoreHolder.newBuilder().catalogStore((CatalogStore)new GenericInMemoryCatalogStore()).config((ReadableConfig)new Configuration()).classloader(CatalogManagerTest.class.getClassLoader()).build());
        if (listener != null) {
            builder.catalogModificationListeners(Collections.singletonList(listener));
        }
        return builder.build();
    }

    @Test
    void testCatalogStore() throws Exception {
        GenericInMemoryCatalogStore catalogStore = new GenericInMemoryCatalogStore();
        Configuration configuration = new Configuration();
        configuration.setString("type", "generic_in_memory");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CatalogManagerTest.lambda$testCatalogStore$1((CatalogStore)catalogStore, configuration)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("CatalogStore is not opened yet.");
        CatalogManager catalogManager = CatalogManagerMocks.createCatalogManager((CatalogStore)catalogStore);
        catalogStore.storeCatalog("exist_cat", CatalogDescriptor.of((String)"exist_cat", (Configuration)configuration));
        catalogManager.createCatalog("cat1", CatalogDescriptor.of((String)"cat1", (Configuration)configuration));
        catalogManager.createCatalog("cat2", CatalogDescriptor.of((String)"cat2", (Configuration)configuration));
        catalogManager.createCatalog("cat3", CatalogDescriptor.of((String)"cat3", (Configuration)configuration));
        catalogManager.createCatalog("cat_comment", CatalogDescriptor.of((String)"cat_comment", (Configuration)configuration.clone(), (String)"comment for catalog"));
        catalogManager.createCatalog("cat_comment", CatalogDescriptor.of((String)"cat_comment", (Configuration)configuration.clone(), (String)"second comment for catalog"), true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalogManager.createCatalog("cat_comment", CatalogDescriptor.of((String)"cat_comment", (Configuration)configuration.clone(), (String)"third comment for catalog"), false)).isInstanceOf(CatalogException.class)).hasMessage("Catalog cat_comment already exists.");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.getCatalog("cat1").isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.getCatalog("cat2").isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.getCatalog("cat3").isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.getCatalog("cat_comment").isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.getCatalogDescriptor("cat_comment").isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"comment for catalog", ((CatalogDescriptor)catalogManager.getCatalogDescriptor("cat_comment").get()).getComment().get());
        Assertions.assertThat((Optional)catalogManager.getCatalog("cat_comment")).isPresent();
        ((OptionalAssert)Assertions.assertThat((Optional)catalogManager.getCatalogDescriptor("cat_comment")).isPresent()).hasValueSatisfying(descriptor -> {
            OptionalAssert cfr_ignored_0 = (OptionalAssert)((OptionalAssert)Assertions.assertThat((Optional)descriptor.getComment()).isPresent()).hasValueSatisfying(comment -> org.junit.jupiter.api.Assertions.assertEquals((Object)"comment for catalog", (Object)comment));
        });
        catalogManager.alterCatalog("cat_comment", (CatalogChange)new CatalogChange.CatalogConfigurationChange(conf -> conf.setString("default-database", "db")));
        catalogManager.alterCatalog("cat_comment", (CatalogChange)new CatalogChange.CatalogCommentChange("new comment"));
        ((OptionalAssert)Assertions.assertThat((Optional)catalogManager.getCatalogDescriptor("cat_comment")).isPresent()).hasValueSatisfying(descriptor -> {
            Assertions.assertThat((Map)descriptor.getConfiguration().toMap()).containsEntry((Object)"default-database", (Object)"db");
            ((OptionalAssert)Assertions.assertThat((Optional)descriptor.getComment()).isPresent()).hasValueSatisfying(comment -> org.junit.jupiter.api.Assertions.assertEquals((Object)"new comment", (Object)comment));
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.listCatalogs().contains("cat1"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.listCatalogs().contains("cat2"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.listCatalogs().contains("cat3"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)catalogManager.listCatalogs().contains("cat_comment"));
        catalogManager.registerCatalog("cat4", (Catalog)new GenericInMemoryCatalog("cat4"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalogManager.createCatalog("cat1", CatalogDescriptor.of((String)"cat1", (Configuration)configuration))).isInstanceOf(CatalogException.class)).hasMessageContaining("Catalog cat1 already exists.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalogManager.createCatalog("cat4", CatalogDescriptor.of((String)"cat4", (Configuration)configuration))).isInstanceOf(CatalogException.class)).hasMessageContaining("Catalog cat4 already exists.");
        catalogManager.createDatabase("exist_cat", "cat_db", (CatalogDatabase)new CatalogDatabaseImpl(Collections.emptyMap(), "database for exist_cat"), false);
        catalogManager.createTable((CatalogBaseTable)CatalogTable.of((Schema)Schema.newBuilder().build(), null, Collections.emptyList(), Collections.emptyMap()), ObjectIdentifier.of((String)"exist_cat", (String)"cat_db", (String)"test_table"), false);
        Assertions.assertThat((Collection)catalogManager.listSchemas("exist_cat")).isEqualTo(new HashSet<String>(Arrays.asList("default", "cat_db")));
        Assertions.assertThat((Collection)catalogManager.listTables("exist_cat", "cat_db")).isEqualTo(Collections.singleton("test_table"));
        catalogManager.setCurrentCatalog("exist_cat");
        Assertions.assertThat((Collection)catalogManager.listSchemas()).isEqualTo(new HashSet<String>(Arrays.asList("cat1", "cat2", "cat3", "cat4", "default_catalog", "exist_cat", "cat_comment")));
        catalogManager.setCurrentDatabase("cat_db");
        Assertions.assertThat((Collection)catalogManager.listTables()).isEqualTo(Collections.singleton("test_table"));
        catalogManager.unregisterCatalog("cat1", false);
        catalogManager.unregisterCatalog("cat2", false);
        catalogManager.unregisterCatalog("cat3", false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalogManager.listCatalogs().contains("cat1"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalogManager.listCatalogs().contains("cat2"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)catalogManager.listCatalogs().contains("cat3"));
        catalogManager.close();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalogManager.listCatalogs()).isInstanceOf(IllegalStateException.class)).hasMessageContaining("CatalogStore is not opened yet.");
    }

    private static /* synthetic */ void lambda$testCatalogStore$1(CatalogStore catalogStore, Configuration configuration) throws Throwable {
        catalogStore.storeCatalog("cat1", CatalogDescriptor.of((String)"cat1", (Configuration)configuration));
    }

    static class TestingTableModificationListener
    implements CatalogModificationListener {
        private final CompletableFuture<CreateTableEvent> createFuture;
        private final CompletableFuture<CreateTableEvent> createTemporaryFuture;
        private final CompletableFuture<AlterTableEvent> alterFuture;
        private final CompletableFuture<DropTableEvent> dropFuture;
        private final CompletableFuture<DropTableEvent> dropTemporaryFuture;

        TestingTableModificationListener(CompletableFuture<CreateTableEvent> createFuture, CompletableFuture<CreateTableEvent> createTemporaryFuture, CompletableFuture<AlterTableEvent> alterFuture, CompletableFuture<DropTableEvent> dropFuture, CompletableFuture<DropTableEvent> dropTemporaryFuture) {
            this.createFuture = createFuture;
            this.createTemporaryFuture = createTemporaryFuture;
            this.alterFuture = alterFuture;
            this.dropFuture = dropFuture;
            this.dropTemporaryFuture = dropTemporaryFuture;
        }

        public void onEvent(CatalogModificationEvent event) {
            if (event instanceof CreateTableEvent) {
                if (((CreateTableEvent)event).isTemporary()) {
                    this.createTemporaryFuture.complete((CreateTableEvent)event);
                } else {
                    this.createFuture.complete((CreateTableEvent)event);
                }
            } else if (event instanceof AlterTableEvent) {
                this.alterFuture.complete((AlterTableEvent)event);
            } else if (event instanceof DropTableEvent) {
                if (((DropTableEvent)event).isTemporary()) {
                    this.dropTemporaryFuture.complete((DropTableEvent)event);
                } else {
                    this.dropFuture.complete((DropTableEvent)event);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class TestingDatabaseModificationListener
    implements CatalogModificationListener {
        private final CompletableFuture<CreateDatabaseEvent> createFuture;
        private final CompletableFuture<AlterDatabaseEvent> alterFuture;
        private final CompletableFuture<DropDatabaseEvent> dropFuture;

        TestingDatabaseModificationListener(CompletableFuture<CreateDatabaseEvent> createFuture, CompletableFuture<AlterDatabaseEvent> alterFuture, CompletableFuture<DropDatabaseEvent> dropFuture) {
            this.createFuture = createFuture;
            this.alterFuture = alterFuture;
            this.dropFuture = dropFuture;
        }

        public void onEvent(CatalogModificationEvent event) {
            if (event instanceof CreateDatabaseEvent) {
                this.createFuture.complete((CreateDatabaseEvent)event);
            } else if (event instanceof AlterDatabaseEvent) {
                this.alterFuture.complete((AlterDatabaseEvent)event);
            } else if (event instanceof DropDatabaseEvent) {
                this.dropFuture.complete((DropDatabaseEvent)event);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }
}

