/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.FormatDescriptor;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TableDescriptorTest {
    private static final ConfigOption<Boolean> OPTION_A = ConfigOptions.key((String)"a").booleanType().noDefaultValue();
    private static final ConfigOption<Integer> OPTION_B = ConfigOptions.key((String)"b").intType().noDefaultValue();
    private static final ConfigOption<String> KEY_FORMAT = ConfigOptions.key((String)"key.format").stringType().noDefaultValue();

    TableDescriptorTest() {
    }

    @Test
    void testBasic() {
        Schema schema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).column("f1", (AbstractDataType)DataTypes.BIGINT()).primaryKey(new String[]{"f0"}).build();
        TableDescriptor descriptor = TableDescriptor.forConnector((String)"test-connector").schema(schema).distributedByHash(1, new String[]{"f0"}).partitionedBy(new String[]{"f0"}).comment("Test Comment").build();
        Assertions.assertThat((Optional)descriptor.getSchema()).isPresent();
        Assertions.assertThat(descriptor.getSchema().get()).isEqualTo((Object)schema);
        Assertions.assertThat((Optional)descriptor.getDistribution()).contains((Object)TableDistribution.ofHash(Collections.singletonList("f0"), (Integer)1));
        Assertions.assertThat((List)descriptor.getPartitionKeys()).hasSize(1);
        Assertions.assertThat((String)((String)descriptor.getPartitionKeys().get(0))).isEqualTo("f0");
        Assertions.assertThat((Map)descriptor.getOptions()).hasSize(1);
        Assertions.assertThat((String)((String)descriptor.getOptions().get("connector"))).isEqualTo("test-connector");
        Assertions.assertThat((String)descriptor.getComment().orElse(null)).isEqualTo("Test Comment");
    }

    @Test
    void testNoSchema() {
        TableDescriptor descriptor = TableDescriptor.forConnector((String)"test-connector").build();
        Assertions.assertThat((Optional)descriptor.getSchema()).isNotPresent();
    }

    @Test
    void testOptions() {
        TableDescriptor descriptor = TableDescriptor.forConnector((String)"test-connector").schema(Schema.newBuilder().build()).option(OPTION_A, (Object)false).option(OPTION_B, (Object)42).option("c", "C").build();
        Assertions.assertThat((Map)descriptor.getOptions()).hasSize(4);
        Assertions.assertThat((String)((String)descriptor.getOptions().get("connector"))).isEqualTo("test-connector");
        Assertions.assertThat((String)((String)descriptor.getOptions().get("a"))).isEqualTo("false");
        Assertions.assertThat((String)((String)descriptor.getOptions().get("b"))).isEqualTo("42");
        Assertions.assertThat((String)((String)descriptor.getOptions().get("c"))).isEqualTo("C");
    }

    @Test
    void testFormatBasic() {
        TableDescriptor descriptor = TableDescriptor.forConnector((String)"test-connector").schema(Schema.newBuilder().build()).format("json").build();
        Assertions.assertThat((Map)descriptor.getOptions()).hasSize(2);
        Assertions.assertThat((String)((String)descriptor.getOptions().get("connector"))).isEqualTo("test-connector");
        Assertions.assertThat((String)((String)descriptor.getOptions().get("format"))).isEqualTo("json");
    }

    @Test
    void testFormatWithFormatDescriptor() {
        TableDescriptor descriptor = TableDescriptor.forConnector((String)"test-connector").schema(Schema.newBuilder().build()).format(KEY_FORMAT, FormatDescriptor.forFormat((String)"test-format").option(OPTION_A, (Object)true).option(OPTION_B, (Object)42).option("c", "C").build()).build();
        Assertions.assertThat((Map)descriptor.getOptions()).hasSize(5);
        Assertions.assertThat((String)((String)descriptor.getOptions().get("connector"))).isEqualTo("test-connector");
        Assertions.assertThat((String)((String)descriptor.getOptions().get("key.format"))).isEqualTo("test-format");
        Assertions.assertThat((String)((String)descriptor.getOptions().get("key.test-format.a"))).isEqualTo("true");
        Assertions.assertThat((String)((String)descriptor.getOptions().get("key.test-format.b"))).isEqualTo("42");
        Assertions.assertThat((String)((String)descriptor.getOptions().get("key.test-format.c"))).isEqualTo("C");
    }

    @Test
    void testToString() {
        Schema schema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build();
        FormatDescriptor formatDescriptor = FormatDescriptor.forFormat((String)"test-format").option(OPTION_A, (Object)false).build();
        TableDescriptor tableDescriptor = TableDescriptor.forConnector((String)"test-connector").schema(schema).distributedByRange(3, new String[]{"f0"}).partitionedBy(new String[]{"f0"}).option(OPTION_A, (Object)true).format(formatDescriptor).comment("Test Comment").build();
        Assertions.assertThat((String)formatDescriptor.toString()).isEqualTo("test-format[{a=false}]");
        Assertions.assertThat((String)tableDescriptor.toString()).isEqualTo("(\n  `f0` STRING\n)\nCOMMENT 'Test Comment'\nDISTRIBUTED BY RANGE(`f0`) INTO 3 BUCKETS\nPARTITIONED BY (`f0`)\nWITH (\n  'a' = 'true',\n  'connector' = 'test-connector',\n  'test-format.a' = 'false',\n  'format' = 'test-format'\n)");
    }

    @Test
    void testFormatDescriptorWithPrefix() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.forConnector((String)"test-connector").schema(Schema.newBuilder().build()).format(FormatDescriptor.forFormat((String)"test-format").option("test-format.a", "A").build()).build()).as("Format options set using #format(FormatDescriptor) should not contain the prefix 'test-format.', but found 'test-format.a'.", new Object[0])).isInstanceOf(ValidationException.class);
    }

    @Test
    void testDistributedBy() {
        Assertions.assertThat((String)TableDescriptorTest.getTableDescriptorBuilder().distributedByHash(3, new String[]{"f0"}).build().toString()).contains(new CharSequence[]{"DISTRIBUTED BY HASH(`f0`) INTO 3 BUCKETS\n"});
        Assertions.assertThat((String)TableDescriptorTest.getTableDescriptorBuilder().distributedByHash(new String[]{"f0"}).build().toString()).contains(new CharSequence[]{"DISTRIBUTED BY HASH(`f0`)\n"});
        Assertions.assertThat((String)TableDescriptorTest.getTableDescriptorBuilder().distributedByRange(3, new String[]{"f0"}).build().toString()).contains(new CharSequence[]{"DISTRIBUTED BY RANGE(`f0`) INTO 3 BUCKETS\n"});
        Assertions.assertThat((String)TableDescriptorTest.getTableDescriptorBuilder().distributedByRange(new String[]{"f0"}).build().toString()).contains(new CharSequence[]{"DISTRIBUTED BY RANGE(`f0`)\n"});
        Assertions.assertThat((String)TableDescriptorTest.getTableDescriptorBuilder().distributedBy(3, new String[]{"f0"}).build().toString()).contains(new CharSequence[]{"DISTRIBUTED BY (`f0`) INTO 3 BUCKETS\n"});
        Assertions.assertThat((String)TableDescriptorTest.getTableDescriptorBuilder().distributedBy(new String[]{"f0"}).build().toString()).contains(new CharSequence[]{"DISTRIBUTED BY (`f0`)\n"});
        Assertions.assertThat((String)TableDescriptorTest.getTableDescriptorBuilder().distributedInto(3).build().toString()).contains(new CharSequence[]{"DISTRIBUTED INTO 3 BUCKETS\n"});
    }

    @Test
    void testDistributedByExceptions() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptorTest.getTableDescriptorBuilder().distributedByHash(3, new String[0])).as("At least one bucket key must be defined for a distribution.", new Object[0])).isInstanceOf(ValidationException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptorTest.getTableDescriptorBuilder().distributedBy(new String[0])).as("At least one bucket key must be defined for a distribution.", new Object[0])).isInstanceOf(ValidationException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptorTest.getTableDescriptorBuilder().distributedByRange(3, new String[0])).as("At least one bucket key must be defined for a distribution.", new Object[0])).isInstanceOf(ValidationException.class);
    }

    private static TableDescriptor.Builder getTableDescriptorBuilder() {
        Schema schema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build();
        FormatDescriptor formatDescriptor = FormatDescriptor.forFormat((String)"test-format").option(OPTION_A, (Object)false).build();
        return TableDescriptor.forConnector((String)"test-connector").schema(schema).partitionedBy(new String[]{"f0"}).option(OPTION_A, (Object)true).format(formatDescriptor).comment("Test Comment");
    }
}

