/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ShowColumnsOperation;

@Internal
public class DescribeTableOperation
implements Operation,
ExecutableOperation {
    private final ObjectIdentifier sqlIdentifier;
    private final boolean isExtended;

    public DescribeTableOperation(ObjectIdentifier sqlIdentifier, boolean isExtended) {
        this.sqlIdentifier = sqlIdentifier;
        this.isExtended = isExtended;
    }

    public ObjectIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.sqlIdentifier);
        params.put("isExtended", this.isExtended);
        return OperationUtils.formatWithChildren("DESCRIBE", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ShowColumnsOperation showColumns = new ShowColumnsOperation(this.sqlIdentifier, null, false, false, "FROM");
        return showColumns.execute(ctx);
    }
}

