/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.catalog.stats.Date;
import org.apache.flink.table.operations.ddl.AnalyzeTableOperation;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class AnalyzeTableUtil {
    private AnalyzeTableUtil() {
    }

    public static TableResultInternal analyzeTable(TableEnvironmentImpl tableEnv, AnalyzeTableOperation operation) throws TableNotExistException, PartitionNotExistException, TablePartitionedException {
        List<Column> columns = operation.getColumns();
        Catalog catalog = tableEnv.getCatalogManager().getCatalog(operation.getTableIdentifier().getCatalogName()).orElseThrow(() -> new TableException("This should not happen."));
        ObjectPath objectPath = operation.getTableIdentifier().toObjectPath();
        if (operation.getPartitionSpecs().isPresent()) {
            List<CatalogPartitionSpec> targetPartitions = operation.getPartitionSpecs().get();
            if (targetPartitions.isEmpty()) {
                return TableResultImpl.TABLE_RESULT_OK;
            }
            String statSql = AnalyzeTableUtil.generateAnalyzeSqlForMultiParts(operation.getTableIdentifier(), targetPartitions, columns);
            int partitionCount = targetPartitions.size();
            Map<Integer, StatisticsWrapper> results = AnalyzeTableUtil.executeSqlAndGenerateStatisticsForMultiParts(tableEnv, columns, statSql, partitionCount);
            for (int i = 0; i < partitionCount; ++i) {
                StatisticsWrapper result = results.get(i);
                CatalogPartitionSpec partitionSpec = targetPartitions.get(i);
                catalog.alterPartitionStatistics(objectPath, partitionSpec, result.tableStat, false);
                CatalogColumnStatistics newColumnStat = result.columnStat;
                if (newColumnStat == null) continue;
                CatalogColumnStatistics oldColumnStat = catalog.getPartitionColumnStatistics(objectPath, partitionSpec);
                CatalogColumnStatistics mergedColumnStatistics = AnalyzeTableUtil.mergeColumnStatistics(oldColumnStat, newColumnStat);
                catalog.alterPartitionColumnStatistics(objectPath, partitionSpec, mergedColumnStatistics, false);
            }
        } else {
            String statSql = AnalyzeTableUtil.generateAnalyzeSql(operation.getTableIdentifier(), null, columns, -1);
            StatisticsWrapper result = AnalyzeTableUtil.executeSqlAndGenerateStatistics(tableEnv, columns, statSql);
            catalog.alterTableStatistics(objectPath, result.tableStat, false);
            CatalogColumnStatistics newColumnStat = result.columnStat;
            if (newColumnStat != null) {
                CatalogColumnStatistics oldColumnStat = catalog.getTableColumnStatistics(objectPath);
                CatalogColumnStatistics mergedColumnStatistics = AnalyzeTableUtil.mergeColumnStatistics(oldColumnStat, newColumnStat);
                catalog.alterTableColumnStatistics(objectPath, mergedColumnStatistics, false);
            }
        }
        return TableResultImpl.TABLE_RESULT_OK;
    }

    private static CatalogColumnStatistics mergeColumnStatistics(CatalogColumnStatistics oldColumnStatistics, CatalogColumnStatistics newColumnStatistics) {
        CatalogColumnStatistics columnStatistics = oldColumnStatistics.copy();
        columnStatistics.getColumnStatisticsData().putAll(newColumnStatistics.getColumnStatisticsData());
        return columnStatistics;
    }

    private static StatisticsWrapper executeSqlAndGenerateStatistics(TableEnvironmentImpl tableEnv, List<Column> columns, String statSql) {
        TableResult tableResult = tableEnv.executeSql(statSql);
        List result = CollectionUtil.iteratorToList(tableResult.collect());
        Preconditions.checkArgument((result.size() == 1 ? 1 : 0) != 0);
        Row row = (Row)result.get(0);
        CatalogTableStatistics tableStat = AnalyzeTableUtil.convertToTableStatistics(row);
        CatalogColumnStatistics columnStat = null;
        if (!columns.isEmpty()) {
            columnStat = AnalyzeTableUtil.convertToColumnStatistics(row, columns);
        }
        return new StatisticsWrapper(tableStat, columnStat);
    }

    private static Map<Integer, StatisticsWrapper> executeSqlAndGenerateStatisticsForMultiParts(TableEnvironmentImpl tableEnv, List<Column> columns, String statSql, int partitionCount) {
        TableResult tableResult = tableEnv.executeSql(statSql);
        List result = CollectionUtil.iteratorToList(tableResult.collect());
        Preconditions.checkArgument((result.size() == partitionCount ? 1 : 0) != 0);
        HashMap<Integer, StatisticsWrapper> map = new HashMap<Integer, StatisticsWrapper>();
        for (Row row : result) {
            CatalogTableStatistics tableStat = AnalyzeTableUtil.convertToTableStatistics(row);
            CatalogColumnStatistics columnStat = null;
            if (!columns.isEmpty()) {
                columnStat = AnalyzeTableUtil.convertToColumnStatistics(row, columns);
            }
            int index = (Integer)row.getFieldAs(AnalyzeTableUtil.getPartitionIdxColumn());
            map.put(index, new StatisticsWrapper(tableStat, columnStat));
        }
        return map;
    }

    private static String generateAnalyzeSqlForMultiParts(ObjectIdentifier tableIdentifier, List<CatalogPartitionSpec> partitionSpecs, List<Column> columns) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < partitionSpecs.size(); ++i) {
            sqlList.add(AnalyzeTableUtil.generateAnalyzeSql(tableIdentifier, partitionSpecs.get(i), columns, i));
        }
        return String.join((CharSequence)"\n UNION ALL \n", sqlList);
    }

    private static String generateAnalyzeSql(ObjectIdentifier tableIdentifier, @Nullable CatalogPartitionSpec partitionSpec, List<Column> columns, int index) {
        String partitionFilter = partitionSpec != null ? " WHERE " + partitionSpec.getPartitionSpec().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(" AND ")) : "";
        String columnStatsSelects = columns.isEmpty() ? "" : ", " + AnalyzeTableUtil.getColumnStatsSelects(columns);
        return String.format("SELECT COUNT(1) AS %s %s %s FROM %s %s", AnalyzeTableUtil.getRowCountColumn(), columnStatsSelects, index >= 0 ? String.format(", %s as %s", index, AnalyzeTableUtil.getPartitionIdxColumn()) : "", tableIdentifier, partitionFilter);
    }

    private static String getColumnStatsSelects(List<Column> columns) {
        return columns.stream().flatMap(f -> {
            String c = f.getName();
            ArrayList<String> columnStatSelect = new ArrayList<String>();
            String computeNullCount = String.format("(COUNT(1) - COUNT(`%s`)) AS %s", c, AnalyzeTableUtil.getNullCountColumn(c));
            columnStatSelect.add(computeNullCount);
            String computeNdv = String.format("APPROX_COUNT_DISTINCT(`%s`) AS %s", c, AnalyzeTableUtil.getNdvColumn(c));
            switch (f.getDataType().getLogicalType().getTypeRoot()) {
                case BOOLEAN: {
                    columnStatSelect.add(String.format("COUNT(`%s`) FILTER (WHERE `%s` IS TRUE) AS %s", c, c, AnalyzeTableUtil.getTrueCountColumn(c)));
                    columnStatSelect.add(String.format("COUNT(`%s`) FILTER (WHERE `%s` IS FALSE) AS %s", c, c, AnalyzeTableUtil.getFalseCountColumn(c)));
                    break;
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case TIMESTAMP_WITHOUT_TIME_ZONE: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case FLOAT: 
                case DOUBLE: 
                case DECIMAL: 
                case DATE: 
                case TIME_WITHOUT_TIME_ZONE: {
                    columnStatSelect.add(computeNdv);
                    columnStatSelect.add(String.format("MAX(`%s`) AS %s", c, AnalyzeTableUtil.getMaxColumn(c)));
                    columnStatSelect.add(String.format("MIN(`%s`) AS %s", c, AnalyzeTableUtil.getMinColumn(c)));
                    break;
                }
                case CHAR: 
                case VARCHAR: {
                    columnStatSelect.add(computeNdv);
                    columnStatSelect.add(String.format("AVG(CAST(CHAR_LENGTH(`%s`) AS DOUBLE)) AS %s", c, AnalyzeTableUtil.getAvgLenColumn(c)));
                    columnStatSelect.add(String.format("MAX(CAST(CHAR_LENGTH(`%s`) AS BIGINT)) AS %s", c, AnalyzeTableUtil.getMaxLenColumn(c)));
                    break;
                }
            }
            return columnStatSelect.stream();
        }).collect(Collectors.joining(", "));
    }

    private static CatalogTableStatistics convertToTableStatistics(Row row) {
        Long rowCount = (Long)row.getFieldAs(AnalyzeTableUtil.getRowCountColumn());
        return new CatalogTableStatistics(rowCount.longValue(), -1, -1L, -1L);
    }

    private static CatalogColumnStatistics convertToColumnStatistics(Row row, List<Column> columns) {
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0);
        HashMap<String, CatalogColumnStatisticsDataBase> columnStatMap = new HashMap<String, CatalogColumnStatisticsDataBase>();
        for (Column column : columns) {
            CatalogColumnStatisticsDataBase columnStat = AnalyzeTableUtil.convertToColumnStatisticsData(row, column);
            if (columnStat == null) continue;
            columnStatMap.put(column.getName(), columnStat);
        }
        return new CatalogColumnStatistics(columnStatMap);
    }

    private static CatalogColumnStatisticsDataBase convertToColumnStatisticsData(Row row, Column column) {
        String c = column.getName();
        Long nullCount = (Long)row.getFieldAs(AnalyzeTableUtil.getNullCountColumn(c));
        switch (column.getDataType().getLogicalType().getTypeRoot()) {
            case BOOLEAN: {
                Long trueCount = (Long)row.getFieldAs(AnalyzeTableUtil.getTrueCountColumn(c));
                Long falseCount = (Long)row.getFieldAs(AnalyzeTableUtil.getFalseCountColumn(c));
                return new CatalogColumnStatisticsDataBoolean(trueCount, falseCount, nullCount);
            }
            case TINYINT: {
                Byte maxByte = (Byte)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                Byte minByte = (Byte)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                Long ndvByte = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                return new CatalogColumnStatisticsDataLong(minByte != null ? Long.valueOf(minByte.longValue()) : null, maxByte != null ? Long.valueOf(maxByte.longValue()) : null, ndvByte, nullCount);
            }
            case SMALLINT: {
                Short maxShort = (Short)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                Short minShort = (Short)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                Long ndvShort = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                return new CatalogColumnStatisticsDataLong(minShort != null ? Long.valueOf(minShort.longValue()) : null, maxShort != null ? Long.valueOf(maxShort.longValue()) : null, ndvShort, nullCount);
            }
            case INTEGER: {
                Integer maxInt = (Integer)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                Integer minInt = (Integer)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                Long ndvInt = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                return new CatalogColumnStatisticsDataLong(minInt != null ? Long.valueOf(minInt.longValue()) : null, maxInt != null ? Long.valueOf(maxInt.longValue()) : null, ndvInt, nullCount);
            }
            case BIGINT: {
                Long ndvLong = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                Long maxLong = (Long)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                Long minLong = (Long)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                return new CatalogColumnStatisticsDataLong(minLong, maxLong, ndvLong, nullCount);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                Long ndvTs = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                LocalDateTime maxTs = (LocalDateTime)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                LocalDateTime minTs = (LocalDateTime)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                return new CatalogColumnStatisticsDataLong(minTs != null ? Long.valueOf(minTs.toEpochSecond(ZoneOffset.UTC)) : null, maxTs != null ? Long.valueOf(maxTs.toEpochSecond(ZoneOffset.UTC)) : null, ndvTs, nullCount);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                Long ndvTsLtz = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                Instant maxTsLtz = (Instant)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                Instant minTsLtz = (Instant)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                return new CatalogColumnStatisticsDataLong(minTsLtz != null ? Long.valueOf(minTsLtz.toEpochMilli()) : null, maxTsLtz != null ? Long.valueOf(maxTsLtz.toEpochMilli()) : null, ndvTsLtz, nullCount);
            }
            case FLOAT: {
                Long ndvFloat = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                Float maxFloat = (Float)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                Float minFloat = (Float)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                return new CatalogColumnStatisticsDataDouble(minFloat != null ? Double.valueOf(minFloat.doubleValue()) : null, maxFloat != null ? Double.valueOf(maxFloat.doubleValue()) : null, ndvFloat, nullCount);
            }
            case DOUBLE: {
                Long ndvDouble = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                Double maxDouble = (Double)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                Double minDouble = (Double)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                return new CatalogColumnStatisticsDataDouble(minDouble, maxDouble, ndvDouble, nullCount);
            }
            case DECIMAL: {
                Long ndvDecimal = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                BigDecimal maxDecimal = (BigDecimal)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                BigDecimal minDecimal = (BigDecimal)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                return new CatalogColumnStatisticsDataDouble(minDecimal != null ? Double.valueOf(minDecimal.doubleValue()) : null, maxDecimal != null ? Double.valueOf(maxDecimal.doubleValue()) : null, ndvDecimal, nullCount);
            }
            case DATE: {
                Long ndvDate = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                LocalDate maxDate = (LocalDate)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                LocalDate minDate = (LocalDate)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                return new CatalogColumnStatisticsDataDate(minDate != null ? new Date(minDate.toEpochDay()) : null, maxDate != null ? new Date(maxDate.toEpochDay()) : null, ndvDate, nullCount);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                Long ndvTime = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                LocalTime maxTime = (LocalTime)row.getFieldAs(AnalyzeTableUtil.getMaxColumn(c));
                LocalTime minTime = (LocalTime)row.getFieldAs(AnalyzeTableUtil.getMinColumn(c));
                return new CatalogColumnStatisticsDataLong(minTime != null ? Long.valueOf(minTime.toNanoOfDay()) : null, maxTime != null ? Long.valueOf(maxTime.toNanoOfDay()) : null, ndvTime, nullCount);
            }
            case CHAR: 
            case VARCHAR: {
                Long ndvString = (Long)row.getFieldAs(AnalyzeTableUtil.getNdvColumn(c));
                Double avgLen = (Double)row.getFieldAs(AnalyzeTableUtil.getAvgLenColumn(c));
                Long maxLen = (Long)row.getFieldAs(AnalyzeTableUtil.getMaxLenColumn(c));
                return new CatalogColumnStatisticsDataString(maxLen, avgLen, ndvString, nullCount);
            }
            case BINARY: 
            case VARBINARY: {
                return new CatalogColumnStatisticsDataBinary(null, null, nullCount);
            }
        }
        return null;
    }

    private static String getRowCountColumn() {
        return "rowCount";
    }

    private static String getNullCountColumn(String column) {
        return String.format("%s_nullCount", column);
    }

    private static String getNdvColumn(String column) {
        return String.format("%s_ndv", column);
    }

    private static String getTrueCountColumn(String column) {
        return String.format("%s_trueCount", column);
    }

    private static String getFalseCountColumn(String column) {
        return String.format("%s_falseCount", column);
    }

    private static String getMaxColumn(String column) {
        return String.format("%s_max", column);
    }

    private static String getMinColumn(String column) {
        return String.format("%s_min", column);
    }

    private static String getAvgLenColumn(String column) {
        return String.format("%s_avgLen", column);
    }

    private static String getMaxLenColumn(String column) {
        return String.format("%s_maxLen", column);
    }

    private static String getPartitionIdxColumn() {
        return "part_idx";
    }

    private static class StatisticsWrapper {
        private final CatalogTableStatistics tableStat;
        private final CatalogColumnStatistics columnStat;

        private StatisticsWrapper(CatalogTableStatistics tableStat, CatalogColumnStatistics columnStat) {
            this.tableStat = tableStat;
            this.columnStat = columnStat;
        }
    }
}

