/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.JobStatusHook;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ExplainFormat;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.AnalyzeTableUtil;
import org.apache.flink.table.api.internal.CachedPlan;
import org.apache.flink.table.api.internal.CompiledPlanImpl;
import org.apache.flink.table.api.internal.DQLCachedPlan;
import org.apache.flink.table.api.internal.ExecutableOperationContextImpl;
import org.apache.flink.table.api.internal.InsertResultProvider;
import org.apache.flink.table.api.internal.ResultProvider;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.CatalogStoreHolder;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.StagedTable;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkStagingContext;
import org.apache.flink.table.connector.sink.abilities.SupportsStaging;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.execution.StagingSinkJobStatusHook;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleEntry;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.CompileAndExecutePlanOperation;
import org.apache.flink.table.operations.CreateTableASOperation;
import org.apache.flink.table.operations.DeleteFromFilterOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.NopOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ReplaceTableAsOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.operations.command.ExecutePlanOperation;
import org.apache.flink.table.operations.ddl.AnalyzeTableOperation;
import org.apache.flink.table.operations.ddl.CompilePlanOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.utils.ExecutableOperationUtils;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.types.Row;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.Preconditions;

@Internal
public class TableEnvironmentImpl
implements TableEnvironmentInternal {
    private static final boolean IS_STREAM_TABLE = true;
    private final CatalogManager catalogManager;
    private final ModuleManager moduleManager;
    protected final ResourceManager resourceManager;
    private final OperationTreeBuilder operationTreeBuilder;
    protected final TableConfig tableConfig;
    protected final Executor execEnv;
    protected final FunctionCatalog functionCatalog;
    protected final Planner planner;
    private final boolean isStreamingMode;
    private final ExecutableOperation.Context operationCtx;
    private static final String UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG = "Unsupported SQL query! executeSql() only accepts a single SQL statement of type CREATE TABLE, DROP TABLE, ALTER TABLE, CREATE DATABASE, DROP DATABASE, ALTER DATABASE, CREATE FUNCTION, DROP FUNCTION, ALTER FUNCTION, CREATE CATALOG, DROP CATALOG, USE CATALOG, USE [CATALOG.]DATABASE, SHOW CATALOGS, SHOW DATABASES, SHOW TABLES, SHOW [USER] FUNCTIONS, SHOW PARTITIONSCREATE VIEW, DROP VIEW, SHOW VIEWS, INSERT, DESCRIBE, LOAD MODULE, UNLOAD MODULE, USE MODULES, SHOW [FULL] MODULES.";
    private static final String UNSUPPORTED_QUERY_IN_COMPILE_PLAN_SQL_MSG = "Unsupported SQL query! compilePlanSql() only accepts a single SQL statement of type INSERT";

    protected TableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, ResourceManager resourceManager, TableConfig tableConfig, Executor executor, FunctionCatalog functionCatalog, Planner planner, boolean isStreamingMode) {
        this.catalogManager = catalogManager;
        this.moduleManager = moduleManager;
        this.resourceManager = resourceManager;
        this.execEnv = executor;
        this.tableConfig = tableConfig;
        this.functionCatalog = functionCatalog;
        this.planner = planner;
        this.isStreamingMode = isStreamingMode;
        this.operationTreeBuilder = OperationTreeBuilder.create(tableConfig, resourceManager.getUserClassLoader(), functionCatalog.asLookup(this.getParser()::parseIdentifier), catalogManager.getDataTypeFactory(), path -> {
            try {
                UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
                Optional<SourceQueryOperation> catalogQueryOperation = this.scanInternal(unresolvedIdentifier);
                return catalogQueryOperation.map(t -> ApiExpressionUtils.tableRef(path, t));
            }
            catch (SqlParserException ex) {
                return Optional.empty();
            }
        }, this.getParser()::parseSqlExpression, isStreamingMode);
        catalogManager.initSchemaResolver(isStreamingMode, this.operationTreeBuilder.getResolverBuilder(new QueryOperation[0]));
        this.operationCtx = new ExecutableOperationContextImpl(catalogManager, functionCatalog, moduleManager, resourceManager, tableConfig, isStreamingMode);
    }

    public static TableEnvironmentImpl create(Configuration configuration) {
        return TableEnvironmentImpl.create(EnvironmentSettings.newInstance().withConfiguration(configuration).build());
    }

    public static TableEnvironmentImpl create(EnvironmentSettings settings) {
        MutableURLClassLoader userClassLoader = FlinkUserCodeClassLoaders.create((URL[])new URL[0], (ClassLoader)settings.getUserClassLoader(), (ReadableConfig)settings.getConfiguration());
        ExecutorFactory executorFactory = (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)userClassLoader, ExecutorFactory.class, (String)"default");
        Executor executor = executorFactory.create(settings.getConfiguration());
        CatalogStoreFactory catalogStoreFactory = TableFactoryUtil.findAndCreateCatalogStoreFactory(settings.getConfiguration(), (ClassLoader)userClassLoader);
        CatalogStoreFactory.Context context = TableFactoryUtil.buildCatalogStoreFactoryContext(settings.getConfiguration(), (ClassLoader)userClassLoader);
        catalogStoreFactory.open(context);
        CatalogStore catalogStore = settings.getCatalogStore() != null ? settings.getCatalogStore() : catalogStoreFactory.createCatalogStore();
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setRootConfiguration(executor.getConfiguration());
        tableConfig.addConfiguration(settings.getConfiguration());
        ResourceManager resourceManager = new ResourceManager((ReadableConfig)settings.getConfiguration(), userClassLoader);
        ModuleManager moduleManager = new ModuleManager();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader((ClassLoader)userClassLoader).config(tableConfig).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).catalogModificationListeners(TableFactoryUtil.findCatalogModificationListenerList((ReadableConfig)settings.getConfiguration(), (ClassLoader)userClassLoader)).catalogStoreHolder(CatalogStoreHolder.newBuilder().catalogStore(catalogStore).factory(catalogStoreFactory).config((ReadableConfig)tableConfig).classloader((ClassLoader)userClassLoader).build()).build();
        FunctionCatalog functionCatalog = new FunctionCatalog(tableConfig, resourceManager, catalogManager, moduleManager);
        Planner planner = PlannerFactoryUtil.createPlanner(executor, tableConfig, (ClassLoader)userClassLoader, moduleManager, catalogManager, functionCatalog);
        return new TableEnvironmentImpl(catalogManager, moduleManager, resourceManager, tableConfig, executor, functionCatalog, planner, settings.isStreamingMode());
    }

    @Override
    public Table fromValues(Object ... values) {
        return this.fromValues(Arrays.asList(values));
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Object ... values) {
        return this.fromValues(rowType, Arrays.asList(values));
    }

    @Override
    public Table fromValues(Expression ... values) {
        return this.createTable(this.operationTreeBuilder.values(values));
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Expression ... values) {
        DataType resolvedDataType = this.catalogManager.getDataTypeFactory().createDataType(rowType);
        return this.createTable(this.operationTreeBuilder.values(resolvedDataType, values));
    }

    @Override
    public Table fromValues(Iterable<?> values) {
        Expression[] exprs = (Expression[])StreamSupport.stream(values.spliterator(), false).map(ApiExpressionUtils::objectToExpression).toArray(Expression[]::new);
        return this.fromValues(exprs);
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Iterable<?> values) {
        Expression[] exprs = (Expression[])StreamSupport.stream(values.spliterator(), false).map(ApiExpressionUtils::objectToExpression).toArray(Expression[]::new);
        return this.fromValues(rowType, exprs);
    }

    @VisibleForTesting
    public Planner getPlanner() {
        return this.planner;
    }

    @Override
    public Table fromTableSource(TableSource<?> source) {
        return this.createTable(new TableSourceQueryOperation(source, false));
    }

    @Override
    public void registerCatalog(String catalogName, Catalog catalog) {
        this.catalogManager.registerCatalog(catalogName, catalog);
    }

    @Override
    public void createCatalog(String catalogName, CatalogDescriptor catalogDescriptor) {
        this.catalogManager.createCatalog(catalogName, catalogDescriptor);
    }

    @Override
    public Optional<Catalog> getCatalog(String catalogName) {
        return this.catalogManager.getCatalog(catalogName);
    }

    @Override
    public void loadModule(String moduleName, Module module) {
        this.moduleManager.loadModule(moduleName, module);
    }

    @Override
    public void useModules(String ... moduleNames) {
        this.moduleManager.useModules(moduleNames);
    }

    @Override
    public void unloadModule(String moduleName) {
        this.moduleManager.unloadModule(moduleName);
    }

    @Override
    public void registerFunction(String name, ScalarFunction function) {
        this.functionCatalog.registerTempSystemScalarFunction(name, function);
    }

    @Override
    public void createTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> functionClass) {
        UserDefinedFunction functionInstance = UserDefinedFunctionHelper.instantiateFunction(functionClass);
        this.createTemporarySystemFunction(name, functionInstance);
    }

    @Override
    public void createTemporarySystemFunction(String name, UserDefinedFunction functionInstance) {
        this.functionCatalog.registerTemporarySystemFunction(name, (FunctionDefinition)functionInstance, false);
    }

    @Override
    public void createTemporarySystemFunction(String name, String className, List<ResourceUri> resourceUris) {
        this.functionCatalog.registerTemporarySystemFunction(name, className, resourceUris);
    }

    @Override
    public boolean dropTemporarySystemFunction(String name) {
        return this.functionCatalog.dropTemporarySystemFunction(name, true);
    }

    @Override
    public void createFunction(String path, Class<? extends UserDefinedFunction> functionClass) {
        this.createFunction(path, functionClass, false);
    }

    @Override
    public void createFunction(String path, Class<? extends UserDefinedFunction> functionClass, boolean ignoreIfExists) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        this.functionCatalog.registerCatalogFunction(unresolvedIdentifier, functionClass, ignoreIfExists);
    }

    @Override
    public void createFunction(String path, String className, List<ResourceUri> resourceUris) {
        this.createFunction(path, className, resourceUris, false);
    }

    @Override
    public void createFunction(String path, String className, List<ResourceUri> resourceUris, boolean ignoreIfExists) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        this.functionCatalog.registerCatalogFunction(unresolvedIdentifier, className, resourceUris, ignoreIfExists);
    }

    @Override
    public boolean dropFunction(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        return this.functionCatalog.dropCatalogFunction(unresolvedIdentifier, true);
    }

    @Override
    public void createTemporaryFunction(String path, Class<? extends UserDefinedFunction> functionClass) {
        UserDefinedFunction functionInstance = UserDefinedFunctionHelper.instantiateFunction(functionClass);
        this.createTemporaryFunction(path, functionInstance);
    }

    @Override
    public void createTemporaryFunction(String path, UserDefinedFunction functionInstance) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        this.functionCatalog.registerTemporaryCatalogFunction(unresolvedIdentifier, (FunctionDefinition)functionInstance, false);
    }

    @Override
    public void createTemporaryFunction(String path, String className, List<ResourceUri> resourceUris) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(className, FunctionLanguage.JAVA, resourceUris);
        this.functionCatalog.registerTemporaryCatalogFunction(unresolvedIdentifier, catalogFunction, false);
    }

    @Override
    public boolean dropTemporaryFunction(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        return this.functionCatalog.dropTemporaryCatalogFunction(unresolvedIdentifier, true);
    }

    @Override
    public void createTemporaryTable(String path, TableDescriptor descriptor) {
        Preconditions.checkNotNull((Object)path, (String)"Path must not be null.");
        Preconditions.checkNotNull((Object)descriptor, (String)"Table descriptor must not be null.");
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(this.getParser().parseIdentifier(path));
        this.catalogManager.createTemporaryTable((CatalogBaseTable)descriptor.toCatalogTable(), tableIdentifier, false);
    }

    @Override
    public void createTable(String path, TableDescriptor descriptor) {
        Preconditions.checkNotNull((Object)path, (String)"Path must not be null.");
        Preconditions.checkNotNull((Object)descriptor, (String)"Table descriptor must not be null.");
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(this.getParser().parseIdentifier(path));
        this.catalogManager.createTable((CatalogBaseTable)descriptor.toCatalogTable(), tableIdentifier, false);
    }

    @Override
    public void registerTable(String name, Table table) {
        UnresolvedIdentifier identifier = UnresolvedIdentifier.of((String[])new String[]{name});
        this.createTemporaryView(identifier, table);
    }

    @Override
    public void createTemporaryView(String path, Table view) {
        Preconditions.checkNotNull((Object)path, (String)"Path must not be null.");
        Preconditions.checkNotNull((Object)view, (String)"Table view must not be null.");
        UnresolvedIdentifier identifier = this.getParser().parseIdentifier(path);
        this.createTemporaryView(identifier, view);
    }

    private void createTemporaryView(UnresolvedIdentifier identifier, Table view) {
        if (((TableImpl)view).getTableEnvironment() != this) {
            throw new TableException("Only table API objects that belong to this TableEnvironment can be registered.");
        }
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        QueryOperation queryOperation = this.qualifyQueryOperation(tableIdentifier, view.getQueryOperation());
        QueryOperationCatalogView tableTable = new QueryOperationCatalogView(queryOperation);
        this.catalogManager.createTemporaryTable((CatalogBaseTable)tableTable, tableIdentifier, false);
    }

    @Override
    public Table scan(String ... tablePath) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])tablePath);
        return this.scanInternal(unresolvedIdentifier).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table %s was not found.", unresolvedIdentifier)));
    }

    @Override
    public Table from(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        return this.scanInternal(unresolvedIdentifier).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table %s was not found.", unresolvedIdentifier)));
    }

    @Override
    public Table from(TableDescriptor descriptor) {
        Preconditions.checkNotNull((Object)descriptor, (String)"Table descriptor must not be null.");
        ResolvedCatalogTable resolvedCatalogBaseTable = this.catalogManager.resolveCatalogTable(descriptor.toCatalogTable());
        SourceQueryOperation queryOperation = new SourceQueryOperation(ContextResolvedTable.anonymous(resolvedCatalogBaseTable));
        return this.createTable(queryOperation);
    }

    private Optional<SourceQueryOperation> scanInternal(UnresolvedIdentifier identifier) {
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        return this.catalogManager.getTable(tableIdentifier).map(SourceQueryOperation::new);
    }

    @Override
    public String[] listCatalogs() {
        return (String[])this.catalogManager.listCatalogs().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listModules() {
        return this.moduleManager.listModules().toArray(new String[0]);
    }

    @Override
    public ModuleEntry[] listFullModules() {
        return this.moduleManager.listFullModules().toArray(new ModuleEntry[0]);
    }

    @Override
    public String[] listDatabases() {
        return (String[])this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get().listDatabases().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTables() {
        return (String[])this.catalogManager.listTables().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTables(String catalog, String databaseName) {
        return (String[])this.catalogManager.listTables(catalog, databaseName).stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listViews() {
        return (String[])this.catalogManager.listViews().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTemporaryTables() {
        return (String[])this.catalogManager.listTemporaryTables().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTemporaryViews() {
        return (String[])this.catalogManager.listTemporaryViews().stream().sorted().toArray(String[]::new);
    }

    @Override
    public boolean dropTemporaryTable(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        try {
            this.catalogManager.dropTemporaryTable(identifier, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public boolean dropTemporaryView(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        try {
            this.catalogManager.dropTemporaryView(identifier, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public String[] listUserDefinedFunctions() {
        Object[] functions = this.functionCatalog.getUserDefinedFunctions();
        Arrays.sort(functions);
        return functions;
    }

    @Override
    public String[] listFunctions() {
        Object[] functions = this.functionCatalog.getFunctions();
        Arrays.sort(functions);
        return functions;
    }

    @Override
    public String explainSql(String statement, ExplainFormat format, ExplainDetail ... extraDetails) {
        List<Operation> operations = this.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new TableException("Unsupported SQL query! explainSql() only accepts a single SQL query.");
        }
        if (operations.get(0) instanceof StatementSetOperation) {
            operations = new ArrayList<ModifyOperation>(((StatementSetOperation)operations.get(0)).getOperations());
        }
        return this.explainInternal(operations, format, extraDetails);
    }

    @Override
    public String explainInternal(List<Operation> operations, ExplainFormat format, ExplainDetail ... extraDetails) {
        if ((operations = operations.stream().filter(o -> !(o instanceof NopOperation)).collect(Collectors.toList())).isEmpty()) {
            return "";
        }
        if (operations.size() > 1 && operations.stream().anyMatch(this::isRowLevelModification)) {
            throw new TableException("Unsupported SQL query! Only accept a single SQL statement of type DELETE, UPDATE.");
        }
        return this.planner.explain(operations, format, extraDetails);
    }

    @Override
    public String[] getCompletionHints(String statement, int position) {
        return this.planner.getParser().getCompletionHints(statement, position);
    }

    @Override
    public Table sqlQuery(String query) {
        List<Operation> operations = this.getParser().parse(query);
        if (operations.size() != 1) {
            throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query.");
        }
        Operation operation = operations.get(0);
        if (operation instanceof QueryOperation && !(operation instanceof ModifyOperation)) {
            return this.createTable((QueryOperation)operation);
        }
        throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query of type SELECT, UNION, INTERSECT, EXCEPT, VALUES, and ORDER_BY.");
    }

    @Override
    public TableResult executeSql(String statement) {
        List<Operation> operations = this.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new TableException(UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG);
        }
        Operation operation = operations.get(0);
        return this.executeInternal(operation);
    }

    @Override
    public TableResultInternal executeCachedPlanInternal(CachedPlan cachedPlan) {
        if (cachedPlan instanceof DQLCachedPlan) {
            DQLCachedPlan dqlCachedPlan = (DQLCachedPlan)cachedPlan;
            return this.executeQueryOperation(dqlCachedPlan.getOperation(), dqlCachedPlan.getSinkOperation(), dqlCachedPlan.getTransformations());
        }
        throw new TableException(String.format("Unsupported CachedPlan type: %s.", cachedPlan.getClass()));
    }

    @Override
    public StatementSet createStatementSet() {
        return new StatementSetImpl<TableEnvironmentImpl>(this);
    }

    @Override
    public CompiledPlan loadPlan(PlanReference planReference) {
        try {
            return new CompiledPlanImpl(this, this.planner.loadPlan(planReference));
        }
        catch (IOException e) {
            throw new TableException(String.format("Cannot load %s.", planReference), (Throwable)e);
        }
    }

    @Override
    public CompiledPlan compilePlanSql(String stmt) {
        List<Operation> operations = this.getParser().parse(stmt);
        if (operations.size() != 1 || !(operations.get(0) instanceof ModifyOperation) || this.isRowLevelModification(operations.get(0)) || operations.get(0) instanceof CreateTableASOperation) {
            throw new TableException(UNSUPPORTED_QUERY_IN_COMPILE_PLAN_SQL_MSG);
        }
        return new CompiledPlanImpl(this, this.planner.compilePlan(Collections.singletonList((ModifyOperation)operations.get(0))));
    }

    @Override
    public TableResultInternal executePlan(InternalPlan plan) {
        List<Transformation<?>> transformations = this.planner.translatePlan(plan);
        List<String> sinkIdentifierNames = this.deduplicateSinkIdentifierNames(plan.getSinkIdentifiers());
        return this.executeInternal(transformations, sinkIdentifierNames);
    }

    private CompiledPlan compilePlanAndWrite(String pathString, boolean ignoreIfExists, Operation operation) {
        try {
            CompiledPlan compiledPlan;
            ResourceUri planResource = new ResourceUri(ResourceType.FILE, pathString);
            Path planPath = new Path(pathString);
            if (this.resourceManager.exists(planPath)) {
                if (ignoreIfExists) {
                    return this.loadPlan(PlanReference.fromFile(this.resourceManager.registerFileResource(planResource)));
                }
                if (!this.tableConfig.get(TableConfigOptions.PLAN_FORCE_RECOMPILE).booleanValue()) {
                    throw new TableException(String.format("Cannot overwrite the plan file '%s'. Either manually remove the file or, if you're debugging your job, set the option '%s' to true.", pathString, TableConfigOptions.PLAN_FORCE_RECOMPILE.key()));
                }
            }
            if (operation instanceof StatementSetOperation) {
                compiledPlan = this.compilePlan(((StatementSetOperation)operation).getOperations());
            } else if (operation instanceof ModifyOperation) {
                compiledPlan = this.compilePlan(Collections.singletonList((ModifyOperation)operation));
            } else {
                throw new TableException("Unsupported operation to compile: " + operation.getClass() + ". This is a bug, please file an issue.");
            }
            this.resourceManager.syncFileResource(planResource, path -> compiledPlan.writeToFile((String)path, false));
            return compiledPlan;
        }
        catch (IOException e) {
            throw new TableException(String.format("Failed to execute %s statement.", operation.asSummaryString()), (Throwable)e);
        }
    }

    @Override
    public CompiledPlan compilePlan(List<ModifyOperation> operations) {
        return new CompiledPlanImpl(this, this.planner.compilePlan(operations));
    }

    @Override
    public TableResultInternal executeInternal(List<ModifyOperation> operations) {
        ArrayList<ModifyOperation> mapOperations = new ArrayList<ModifyOperation>();
        LinkedList<JobStatusHook> jobStatusHookList = new LinkedList<JobStatusHook>();
        for (ModifyOperation modify : operations) {
            if (modify instanceof CreateTableASOperation) {
                CreateTableASOperation ctasOperation = (CreateTableASOperation)modify;
                mapOperations.add(this.getModifyOperation(ctasOperation, jobStatusHookList));
                continue;
            }
            if (modify instanceof ReplaceTableAsOperation) {
                ReplaceTableAsOperation rtasOperation = (ReplaceTableAsOperation)modify;
                mapOperations.add(this.getModifyOperation(rtasOperation, jobStatusHookList));
                continue;
            }
            boolean isRowLevelModification = this.isRowLevelModification(modify);
            if (isRowLevelModification) {
                String modifyType;
                String string = modifyType = ((SinkModifyOperation)modify).isDelete() ? "DELETE" : "UPDATE";
                if (operations.size() > 1) {
                    throw new TableException(String.format("Unsupported SQL query! Only accept a single SQL statement of type %s.", modifyType));
                }
                if (this.isStreamingMode) {
                    throw new TableException(String.format("%s statement is not supported for streaming mode now.", modifyType));
                }
                if (modify instanceof DeleteFromFilterOperation) {
                    return this.executeInternal((DeleteFromFilterOperation)modify);
                }
            }
            mapOperations.add(modify);
        }
        List<Transformation<?>> transformations = this.translate(mapOperations);
        List<String> sinkIdentifierNames = this.extractSinkIdentifierNames(mapOperations);
        return this.executeInternal(transformations, sinkIdentifierNames, jobStatusHookList);
    }

    private ModifyOperation getModifyOperation(ReplaceTableAsOperation rtasOperation, List<JobStatusHook> jobStatusHookList) {
        ResolvedCatalogTable catalogTable;
        CreateTableOperation createTableOperation = rtasOperation.getCreateTableOperation();
        ObjectIdentifier tableIdentifier = createTableOperation.getTableIdentifier();
        Optional<ContextResolvedTable> replacedTable = this.catalogManager.getTable(tableIdentifier);
        if (!rtasOperation.isCreateOrReplace() && !replacedTable.isPresent()) {
            throw new TableException(String.format("The table %s to be replaced doesn't exist. You can try to use CREATE TABLE AS statement or CREATE OR REPLACE TABLE AS statement.", tableIdentifier));
        }
        Catalog catalog = this.catalogManager.getCatalogOrThrowException(tableIdentifier.getCatalogName());
        Optional<DynamicTableSink> stagingDynamicTableSink = this.getSupportsStagingDynamicTableSink(createTableOperation, catalog, catalogTable = this.catalogManager.resolveCatalogTable(createTableOperation.getCatalogTable()));
        if (stagingDynamicTableSink.isPresent()) {
            DynamicTableSink dynamicTableSink = stagingDynamicTableSink.get();
            SupportsStaging.StagingPurpose stagingPurpose = rtasOperation.isCreateOrReplace() ? SupportsStaging.StagingPurpose.CREATE_OR_REPLACE_TABLE_AS : SupportsStaging.StagingPurpose.REPLACE_TABLE_AS;
            StagedTable stagedTable = ((SupportsStaging)dynamicTableSink).applyStaging((SupportsStaging.StagingContext)new SinkStagingContext(stagingPurpose));
            StagingSinkJobStatusHook stagingSinkJobStatusHook = new StagingSinkJobStatusHook(stagedTable);
            jobStatusHookList.add(stagingSinkJobStatusHook);
            return rtasOperation.toStagedSinkModifyOperation(tableIdentifier, catalogTable, catalog, dynamicTableSink);
        }
        if (replacedTable.isPresent()) {
            this.catalogManager.dropTable(tableIdentifier, false);
        }
        this.executeInternal(createTableOperation);
        return rtasOperation.toSinkModifyOperation(this.catalogManager);
    }

    private ModifyOperation getModifyOperation(CreateTableASOperation ctasOperation, List<JobStatusHook> jobStatusHookList) {
        ResolvedCatalogTable catalogTable;
        ObjectIdentifier tableIdentifier;
        Catalog catalog;
        CreateTableOperation createTableOperation = ctasOperation.getCreateTableOperation();
        Optional<DynamicTableSink> stagingDynamicTableSink = this.getSupportsStagingDynamicTableSink(createTableOperation, catalog = this.catalogManager.getCatalogOrThrowException((tableIdentifier = createTableOperation.getTableIdentifier()).getCatalogName()), catalogTable = this.catalogManager.resolveCatalogTable(createTableOperation.getCatalogTable()));
        if (stagingDynamicTableSink.isPresent()) {
            DynamicTableSink dynamicTableSink = stagingDynamicTableSink.get();
            SupportsStaging.StagingPurpose stagingPurpose = createTableOperation.isIgnoreIfExists() ? SupportsStaging.StagingPurpose.CREATE_TABLE_AS_IF_NOT_EXISTS : SupportsStaging.StagingPurpose.CREATE_TABLE_AS;
            StagedTable stagedTable = ((SupportsStaging)dynamicTableSink).applyStaging((SupportsStaging.StagingContext)new SinkStagingContext(stagingPurpose));
            StagingSinkJobStatusHook stagingSinkJobStatusHook = new StagingSinkJobStatusHook(stagedTable);
            jobStatusHookList.add(stagingSinkJobStatusHook);
            return ctasOperation.toStagedSinkModifyOperation(tableIdentifier, catalogTable, catalog, dynamicTableSink);
        }
        this.executeInternal(createTableOperation);
        return ctasOperation.toSinkModifyOperation(this.catalogManager);
    }

    private Optional<DynamicTableSink> getSupportsStagingDynamicTableSink(CreateTableOperation createTableOperation, Catalog catalog, ResolvedCatalogTable catalogTable) {
        if (this.tableConfig.get(TableConfigOptions.TABLE_RTAS_CTAS_ATOMICITY_ENABLED).booleanValue() && !TableFactoryUtil.isLegacyConnectorOptions(catalog, this.tableConfig, this.isStreamingMode, createTableOperation.getTableIdentifier(), (CatalogTable)catalogTable, createTableOperation.isTemporary())) {
            try {
                DynamicTableSink dynamicTableSink = ExecutableOperationUtils.createDynamicTableSink(catalog, () -> this.moduleManager.getFactory(Module::getTableSinkFactory), createTableOperation.getTableIdentifier(), catalogTable, Collections.emptyMap(), this.tableConfig, this.resourceManager.getUserClassLoader(), createTableOperation.isTemporary());
                if (dynamicTableSink instanceof SupportsStaging) {
                    return Optional.of(dynamicTableSink);
                }
            }
            catch (Exception e) {
                throw new TableException(String.format("Fail to create DynamicTableSink for the table %s, maybe the table does not support atomicity of CTAS/RTAS, please set %s to false and try again.", createTableOperation.getTableIdentifier(), TableConfigOptions.TABLE_RTAS_CTAS_ATOMICITY_ENABLED.key()), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private TableResultInternal executeInternal(DeleteFromFilterOperation deleteFromFilterOperation) {
        Optional rows = deleteFromFilterOperation.getSupportsDeletePushDownSink().executeDeletion();
        if (rows.isPresent()) {
            return TableResultImpl.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"rows affected", (DataType)DataTypes.BIGINT())})).data(Collections.singletonList(Row.of((Object[])new Object[]{rows.get()}))).build();
        }
        return TableResultImpl.TABLE_RESULT_OK;
    }

    private TableResultInternal executeInternal(List<Transformation<?>> transformations, List<String> sinkIdentifierNames) {
        return this.executeInternal(transformations, sinkIdentifierNames, Collections.emptyList());
    }

    private TableResultInternal executeInternal(List<Transformation<?>> transformations, List<String> sinkIdentifierNames, List<JobStatusHook> jobStatusHookList) {
        String defaultJobName = "insert-into_" + String.join((CharSequence)",", sinkIdentifierNames);
        this.resourceManager.addJarConfiguration(this.tableConfig);
        Pipeline pipeline = this.execEnv.createPipeline(transformations, (ReadableConfig)this.tableConfig.getConfiguration(), defaultJobName, jobStatusHookList);
        try {
            JobClient jobClient = this.execEnv.executeAsync(pipeline);
            ArrayList<Column.PhysicalColumn> columns = new ArrayList<Column.PhysicalColumn>();
            Long[] affectedRowCounts = new Long[transformations.size()];
            for (int i = 0; i < transformations.size(); ++i) {
                columns.add(Column.physical((String)sinkIdentifierNames.get(i), (DataType)DataTypes.BIGINT()));
                affectedRowCounts[i] = -1L;
            }
            TableResultInternal result = TableResultImpl.builder().jobClient(jobClient).resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(ResolvedSchema.of(columns)).resultProvider(new InsertResultProvider(affectedRowCounts).setJobClient(jobClient)).build();
            if (this.tableConfig.get(TableConfigOptions.TABLE_DML_SYNC).booleanValue()) {
                try {
                    result.await();
                }
                catch (InterruptedException | ExecutionException e) {
                    result.getJobClient().ifPresent(JobClient::cancel);
                    throw new TableException("Fail to wait execution finish.", (Throwable)e);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new TableException("Failed to execute sql", (Throwable)e);
        }
    }

    private TableResultInternal executeQueryOperation(QueryOperation operation, CollectModifyOperation sinkOperation, List<Transformation<?>> transformations) {
        String defaultJobName = "collect";
        this.resourceManager.addJarConfiguration(this.tableConfig);
        Pipeline pipeline = this.execEnv.createPipeline(transformations, (ReadableConfig)this.tableConfig.getConfiguration(), "collect");
        try {
            JobClient jobClient = this.execEnv.executeAsync(pipeline);
            ResultProvider resultProvider = sinkOperation.getSelectResultProvider();
            resultProvider.reset();
            resultProvider.setJobClient(jobClient);
            return TableResultImpl.builder().jobClient(jobClient).resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(operation.getResolvedSchema()).resultProvider(resultProvider).setPrintStyle((PrintStyle)PrintStyle.tableauWithTypeInferredColumnWidths((ResolvedSchema)DataTypeUtils.expandCompositeTypeToSchema((DataType)sinkOperation.getConsumedDataType()), (RowDataToStringConverter)resultProvider.getRowDataStringConverter(), (int)this.getConfig().get(TableConfigOptions.DISPLAY_MAX_COLUMN_WIDTH), (boolean)false, (boolean)this.isStreamingMode)).setCachedPlan(new DQLCachedPlan(operation, sinkOperation, transformations)).build();
        }
        catch (Exception e) {
            throw new TableException("Failed to execute sql", (Throwable)e);
        }
    }

    @Override
    public TableResultInternal executeInternal(Operation operation) {
        if (operation instanceof ExecutableOperation) {
            return ((ExecutableOperation)operation).execute(this.operationCtx);
        }
        if (operation instanceof ModifyOperation) {
            return this.executeInternal(Collections.singletonList((ModifyOperation)operation));
        }
        if (operation instanceof StatementSetOperation) {
            return this.executeInternal(((StatementSetOperation)operation).getOperations());
        }
        if (operation instanceof ExplainOperation) {
            ExplainOperation explainOperation = (ExplainOperation)operation;
            ExplainDetail[] explainDetails = (ExplainDetail[])explainOperation.getExplainDetails().stream().map(ExplainDetail::valueOf).toArray(ExplainDetail[]::new);
            Operation child = ((ExplainOperation)operation).getChild();
            List<Operation> operations = child instanceof StatementSetOperation ? new ArrayList<ModifyOperation>(((StatementSetOperation)child).getOperations()) : Collections.singletonList(child);
            String explanation = this.explainInternal(operations, explainDetails);
            return TableResultImpl.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"result", (DataType)DataTypes.STRING())})).data(Collections.singletonList(Row.of((Object[])new Object[]{explanation}))).build();
        }
        if (operation instanceof QueryOperation) {
            QueryOperation queryOperation = (QueryOperation)operation;
            CollectModifyOperation sinkOperation = new CollectModifyOperation(queryOperation);
            List<Transformation<?>> transformations = this.translate(Collections.singletonList(sinkOperation));
            return this.executeQueryOperation(queryOperation, sinkOperation, transformations);
        }
        if (operation instanceof ExecutePlanOperation) {
            ExecutePlanOperation executePlanOperation = (ExecutePlanOperation)operation;
            try {
                return (TableResultInternal)this.executePlan(PlanReference.fromFile(this.resourceManager.registerFileResource(new ResourceUri(ResourceType.FILE, executePlanOperation.getFilePath()))));
            }
            catch (IOException e) {
                throw new TableException(String.format("Failed to execute %s statement.", operation.asSummaryString()), (Throwable)e);
            }
        }
        if (operation instanceof CompilePlanOperation) {
            CompilePlanOperation compilePlanOperation = (CompilePlanOperation)operation;
            this.compilePlanAndWrite(compilePlanOperation.getFilePath(), compilePlanOperation.isIfNotExists(), compilePlanOperation.getOperation());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof CompileAndExecutePlanOperation) {
            CompileAndExecutePlanOperation compileAndExecutePlanOperation = (CompileAndExecutePlanOperation)operation;
            CompiledPlan compiledPlan = this.compilePlanAndWrite(compileAndExecutePlanOperation.getFilePath(), true, compileAndExecutePlanOperation.getOperation());
            return (TableResultInternal)compiledPlan.execute();
        }
        if (operation instanceof AnalyzeTableOperation) {
            if (this.isStreamingMode) {
                throw new TableException("ANALYZE TABLE is not supported for streaming mode now");
            }
            try {
                return AnalyzeTableUtil.analyzeTable(this, (AnalyzeTableOperation)operation);
            }
            catch (Exception e) {
                throw new TableException("Failed to execute ANALYZE TABLE command", (Throwable)e);
            }
        }
        if (operation instanceof NopOperation) {
            return TableResultImpl.TABLE_RESULT_OK;
        }
        throw new TableException(UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG);
    }

    private List<String> extractSinkIdentifierNames(List<ModifyOperation> operations) {
        ArrayList<String> tableNames = new ArrayList<String>(operations.size());
        for (ModifyOperation operation : operations) {
            if (operation instanceof SinkModifyOperation) {
                String fullName = ((SinkModifyOperation)operation).getContextResolvedTable().getIdentifier().asSummaryString();
                tableNames.add(fullName);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported operation: " + operation);
        }
        return this.deduplicateSinkIdentifierNames(tableNames);
    }

    private List<String> deduplicateSinkIdentifierNames(List<String> tableNames) {
        HashMap<String, Integer> tableNameToCount = new HashMap<String, Integer>();
        for (String fullName : tableNames) {
            tableNameToCount.put(fullName, tableNameToCount.getOrDefault(fullName, 0) + 1);
        }
        HashMap tableNameToIndex = new HashMap();
        return tableNames.stream().map(tableName -> {
            if ((Integer)tableNameToCount.get(tableName) == 1) {
                return tableName;
            }
            Integer index = tableNameToIndex.getOrDefault(tableName, 0) + 1;
            tableNameToIndex.put(tableName, index);
            return tableName + "_" + index;
        }).collect(Collectors.toList());
    }

    @Override
    public String getCurrentCatalog() {
        return this.catalogManager.getCurrentCatalog();
    }

    @Override
    public void useCatalog(String catalogName) {
        this.catalogManager.setCurrentCatalog(catalogName);
    }

    @Override
    public String getCurrentDatabase() {
        return this.catalogManager.getCurrentDatabase();
    }

    @Override
    public void useDatabase(String databaseName) {
        this.catalogManager.setCurrentDatabase(databaseName);
    }

    @Override
    public TableConfig getConfig() {
        return this.tableConfig;
    }

    @Override
    public Parser getParser() {
        return this.getPlanner().getParser();
    }

    @Override
    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    @Override
    public OperationTreeBuilder getOperationTreeBuilder() {
        return this.operationTreeBuilder;
    }

    protected QueryOperation qualifyQueryOperation(ObjectIdentifier identifier, QueryOperation queryOperation) {
        return queryOperation;
    }

    protected void validateTableSource(TableSource<?> tableSource) {
        TableSourceValidation.validateTableSource(tableSource, (TableSchema)tableSource.getTableSchema());
    }

    protected List<Transformation<?>> translate(List<ModifyOperation> modifyOperations) {
        return this.planner.translate(modifyOperations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerTableSourceInternal(String name, TableSource<?> tableSource) {
        this.validateTableSource(tableSource);
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{name}));
        Optional<CatalogBaseTable> table = this.getTemporaryTable(objectIdentifier);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSource().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            ConnectorCatalogTable sourceAndSink = ConnectorCatalogTable.sourceAndSink(tableSource, sourceSinkTable.getTableSink().get(), false);
            this.catalogManager.dropTemporaryTable(objectIdentifier, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sourceAndSink, objectIdentifier, false);
            return;
        } else {
            ConnectorCatalogTable<?, ?> source = ConnectorCatalogTable.source(tableSource, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)source, objectIdentifier, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerTableSinkInternal(String name, TableSink<?> tableSink) {
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{name}));
        Optional<CatalogBaseTable> table = this.getTemporaryTable(objectIdentifier);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSink().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            ConnectorCatalogTable sourceAndSink = ConnectorCatalogTable.sourceAndSink(sourceSinkTable.getTableSource().get(), tableSink, false);
            this.catalogManager.dropTemporaryTable(objectIdentifier, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sourceAndSink, objectIdentifier, false);
            return;
        } else {
            ConnectorCatalogTable<?, ?> sink = ConnectorCatalogTable.sink(tableSink, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sink, objectIdentifier, false);
        }
    }

    private Optional<CatalogBaseTable> getTemporaryTable(ObjectIdentifier identifier) {
        return this.catalogManager.getTable(identifier).filter(ContextResolvedTable::isTemporary).map(ContextResolvedTable::getResolvedTable);
    }

    @VisibleForTesting
    public TableImpl createTable(QueryOperation tableOperation) {
        return TableImpl.createTable(this, tableOperation, this.operationTreeBuilder, this.functionCatalog.asLookup(this.getParser()::parseIdentifier));
    }

    @Override
    public String explainPlan(InternalPlan compiledPlan, ExplainDetail ... extraDetails) {
        return this.planner.explainPlan(compiledPlan, extraDetails);
    }

    private boolean isRowLevelModification(Operation operation) {
        if (operation instanceof SinkModifyOperation) {
            SinkModifyOperation sinkModifyOperation = (SinkModifyOperation)operation;
            return sinkModifyOperation.isDelete() || sinkModifyOperation.isUpdate();
        }
        return false;
    }
}

