/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.test.program.TestStep;

public abstract class TableTestStep
implements TestStep {
    public final String name;
    public final List<String> schemaComponents;
    public final List<String> partitionKeys;
    public final Map<String, String> options;

    TableTestStep(String name, List<String> schemaComponents, List<String> partitionKeys, Map<String, String> options) {
        this.name = name;
        this.schemaComponents = schemaComponents;
        this.partitionKeys = partitionKeys;
        this.options = options;
    }

    public TableResult apply(TableEnvironment env) {
        return this.apply(env, Collections.emptyMap());
    }

    public TableResult apply(TableEnvironment env, Map<String, String> extraOptions) {
        HashMap<String, String> allOptions = new HashMap<String, String>(this.options);
        allOptions.putAll(extraOptions);
        String partitionedBy = this.partitionKeys.isEmpty() ? "" : "PARTITIONED BY (" + String.join((CharSequence)", ", this.partitionKeys) + ")\n";
        String createTable = String.format("CREATE TABLE %s (\n%s)\n%sWITH (\n%s)", this.name, String.join((CharSequence)",\n", this.schemaComponents), partitionedBy, allOptions.entrySet().stream().map(e -> String.format("'%s'='%s'", e.getKey(), e.getValue())).collect(Collectors.joining(",\n")));
        return env.executeSql(createTable);
    }

    protected static abstract class AbstractBuilder<SpecificBuilder extends AbstractBuilder<SpecificBuilder>> {
        protected final String name;
        protected final List<String> schemaComponents = new ArrayList<String>();
        protected final List<String> partitionKeys = new ArrayList<String>();
        protected final Map<String, String> options = new HashMap<String, String>();

        protected AbstractBuilder(String name) {
            this.name = name;
        }

        public SpecificBuilder addSchema(String ... schemaComponents) {
            this.schemaComponents.addAll(Arrays.asList(schemaComponents));
            return (SpecificBuilder)this;
        }

        public SpecificBuilder addSchema(List<String> schemaComponents) {
            this.schemaComponents.addAll(schemaComponents);
            return (SpecificBuilder)this;
        }

        public SpecificBuilder addOptions(Map<String, String> options) {
            this.options.putAll(options);
            return (SpecificBuilder)this;
        }

        public SpecificBuilder addOption(String key, String value) {
            this.options.put(key, value);
            return (SpecificBuilder)this;
        }

        public <T> SpecificBuilder addOption(ConfigOption<T> option, String value) {
            this.options.put(option.key(), (String)ConfigurationUtils.convertValue((Object)value, String.class));
            return (SpecificBuilder)this;
        }

        public SpecificBuilder addPartitionKeys(String ... partitionKeys) {
            this.partitionKeys.addAll(Arrays.asList(partitionKeys));
            return (SpecificBuilder)this;
        }
    }
}

