/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.test.program.TableTestStep;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.types.Row;

public final class SinkTestStep
extends TableTestStep {
    @Nullable
    public final List<Row> expectedBeforeRestore;
    @Nullable
    public final List<Row> expectedAfterRestore;
    @Nullable
    public final List<String> expectedBeforeRestoreStrings;
    @Nullable
    public final List<String> expectedAfterRestoreStrings;
    public final boolean testChangelogData;

    SinkTestStep(String name, List<String> schemaComponents, List<String> partitionKeys, Map<String, String> options, @Nullable List<Row> expectedBeforeRestore, @Nullable List<Row> expectedAfterRestore, @Nullable List<String> expectedBeforeRestoreStrings, @Nullable List<String> expectedAfterRestoreStrings, boolean testChangelogData) {
        super(name, schemaComponents, partitionKeys, options);
        if (expectedBeforeRestore != null && expectedAfterRestoreStrings != null) {
            throw new IllegalArgumentException("You can not mix Row/String representation in before/after restore data.");
        }
        if (expectedBeforeRestoreStrings != null && expectedAfterRestore != null) {
            throw new IllegalArgumentException("You can not mix Row/String representation in before/after restore data.");
        }
        this.expectedBeforeRestore = expectedBeforeRestore;
        this.expectedAfterRestore = expectedAfterRestore;
        this.expectedBeforeRestoreStrings = expectedBeforeRestoreStrings;
        this.expectedAfterRestoreStrings = expectedAfterRestoreStrings;
        this.testChangelogData = testChangelogData;
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public List<String> getExpectedBeforeRestoreAsStrings() {
        if (this.expectedBeforeRestoreStrings != null) {
            return this.expectedBeforeRestoreStrings;
        }
        if (this.expectedBeforeRestore != null) {
            return this.expectedBeforeRestore.stream().map(Row::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<String> getExpectedAfterRestoreAsStrings() {
        if (this.expectedAfterRestoreStrings != null) {
            return this.expectedAfterRestoreStrings;
        }
        if (this.expectedAfterRestore != null) {
            return this.expectedAfterRestore.stream().map(Row::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<String> getExpectedAsStrings() {
        ArrayList<String> data = new ArrayList<String>(this.getExpectedBeforeRestoreAsStrings());
        data.addAll(this.getExpectedAfterRestoreAsStrings());
        return data;
    }

    @Override
    public TestStep.TestKind getKind() {
        return this.expectedBeforeRestore == null && this.expectedBeforeRestoreStrings == null ? TestStep.TestKind.SINK_WITHOUT_DATA : (this.expectedAfterRestore == null && this.expectedAfterRestoreStrings == null ? TestStep.TestKind.SINK_WITH_DATA : TestStep.TestKind.SINK_WITH_RESTORE_DATA);
    }

    public boolean getTestChangelogData() {
        return this.testChangelogData;
    }

    public static final class Builder
    extends TableTestStep.AbstractBuilder<Builder> {
        private List<Row> expectedBeforeRestore;
        private List<Row> expectedAfterRestore;
        private List<String> expectedBeforeRestoreStrings;
        private List<String> expectedAfterRestoreStrings;
        private boolean testChangelogData = true;

        private Builder(String name) {
            super(name);
        }

        public Builder consumedValues(Row ... expectedRows) {
            return this.consumedBeforeRestore(expectedRows);
        }

        public Builder consumedValues(String ... expectedRows) {
            return this.consumedBeforeRestore(expectedRows);
        }

        public Builder consumedBeforeRestore(Row ... expectedRows) {
            this.expectedBeforeRestore = Arrays.asList(expectedRows);
            return this;
        }

        public Builder consumedBeforeRestore(String ... expectedRows) {
            this.expectedBeforeRestoreStrings = Arrays.asList(expectedRows);
            return this;
        }

        public Builder consumedAfterRestore(Row ... expectedRows) {
            this.expectedAfterRestore = Arrays.asList(expectedRows);
            return this;
        }

        public Builder consumedAfterRestore(String ... expectedRows) {
            this.expectedAfterRestoreStrings = Arrays.asList(expectedRows);
            return this;
        }

        public Builder testChangelogData() {
            this.testChangelogData = true;
            return this;
        }

        public Builder testMaterializedData() {
            this.testChangelogData = false;
            return this;
        }

        public SinkTestStep build() {
            return new SinkTestStep(this.name, this.schemaComponents, this.partitionKeys, this.options, this.expectedBeforeRestore, this.expectedAfterRestore, this.expectedBeforeRestoreStrings, this.expectedAfterRestoreStrings, this.testChangelogData);
        }
    }
}

