/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.test.program.TestStep;

public final class FunctionTestStep
implements TestStep {
    public final FunctionPersistence persistence;
    public final FunctionBehavior behavior;
    public final String name;
    public final Class<? extends UserDefinedFunction> function;

    FunctionTestStep(FunctionPersistence persistence, FunctionBehavior behavior, String name, Class<? extends UserDefinedFunction> function) {
        this.persistence = persistence;
        this.behavior = behavior;
        this.name = name;
        this.function = function;
    }

    @Override
    public TestStep.TestKind getKind() {
        return TestStep.TestKind.FUNCTION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void apply(TableEnvironment env) {
        if (this.behavior == FunctionBehavior.SYSTEM) {
            if (this.persistence != FunctionPersistence.TEMPORARY) throw new UnsupportedOperationException("System functions must be temporary.");
            env.createTemporarySystemFunction(this.name, this.function);
            return;
        } else if (this.persistence == FunctionPersistence.TEMPORARY) {
            env.createTemporaryFunction(this.name, this.function);
            return;
        } else {
            env.createFunction(this.name, this.function);
        }
    }

    static enum FunctionBehavior {
        SYSTEM,
        CATALOG;

    }

    static enum FunctionPersistence {
        TEMPORARY,
        PERSISTENT;

    }
}

