/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.catalog.FileCatalogStore;
import org.apache.flink.table.catalog.GenericInMemoryCatalogFactoryOptions;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileCatalogStoreTest {
    private static final String CATALOG_STORE_DIR_NAME = "dummy-catalog-store";
    private static final String DUMMY = "dummy";
    private static final CatalogDescriptor DUMMY_CATALOG;
    @TempDir
    private Path tempDir;

    FileCatalogStoreTest() {
    }

    @Test
    void testNotOpened() {
        CatalogStore catalogStore = this.initCatalogStore();
        this.assertCatalogStoreNotOpened(() -> ((CatalogStore)catalogStore).listCatalogs());
        this.assertCatalogStoreNotOpened(() -> catalogStore.contains(DUMMY));
        this.assertCatalogStoreNotOpened(() -> catalogStore.getCatalog(DUMMY));
        this.assertCatalogStoreNotOpened(() -> catalogStore.storeCatalog(DUMMY, DUMMY_CATALOG));
        this.assertCatalogStoreNotOpened(() -> catalogStore.removeCatalog(DUMMY, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCannotMakeStorePath() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).as("setWritable doesn't work on Windows.", new Object[0])).isFalse();
        Path storeParentPath = this.tempDir.resolve("parent");
        AssertionsForClassTypes.assertThat((boolean)storeParentPath.toFile().mkdir()).isTrue();
        Path storePath = storeParentPath.resolve(CATALOG_STORE_DIR_NAME);
        FileCatalogStore catalogStore = new FileCatalogStore(storePath.toString());
        File storeParentFile = storeParentPath.toFile();
        try {
            AssertionsForClassTypes.assertThat((boolean)storeParentFile.setWritable(false, false)).isTrue();
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> ((FileCatalogStore)catalogStore).open()).isInstanceOf(CatalogException.class)).hasMessageContaining("Failed to open file catalog store directory " + storePath + ".").hasRootCauseInstanceOf(FileNotFoundException.class);
        }
        finally {
            storeParentFile.setWritable(true, false);
        }
    }

    @Test
    void testStore() {
        CatalogStore catalogStore = this.initCatalogStore();
        catalogStore.open();
        catalogStore.storeCatalog(DUMMY, DUMMY_CATALOG);
        File catalog = this.getCatalogFile();
        AssertionsForClassTypes.assertThat((boolean)catalog.exists()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)catalog.isFile()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)catalogStore.contains(DUMMY)).isTrue();
        Set storedCatalogs = catalogStore.listCatalogs();
        AssertionsForClassTypes.assertThat((int)storedCatalogs.size()).isEqualTo(1);
        AssertionsForClassTypes.assertThat((boolean)storedCatalogs.contains(DUMMY)).isTrue();
    }

    @Test
    void testRemoveExisting() {
        CatalogStore catalogStore = this.initCatalogStore();
        catalogStore.open();
        catalogStore.storeCatalog(DUMMY, DUMMY_CATALOG);
        AssertionsForClassTypes.assertThat((int)catalogStore.listCatalogs().size()).isEqualTo(1);
        catalogStore.removeCatalog(DUMMY, false);
        AssertionsForClassTypes.assertThat((int)catalogStore.listCatalogs().size()).isEqualTo(0);
        AssertionsForClassTypes.assertThat((boolean)catalogStore.contains(DUMMY)).isFalse();
        File catalog = this.getCatalogFile();
        AssertionsForClassTypes.assertThat((boolean)catalog.exists()).isFalse();
    }

    @Test
    void testRemoveNonExisting() {
        CatalogStore catalogStore = this.initCatalogStore();
        catalogStore.open();
        catalogStore.removeCatalog(DUMMY, true);
        File catalog = this.getCatalogFile();
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> catalogStore.removeCatalog(DUMMY, false)).isInstanceOf(CatalogException.class)).hasMessageContaining("Catalog dummy's store file " + catalog + " does not exist.");
    }

    @Test
    void testClose() {
        CatalogStore catalogStore = this.initCatalogStore();
        catalogStore.open();
        catalogStore.storeCatalog(DUMMY, DUMMY_CATALOG);
        AssertionsForClassTypes.assertThat((int)catalogStore.listCatalogs().size()).isEqualTo(1);
        catalogStore.close();
        this.assertCatalogStoreNotOpened(() -> ((CatalogStore)catalogStore).listCatalogs());
        this.assertCatalogStoreNotOpened(() -> catalogStore.contains(DUMMY));
        this.assertCatalogStoreNotOpened(() -> catalogStore.getCatalog(DUMMY));
        this.assertCatalogStoreNotOpened(() -> catalogStore.storeCatalog(DUMMY, DUMMY_CATALOG));
        this.assertCatalogStoreNotOpened(() -> catalogStore.removeCatalog(DUMMY, true));
    }

    private void assertCatalogStoreNotOpened(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy((ThrowableAssert.ThrowingCallable)shouldRaiseThrowable).isInstanceOf(IllegalStateException.class)).hasMessageContaining("CatalogStore is not opened yet.");
    }

    private CatalogStore initCatalogStore() {
        Path catalogStorePath = this.tempDir.resolve(CATALOG_STORE_DIR_NAME);
        return new FileCatalogStore(catalogStorePath.toString());
    }

    private File getCatalogFile() {
        return this.tempDir.resolve(CATALOG_STORE_DIR_NAME).resolve("dummy.yaml").toFile();
    }

    static {
        Configuration conf = new Configuration();
        conf.set(CommonCatalogOptions.CATALOG_TYPE, (Object)DUMMY);
        conf.set(GenericInMemoryCatalogFactoryOptions.DEFAULT_DATABASE, (Object)"dummy_db");
        DUMMY_CATALOG = CatalogDescriptor.of((String)DUMMY, (Configuration)conf);
    }
}

