/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

public class AlterTableAddConstraintOperation
extends AlterTableOperation {
    private final String constraintName;
    private final String[] columnNames;

    public AlterTableAddConstraintOperation(ObjectIdentifier tableIdentifier, @Nullable String constraintName, String[] columnNames) {
        super(tableIdentifier);
        this.constraintName = constraintName;
        this.columnNames = columnNames;
    }

    public Optional<String> getConstraintName() {
        return Optional.ofNullable(this.constraintName);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.tableIdentifier);
        if (this.getConstraintName().isPresent()) {
            params.put("constraintName", this.constraintName);
        }
        params.put("columns", this.columnNames);
        return OperationUtils.formatWithChildren("ALTER TABLE ADD CONSTRAINT", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

