/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.table.utils.TableSourceMock;
import org.apache.flink.types.Row;

public class TableSourceFactoryMock
implements TableSourceFactory<Row> {
    public static final String CONNECTOR_TYPE_VALUE = "table-source-factory-mock";

    public TableSource<Row> createTableSource(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(properties);
        TableSchema schema = TableSchemaUtils.getPhysicalSchema((TableSchema)descriptorProperties.getTableSchema("schema"));
        return new TableSourceMock(schema);
    }

    public TableSource<Row> createTableSource(ObjectPath tablePath, CatalogTable table) {
        return new TableSourceMock(TableSchemaUtils.getPhysicalSchema((TableSchema)table.getSchema()));
    }

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", CONNECTOR_TYPE_VALUE);
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> supportedProperties = new ArrayList<String>();
        supportedProperties.add("update-mode");
        supportedProperties.add("connector.property-version");
        supportedProperties.add("format.*");
        supportedProperties.add("schema.#.name");
        supportedProperties.add("schema.#.data-type");
        supportedProperties.add("schema.#.type");
        supportedProperties.add("schema.#.expr");
        supportedProperties.add("schema.watermark.#.rowtime");
        supportedProperties.add("schema.watermark.#.strategy.expr");
        supportedProperties.add("schema.watermark.#.strategy.data-type");
        supportedProperties.add("schema.primary-key.name");
        supportedProperties.add("schema.primary-key.columns");
        supportedProperties.add("comment");
        return supportedProperties;
    }
}

