/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;

public class ModuleMock
implements Module {
    private static final Set<String> BUILT_IN_FUNCTIONS = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("dummy")));
    private final String type;
    private final FunctionDefinitionMock functionDef;

    public ModuleMock(String type) {
        this.type = type;
        this.functionDef = new FunctionDefinitionMock();
        this.functionDef.functionKind = FunctionKind.OTHER;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> listFunctions() {
        return BUILT_IN_FUNCTIONS;
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        if (BUILT_IN_FUNCTIONS.contains(name)) {
            return Optional.of(this.functionDef);
        }
        return Optional.empty();
    }
}

