/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.module.CoreModule;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleEntry;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.utils.ModuleMock;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ModuleManagerTest
extends TestLogger {
    private ModuleManager manager;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void before() {
        this.manager = new ModuleManager();
    }

    @Test
    public void testLoadModuleTwice() {
        Assert.assertEquals(Collections.singletonList("core"), (Object)this.manager.getUsedModules());
        Assert.assertEquals((Object)CoreModule.INSTANCE, this.manager.getLoadedModules().get("core"));
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("A module with name 'core' already exists");
        this.manager.loadModule("core", (Module)CoreModule.INSTANCE);
    }

    @Test
    public void testLoadModuleWithoutUnusedModulesExist() {
        ModuleMock x = new ModuleMock("x");
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule(x.getType(), (Module)x);
        this.manager.loadModule(y.getType(), (Module)y);
        this.manager.loadModule(z.getType(), (Module)z);
        HashMap<String, Object> expectedLoadedModules = new HashMap<String, Object>();
        expectedLoadedModules.put("core", CoreModule.INSTANCE);
        expectedLoadedModules.put("x", x);
        expectedLoadedModules.put("y", y);
        expectedLoadedModules.put("z", z);
        Assert.assertEquals(Arrays.asList("core", "x", "y", "z"), (Object)this.manager.getUsedModules());
        Assert.assertEquals(expectedLoadedModules, (Object)this.manager.getLoadedModules());
    }

    @Test
    public void testLoadModuleWithUnusedModulesExist() {
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule(y.getType(), (Module)y);
        this.manager.loadModule(z.getType(), (Module)z);
        HashMap<String, Object> expectedLoadedModules = new HashMap<String, Object>();
        expectedLoadedModules.put("core", CoreModule.INSTANCE);
        expectedLoadedModules.put("y", y);
        expectedLoadedModules.put("z", z);
        Assert.assertEquals(Arrays.asList("core", "y", "z"), (Object)this.manager.getUsedModules());
        Assert.assertEquals(expectedLoadedModules, (Object)this.manager.getLoadedModules());
        this.manager.useModules(new String[]{"core"});
        ModuleMock x = new ModuleMock("x");
        this.manager.loadModule(x.getType(), (Module)x);
        expectedLoadedModules.put("x", x);
        Assert.assertEquals(Arrays.asList("core", "x"), (Object)this.manager.getUsedModules());
        Assert.assertEquals(expectedLoadedModules, (Object)this.manager.getLoadedModules());
    }

    @Test
    public void testUnloadModuleTwice() {
        Assert.assertEquals(Collections.singletonList("core"), (Object)this.manager.getUsedModules());
        this.manager.unloadModule("core");
        Assert.assertEquals(Collections.emptyList(), (Object)this.manager.getUsedModules());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.manager.getLoadedModules());
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("No module with name 'core' exists");
        this.manager.unloadModule("core");
    }

    @Test
    public void testUseUnloadedModules() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("No module with name 'x' exists");
        this.manager.useModules(new String[]{"core", "x"});
    }

    @Test
    public void testUseModulesWithDuplicateModuleName() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Module 'core' appears more than once");
        this.manager.useModules(new String[]{"core", "core"});
    }

    @Test
    public void testUseModules() {
        ModuleMock x = new ModuleMock("x");
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule(x.getType(), (Module)x);
        this.manager.loadModule(y.getType(), (Module)y);
        this.manager.loadModule(z.getType(), (Module)z);
        Assert.assertEquals(Arrays.asList("core", "x", "y", "z"), (Object)this.manager.getUsedModules());
        this.manager.useModules(new String[]{"z", "core"});
        Assert.assertEquals(Arrays.asList("z", "core"), (Object)this.manager.getUsedModules());
        HashMap<String, Object> expectedLoadedModules = new HashMap<String, Object>();
        expectedLoadedModules.put("core", CoreModule.INSTANCE);
        expectedLoadedModules.put("x", x);
        expectedLoadedModules.put("y", y);
        expectedLoadedModules.put("z", z);
        Assert.assertEquals(expectedLoadedModules, (Object)this.manager.getLoadedModules());
    }

    @Test
    public void testListModules() {
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule("y", (Module)y);
        this.manager.loadModule("z", (Module)z);
        this.manager.useModules(new String[]{"z", "y"});
        Assert.assertEquals(Arrays.asList("z", "y"), (Object)this.manager.listModules());
    }

    @Test
    public void testListFullModules() {
        ModuleMock x = new ModuleMock("x");
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule("y", (Module)y);
        this.manager.loadModule("x", (Module)x);
        this.manager.loadModule("z", (Module)z);
        this.manager.useModules(new String[]{"z", "y"});
        Assert.assertEquals(ModuleManagerTest.getExpectedModuleEntries(2, "z", "y", "core", "x"), (Object)this.manager.listFullModules());
    }

    @Test
    public void testListFunctions() {
        ModuleMock x = new ModuleMock("x");
        this.manager.loadModule(x.getType(), (Module)x);
        Assert.assertTrue((boolean)this.manager.listFunctions().contains("dummy"));
        this.manager.useModules(new String[]{"core"});
        Assert.assertFalse((boolean)this.manager.listFunctions().contains("dummy"));
    }

    @Test
    public void testGetFunctionDefinition() {
        ModuleMock x = new ModuleMock("x");
        this.manager.loadModule(x.getType(), (Module)x);
        Assert.assertTrue((boolean)this.manager.getFunctionDefinition("dummy").isPresent());
        this.manager.useModules(new String[]{"core"});
        Assert.assertFalse((boolean)this.manager.getFunctionDefinition("dummy").isPresent());
    }

    private static List<ModuleEntry> getExpectedModuleEntries(int index, String ... names) {
        return IntStream.range(0, names.length).mapToObj(i -> new ModuleEntry(names[i], i < index)).collect(Collectors.toList());
    }
}

