/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CommonCatalogOptions;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalogFactoryOptions;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class GenericInMemoryCatalogFactoryTest
extends TestLogger {
    @Test
    public void test() throws Exception {
        String catalogName = "mycatalog";
        String databaseName = "mydatabase";
        GenericInMemoryCatalog expectedCatalog = new GenericInMemoryCatalog("mycatalog", "mydatabase");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CommonCatalogOptions.CATALOG_TYPE.key(), "generic_in_memory");
        options.put(GenericInMemoryCatalogFactoryOptions.DEFAULT_DATABASE.key(), "mydatabase");
        Catalog actualCatalog = FactoryUtil.createCatalog((String)"mycatalog", options, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        GenericInMemoryCatalogFactoryTest.checkEquals(expectedCatalog, (GenericInMemoryCatalog)actualCatalog);
    }

    private static void checkEquals(GenericInMemoryCatalog c1, GenericInMemoryCatalog c2) throws Exception {
        Assert.assertEquals((Object)c1.getName(), (Object)c2.getName());
        Assert.assertEquals((Object)c1.getDefaultDatabase(), (Object)c2.getDefaultDatabase());
        Assert.assertEquals((Object)c1.listDatabases(), (Object)c2.listDatabases());
        String database = c1.getDefaultDatabase();
        Assert.assertEquals((Object)c1.listTables(database), (Object)c2.listTables(database));
        Assert.assertEquals((Object)c1.listViews(database), (Object)c2.listViews(database));
        Assert.assertEquals((Object)c1.listFunctions(database), (Object)c2.listFunctions(database));
    }
}

