/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ExternalSchemaTranslator;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.types.Row;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ExternalSchemaTranslatorTest {
    @Test
    public void testInputFromRow() {
        TypeInformation inputTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT, Types.BOOLEAN}), Types.ENUM(DayOfWeek.class)});
        ExternalSchemaTranslator.InputResult result = ExternalSchemaTranslator.fromExternal((DataTypeFactory)ExternalSchemaTranslatorTest.dataTypeFactoryWithRawType(DayOfWeek.class), (TypeInformation)inputTypeInfo, null);
        Assert.assertEquals((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), DataTypes.FIELD((String)"f1", (DataType)DataTypeFactoryMock.dummyRaw(DayOfWeek.class))}).notNull(), (Object)result.getPhysicalDataType());
        Assert.assertTrue((boolean)result.isTopLevelRecord());
        Assert.assertEquals((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})).column("f1", (AbstractDataType)DataTypeFactoryMock.dummyRaw(DayOfWeek.class)).build(), (Object)result.getSchema());
        Assert.assertNull((Object)result.getProjections());
    }

    @Test
    public void testOutputToRowDataType() {
        ResolvedSchema inputSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)DataTypes.INT()), Column.physical((String)"a", (DataType)DataTypes.BOOLEAN()), Column.physical((String)"b", (DataType)DataTypes.DOUBLE())});
        DataType physicalDataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"b", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c", (DataType)DataTypes.INT())});
        ExternalSchemaTranslator.OutputResult result = ExternalSchemaTranslator.fromInternal((DataTypeFactory)ExternalSchemaTranslatorTest.dataTypeFactory(), (ResolvedSchema)inputSchema, (AbstractDataType)physicalDataType);
        Assert.assertEquals(Optional.of(Arrays.asList("a", "b", "c")), (Object)result.getProjections());
        Assert.assertEquals((Object)Schema.newBuilder().column("a", (AbstractDataType)DataTypes.BOOLEAN()).column("b", (AbstractDataType)DataTypes.DOUBLE()).column("c", (AbstractDataType)DataTypes.INT()).build(), (Object)result.getSchema());
        Assert.assertEquals(Optional.of(physicalDataType), (Object)result.getPhysicalDataType());
    }

    @Test
    public void testInputFromAtomic() {
        TypeInformation inputTypeInfo = Types.GENERIC(Row.class);
        ExternalSchemaTranslator.InputResult result = ExternalSchemaTranslator.fromExternal((DataTypeFactory)ExternalSchemaTranslatorTest.dataTypeFactoryWithRawType(Row.class), (TypeInformation)inputTypeInfo, null);
        Assert.assertEquals((Object)DataTypeFactoryMock.dummyRaw(Row.class), (Object)result.getPhysicalDataType());
        Assert.assertFalse((boolean)result.isTopLevelRecord());
        Assert.assertEquals((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypeFactoryMock.dummyRaw(Row.class)).build(), (Object)result.getSchema());
        Assert.assertNull((Object)result.getProjections());
    }

    @Test
    public void testOutputToAtomicDataType() {
        ResolvedSchema inputSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.INT())});
        ExternalSchemaTranslator.OutputResult result = ExternalSchemaTranslator.fromInternal((DataTypeFactory)ExternalSchemaTranslatorTest.dataTypeFactory(), (ResolvedSchema)inputSchema, (AbstractDataType)DataTypes.INT());
        Assert.assertEquals(Optional.empty(), (Object)result.getProjections());
        Assert.assertEquals((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build(), (Object)result.getSchema());
        Assert.assertEquals(Optional.of(DataTypes.INT()), (Object)result.getPhysicalDataType());
    }

    @Test
    public void testInputFromRowWithNonPhysicalDeclaredSchema() {
        TypeInformation inputTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT, Types.LONG});
        ExternalSchemaTranslator.InputResult result = ExternalSchemaTranslator.fromExternal((DataTypeFactory)ExternalSchemaTranslatorTest.dataTypeFactory(), (TypeInformation)inputTypeInfo, (Schema)Schema.newBuilder().columnByExpression("computed", "f1 + 42").columnByExpression("computed2", "f1 - 1").primaryKeyNamed("pk", new String[]{"f0"}).build());
        Assert.assertEquals((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT())}).notNull(), (Object)result.getPhysicalDataType());
        Assert.assertTrue((boolean)result.isTopLevelRecord());
        Assert.assertEquals((Object)Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.BIGINT()).columnByExpression("computed", "f1 + 42").columnByExpression("computed2", "f1 - 1").primaryKeyNamed("pk", new String[]{"f0"}).build(), (Object)result.getSchema());
        Assert.assertNull((Object)result.getProjections());
    }

    @Test
    public void testInputFromRowWithPhysicalDeclaredSchema() {
        TypeInformation inputTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT, Types.LONG, Types.GENERIC(BigDecimal.class), Types.BOOLEAN});
        ExternalSchemaTranslator.InputResult result = ExternalSchemaTranslator.fromExternal((DataTypeFactory)ExternalSchemaTranslatorTest.dataTypeFactoryWithRawType(BigDecimal.class), (TypeInformation)inputTypeInfo, (Schema)Schema.newBuilder().primaryKeyNamed("pk", new String[]{"f0"}).column("f1", (AbstractDataType)DataTypes.BIGINT()).column("f0", (AbstractDataType)DataTypes.INT()).columnByExpression("computed", "f1 + 42").column("f2", (AbstractDataType)DataTypes.DECIMAL((int)10, (int)2)).columnByExpression("computed2", "f1 - 1").build());
        Assert.assertEquals((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f3", (DataType)DataTypes.BOOLEAN())}).notNull(), (Object)result.getPhysicalDataType());
        Assert.assertTrue((boolean)result.isTopLevelRecord());
        Assert.assertEquals((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).column("f1", (AbstractDataType)DataTypes.BIGINT()).column("f2", (AbstractDataType)DataTypes.DECIMAL((int)10, (int)2)).column("f3", (AbstractDataType)DataTypes.BOOLEAN()).columnByExpression("computed", "f1 + 42").columnByExpression("computed2", "f1 - 1").primaryKeyNamed("pk", new String[]{"f0"}).build(), (Object)result.getSchema());
        Assert.assertEquals(Arrays.asList("f1", "f0", "computed", "f2", "computed2"), (Object)result.getProjections());
    }

    @Test
    public void testInputFromAtomicWithPhysicalDeclaredSchema() {
        TypeInformation inputTypeInfo = Types.GENERIC(Row.class);
        ExternalSchemaTranslator.InputResult result = ExternalSchemaTranslator.fromExternal((DataTypeFactory)ExternalSchemaTranslatorTest.dataTypeFactoryWithRawType(Row.class), (TypeInformation)inputTypeInfo, (Schema)Schema.newBuilder().columnByExpression("f0_0", "f0.f0_0").column("f0", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0_0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f0_1", (DataType)DataTypes.BOOLEAN())})).columnByExpression("f0_1", "f0.f0_1").build());
        Assert.assertEquals((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0_0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f0_1", (DataType)DataTypes.BOOLEAN())}), (Object)result.getPhysicalDataType());
        Assert.assertFalse((boolean)result.isTopLevelRecord());
        Assert.assertEquals((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0_0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f0_1", (DataType)DataTypes.BOOLEAN())})).columnByExpression("f0_0", "f0.f0_0").columnByExpression("f0_1", "f0.f0_1").build(), (Object)result.getSchema());
        Assert.assertEquals(Arrays.asList("f0_0", "f0", "f0_1"), (Object)result.getProjections());
    }

    @Test
    public void testInvalidDeclaredSchemaColumn() {
        TypeInformation inputTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT, Types.LONG});
        try {
            ExternalSchemaTranslator.fromExternal((DataTypeFactory)ExternalSchemaTranslatorTest.dataTypeFactory(), (TypeInformation)inputTypeInfo, (Schema)Schema.newBuilder().column("INVALID", (AbstractDataType)DataTypes.BIGINT()).build());
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)FlinkMatchers.containsMessage((String)"Unable to find a field named 'INVALID' in the physical data type"));
        }
    }

    @Test
    public void testOutputToNoSchema() {
        ResolvedSchema tableSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.BIGINT()), Column.metadata((String)"rowtime", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), null, (boolean)false), Column.physical((String)"name", (DataType)DataTypes.STRING())});
        ExternalSchemaTranslator.OutputResult result = ExternalSchemaTranslator.fromInternal((ResolvedSchema)tableSchema, null);
        Assert.assertEquals(Optional.empty(), (Object)result.getProjections());
        Assert.assertEquals((Object)Schema.newBuilder().column("id", (AbstractDataType)DataTypes.BIGINT()).column("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).column("name", (AbstractDataType)DataTypes.STRING()).build(), (Object)result.getSchema());
        Assert.assertEquals(Optional.empty(), (Object)result.getPhysicalDataType());
    }

    @Test
    public void testOutputToMetadataSchema() {
        ResolvedSchema tableSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.BIGINT()), Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.metadata((String)"rowtime", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), null, (boolean)false)});
        ExternalSchemaTranslator.OutputResult result = ExternalSchemaTranslator.fromInternal((ResolvedSchema)tableSchema, (Schema)Schema.newBuilder().columnByExpression("computed", "f1 + 42").columnByMetadata("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).build());
        Assert.assertEquals((Object)Schema.newBuilder().column("id", (AbstractDataType)DataTypes.BIGINT()).column("name", (AbstractDataType)DataTypes.STRING()).columnByExpression("computed", "f1 + 42").columnByMetadata("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).build(), (Object)result.getSchema());
    }

    @Test
    public void testOutputToDeclaredSchema() {
        ResolvedSchema tableSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.BIGINT()), Column.physical((String)"rowtime", (DataType)DataTypes.TIMESTAMP_LTZ((int)3)), Column.physical((String)"name", (DataType)DataTypes.STRING())});
        ExternalSchemaTranslator.OutputResult result = ExternalSchemaTranslator.fromInternal((ResolvedSchema)tableSchema, (Schema)Schema.newBuilder().column("id", (AbstractDataType)DataTypes.BIGINT()).columnByMetadata("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).column("name", DataTypes.STRING().bridgedTo(StringData.class)).build());
        Assert.assertEquals((Object)Schema.newBuilder().column("id", (AbstractDataType)DataTypes.BIGINT()).columnByMetadata("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).column("name", DataTypes.STRING().bridgedTo(StringData.class)).build(), (Object)result.getSchema());
    }

    private static DataTypeFactory dataTypeFactoryWithRawType(Class<?> rawType) {
        DataTypeFactoryMock dataTypeFactory = new DataTypeFactoryMock();
        dataTypeFactory.dataType = Optional.of(DataTypeFactoryMock.dummyRaw(rawType));
        return dataTypeFactory;
    }

    private static DataTypeFactory dataTypeFactory() {
        return new DataTypeFactoryMock();
    }
}

