/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.junit.Assert;
import org.junit.Test;

public class CatalogTableImpTest {
    private static final String TEST = "test";

    @Test
    public void testToProperties() {
        TableSchema schema = CatalogTableImpTest.createTableSchema();
        Map<String, String> prop = CatalogTableImpTest.createProperties();
        CatalogTableImpl table = new CatalogTableImpl(schema, CatalogTableImpTest.createPartitionKeys(), prop, TEST);
        DescriptorProperties descriptorProperties = new DescriptorProperties(false);
        descriptorProperties.putProperties(table.toProperties());
        Assert.assertEquals((Object)schema, (Object)descriptorProperties.getTableSchema("schema"));
    }

    @Test
    public void testFromProperties() {
        TableSchema schema = CatalogTableImpTest.createTableSchema();
        Map<String, String> prop = CatalogTableImpTest.createProperties();
        CatalogTableImpl table = new CatalogTableImpl(schema, CatalogTableImpTest.createPartitionKeys(), prop, TEST);
        CatalogTableImpl tableFromProperties = CatalogTableImpl.fromProperties((Map)table.toProperties());
        Assert.assertEquals((Object)tableFromProperties.getOptions(), (Object)table.getOptions());
        Assert.assertEquals((Object)tableFromProperties.getPartitionKeys(), (Object)table.getPartitionKeys());
        Assert.assertEquals((Object)tableFromProperties.getSchema(), (Object)table.getSchema());
    }

    private static Map<String, String> createProperties() {
        return new HashMap<String, String>(){
            {
                this.put("k", "v");
                this.put("K1", "V1");
            }
        };
    }

    private static TableSchema createTableSchema() {
        return TableSchema.builder().field("first", DataTypes.STRING()).field("second", DataTypes.INT()).field("third", DataTypes.DOUBLE()).field("Fourth", DataTypes.BOOLEAN()).build();
    }

    private static List<String> createPartitionKeys() {
        return Arrays.asList("second", "third");
    }
}

