/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.expressions.utils.ResolvedExpressionMock;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.table.utils.ExpressionResolverMocks;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CatalogBaseTableResolutionTest {
    private static final ObjectIdentifier IDENTIFIER = ObjectIdentifier.of((String)"default_catalog", (String)"default_database", (String)"TestTable");
    private static final String COMPUTED_SQL = "orig_ts - INTERVAL '60' MINUTE";
    private static final ResolvedExpression COMPUTED_COLUMN_RESOLVED = new ResolvedExpressionMock(DataTypes.TIMESTAMP((int)3), () -> "orig_ts - INTERVAL '60' MINUTE");
    private static final String WATERMARK_SQL = "ts - INTERVAL '5' SECOND";
    private static final ResolvedExpression WATERMARK_RESOLVED = new ResolvedExpressionMock(DataTypes.TIMESTAMP((int)3), () -> "ts - INTERVAL '5' SECOND");
    private static final Schema TABLE_SCHEMA = Schema.newBuilder().column("id", DataTypes.INT().notNull()).column("region", (AbstractDataType)DataTypes.VARCHAR((int)200)).column("county", (AbstractDataType)DataTypes.VARCHAR((int)200)).columnByMetadata("topic", (AbstractDataType)DataTypes.VARCHAR((int)200), true).columnByMetadata("orig_ts", (AbstractDataType)DataTypes.TIMESTAMP((int)3), "timestamp").columnByExpression("ts", "orig_ts - INTERVAL '60' MINUTE").watermark("ts", "ts - INTERVAL '5' SECOND").primaryKeyNamed("primary_constraint", new String[]{"id"}).build();
    private static final TableSchema LEGACY_TABLE_SCHEMA = TableSchema.builder().add((TableColumn)TableColumn.physical((String)"id", (DataType)((DataType)DataTypes.INT().notNull()))).add((TableColumn)TableColumn.physical((String)"region", (DataType)DataTypes.VARCHAR((int)200))).add((TableColumn)TableColumn.physical((String)"county", (DataType)DataTypes.VARCHAR((int)200))).add((TableColumn)TableColumn.metadata((String)"topic", (DataType)DataTypes.VARCHAR((int)200), (boolean)true)).add((TableColumn)TableColumn.metadata((String)"orig_ts", (DataType)DataTypes.TIMESTAMP((int)3), (String)"timestamp")).add((TableColumn)TableColumn.computed((String)"ts", (DataType)DataTypes.TIMESTAMP((int)3), (String)"orig_ts - INTERVAL '60' MINUTE")).watermark("ts", "ts - INTERVAL '5' SECOND", DataTypes.TIMESTAMP((int)3)).primaryKey("primary_constraint", new String[]{"id"}).build();
    private static final Schema VIEW_SCHEMA = Schema.newBuilder().column("id", DataTypes.INT().notNull()).column("region", (AbstractDataType)DataTypes.VARCHAR((int)200)).column("county", (AbstractDataType)DataTypes.VARCHAR((int)200)).build();
    private static final ResolvedSchema RESOLVED_TABLE_SCHEMA = new ResolvedSchema(Arrays.asList(Column.physical((String)"id", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"region", (DataType)DataTypes.VARCHAR((int)200)), Column.physical((String)"county", (DataType)DataTypes.VARCHAR((int)200)), Column.metadata((String)"topic", (DataType)DataTypes.VARCHAR((int)200), null, (boolean)true), Column.metadata((String)"orig_ts", (DataType)DataTypes.TIMESTAMP((int)3), (String)"timestamp", (boolean)false), Column.computed((String)"ts", (ResolvedExpression)COMPUTED_COLUMN_RESOLVED)), Collections.singletonList(WatermarkSpec.of((String)"ts", (ResolvedExpression)WATERMARK_RESOLVED)), UniqueConstraint.primaryKey((String)"primary_constraint", Collections.singletonList("id")));
    private static final ResolvedSchema RESOLVED_VIEW_SCHEMA = new ResolvedSchema(Arrays.asList(Column.physical((String)"id", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"region", (DataType)DataTypes.VARCHAR((int)200)), Column.physical((String)"county", (DataType)DataTypes.VARCHAR((int)200))), Collections.emptyList(), null);

    @Test
    public void testCatalogTableResolution() {
        CatalogTable table = CatalogBaseTableResolutionTest.catalogTable();
        Assert.assertNotNull((Object)table.getUnresolvedSchema());
        ResolvedCatalogTable resolvedTable = CatalogBaseTableResolutionTest.resolveCatalogBaseTable(ResolvedCatalogTable.class, (CatalogBaseTable)table);
        Assert.assertThat((Object)resolvedTable.getResolvedSchema(), (Matcher)CoreMatchers.equalTo((Object)RESOLVED_TABLE_SCHEMA));
        Assert.assertThat((Object)resolvedTable.getSchema(), (Matcher)CoreMatchers.equalTo((Object)LEGACY_TABLE_SCHEMA));
    }

    @Test
    public void testCatalogViewResolution() {
        CatalogView view = CatalogBaseTableResolutionTest.catalogView();
        ResolvedCatalogView resolvedView = CatalogBaseTableResolutionTest.resolveCatalogBaseTable(ResolvedCatalogView.class, (CatalogBaseTable)view);
        Assert.assertThat((Object)resolvedView.getResolvedSchema(), (Matcher)CoreMatchers.equalTo((Object)RESOLVED_VIEW_SCHEMA));
    }

    @Test
    public void testPropertyDeSerialization() {
        CatalogTable table = CatalogTable.fromProperties(CatalogBaseTableResolutionTest.catalogTableAsProperties());
        ResolvedCatalogTable resolvedTable = CatalogBaseTableResolutionTest.resolveCatalogBaseTable(ResolvedCatalogTable.class, (CatalogBaseTable)table);
        Assert.assertThat((Object)resolvedTable.toProperties(), (Matcher)CoreMatchers.equalTo(CatalogBaseTableResolutionTest.catalogTableAsProperties()));
        Assert.assertThat((Object)resolvedTable.getResolvedSchema(), (Matcher)CoreMatchers.equalTo((Object)RESOLVED_TABLE_SCHEMA));
    }

    @Test
    public void testPropertyDeserializationError() {
        try {
            Map<String, String> properties = CatalogBaseTableResolutionTest.catalogTableAsProperties();
            properties.remove("schema.4.data-type");
            CatalogTable.fromProperties(properties);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsMessage((String)"Could not find property key 'schema.4.data-type'."));
        }
    }

    private static CatalogTable catalogTable() {
        String comment = "This is an example table.";
        List<String> partitionKeys = Arrays.asList("region", "county");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "custom");
        options.put("version", "12");
        return CatalogTable.of((Schema)TABLE_SCHEMA, (String)"This is an example table.", partitionKeys, options);
    }

    private static Map<String, String> catalogTableAsProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("schema.0.name", "id");
        properties.put("schema.0.data-type", "INT NOT NULL");
        properties.put("schema.1.name", "region");
        properties.put("schema.1.data-type", "VARCHAR(200)");
        properties.put("schema.2.name", "county");
        properties.put("schema.2.data-type", "VARCHAR(200)");
        properties.put("schema.3.name", "topic");
        properties.put("schema.3.data-type", "VARCHAR(200)");
        properties.put("schema.3.metadata", "topic");
        properties.put("schema.3.virtual", "true");
        properties.put("schema.4.name", "orig_ts");
        properties.put("schema.4.data-type", "TIMESTAMP(3)");
        properties.put("schema.4.metadata", "timestamp");
        properties.put("schema.4.virtual", "false");
        properties.put("schema.5.name", "ts");
        properties.put("schema.5.data-type", "TIMESTAMP(3)");
        properties.put("schema.5.expr", COMPUTED_SQL);
        properties.put("schema.watermark.0.rowtime", "ts");
        properties.put("schema.watermark.0.strategy.data-type", "TIMESTAMP(3)");
        properties.put("schema.watermark.0.strategy.expr", WATERMARK_SQL);
        properties.put("schema.primary-key.name", "primary_constraint");
        properties.put("schema.primary-key.columns", "id");
        properties.put("partition.keys.0.name", "region");
        properties.put("partition.keys.1.name", "county");
        properties.put("version", "12");
        properties.put("connector", "custom");
        properties.put("comment", "This is an example table.");
        return properties;
    }

    private static CatalogView catalogView() {
        String comment = "This is an example table.";
        String originalQuery = "SELECT * FROM T";
        String expandedQuery = String.format("SELECT id, region, county FROM %s.%s.T", "default_catalog", "default_database");
        return CatalogView.of((Schema)VIEW_SCHEMA, (String)"This is an example table.", (String)"SELECT * FROM T", (String)expandedQuery, Collections.emptyMap());
    }

    private static CatalogManager catalogManager() {
        CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        ExpressionResolver.ExpressionResolverBuilder expressionResolverBuilder = ExpressionResolverMocks.forSqlExpression(CatalogBaseTableResolutionTest::resolveSqlExpression);
        catalogManager.initSchemaResolver(true, expressionResolverBuilder);
        return catalogManager;
    }

    private static <T extends CatalogBaseTable> T resolveCatalogBaseTable(Class<T> expectedClass, CatalogBaseTable table) {
        CatalogBaseTable storedTable;
        CatalogManager catalogManager = CatalogBaseTableResolutionTest.catalogManager();
        catalogManager.createTable(table, IDENTIFIER, false);
        Catalog catalog = (Catalog)catalogManager.getCatalog("default_catalog").orElseThrow(IllegalStateException::new);
        Assert.assertTrue((String)"GenericInMemoryCatalog expected for test", (boolean)(catalog instanceof GenericInMemoryCatalog));
        try {
            storedTable = catalog.getTable(IDENTIFIER.toObjectPath());
        }
        catch (TableNotExistException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((String)"In-memory implies that output table equals input table.", (boolean)expectedClass.isAssignableFrom(storedTable.getClass()));
        return (T)((CatalogBaseTable)expectedClass.cast(storedTable));
    }

    private static ResolvedExpression resolveSqlExpression(String sqlExpression, RowType inputRowType, @Nullable LogicalType outputType) {
        switch (sqlExpression) {
            case "orig_ts - INTERVAL '60' MINUTE": {
                return COMPUTED_COLUMN_RESOLVED;
            }
            case "ts - INTERVAL '5' SECOND": {
                return WATERMARK_RESOLVED;
            }
        }
        throw new UnsupportedOperationException("Unknown SQL expression.");
    }
}

