/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.time.Duration;
import java.time.ZoneId;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableConfigTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static TableConfig configByMethod = new TableConfig();
    private static TableConfig configByConfiguration = new TableConfig();
    private static Configuration configuration = new Configuration();

    @Test
    public void testSetAndGetSqlDialect() {
        configuration.setString("table.sql-dialect", "HIVE");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setSqlDialect(SqlDialect.HIVE);
        Assert.assertEquals((Object)SqlDialect.HIVE, (Object)configByMethod.getSqlDialect());
        Assert.assertEquals((Object)SqlDialect.HIVE, (Object)configByConfiguration.getSqlDialect());
    }

    @Test
    public void testSetAndGetMaxGeneratedCodeLength() {
        configuration.setString("table.generated-code.max-length", "5000");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setMaxGeneratedCodeLength(Integer.valueOf(5000));
        Assert.assertEquals((Object)5000, (Object)configByMethod.getMaxGeneratedCodeLength());
        Assert.assertEquals((Object)5000, (Object)configByConfiguration.getMaxGeneratedCodeLength());
    }

    @Test
    public void testSetAndGetLocalTimeZone() {
        configuration.setString("table.local-time-zone", "Asia/Shanghai");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        Assert.assertEquals((Object)ZoneId.of("Asia/Shanghai"), (Object)configByMethod.getLocalTimeZone());
        Assert.assertEquals((Object)ZoneId.of("Asia/Shanghai"), (Object)configByConfiguration.getLocalTimeZone());
        configuration.setString("table.local-time-zone", "GMT-08:00");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setLocalTimeZone(ZoneId.of("GMT-08:00"));
        Assert.assertEquals((Object)ZoneId.of("GMT-08:00"), (Object)configByMethod.getLocalTimeZone());
        Assert.assertEquals((Object)ZoneId.of("GMT-08:00"), (Object)configByConfiguration.getLocalTimeZone());
    }

    @Test
    public void testSetInvalidLocalTimeZone() {
        this.expectedException.expectMessage("The supported Zone ID is either a full name such as 'America/Los_Angeles', or a custom timezone id such as 'GMT-08:00', but configured Zone ID is 'UTC-10:00'.");
        configByMethod.setLocalTimeZone(ZoneId.of("UTC-10:00"));
    }

    @Test
    public void testInvalidGmtLocalTimeZone() {
        this.expectedException.expectMessage("Invalid ID for offset-based ZoneId: GMT-8:00");
        configByMethod.setLocalTimeZone(ZoneId.of("GMT-8:00"));
    }

    @Test
    public void testGetInvalidLocalTimeZone() {
        configuration.setString("table.local-time-zone", "UTC+8");
        configByConfiguration.addConfiguration(configuration);
        this.expectedException.expectMessage("The supported Zone ID is either a full name such as 'America/Los_Angeles', or a custom timezone id such as 'GMT-08:00', but configured Zone ID is 'UTC+8'.");
        configByConfiguration.getLocalTimeZone();
    }

    @Test
    public void testGetInvalidAbbreviationLocalTimeZone() {
        configuration.setString("table.local-time-zone", "PST");
        configByConfiguration.addConfiguration(configuration);
        this.expectedException.expectMessage("The supported Zone ID is either a full name such as 'America/Los_Angeles', or a custom timezone id such as 'GMT-08:00', but configured Zone ID is 'PST'.");
        configByConfiguration.getLocalTimeZone();
    }

    @Test
    public void testSetAndGetIdleStateRetention() {
        configuration.setString("table.exec.state.ttl", "1 h");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setIdleStateRetention(Duration.ofHours(1L));
        Assert.assertEquals((Object)Duration.ofHours(1L), (Object)configByMethod.getIdleStateRetention());
        Assert.assertEquals((Object)Duration.ofHours(1L), (Object)configByConfiguration.getIdleStateRetention());
    }
}

