/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.junit.Assert;
import org.junit.Test;

public class EnvironmentSettingsTest {
    @Test
    public void testFromConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setString("execution.runtime-mode", "batch");
        configuration.setString("table.planner", "old");
        EnvironmentSettings settings = EnvironmentSettings.fromConfiguration((Configuration)configuration);
        Assert.assertFalse((String)"Expect old planner.", (boolean)settings.isBlinkPlanner());
        Assert.assertFalse((String)"Expect batch mode.", (boolean)settings.isStreamingMode());
    }

    @Test
    public void testToConfiguration() {
        EnvironmentSettings settings = new EnvironmentSettings.Builder().useOldPlanner().inBatchMode().build();
        Configuration configuration = settings.toConfiguration();
        Assert.assertEquals((Object)PlannerType.OLD, (Object)configuration.get(TableConfigOptions.TABLE_PLANNER));
        Assert.assertEquals((Object)RuntimeExecutionMode.BATCH, (Object)configuration.get(ExecutionOptions.RUNTIME_MODE));
    }
}

