/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class FieldInfoUtilsTest {

    public static final class TestByPositionMode {
        private static final RowTypeInfo rowTypeInfo = new RowTypeInfo(new TypeInformation[]{Types.INT, Types.LONG, Types.SQL_TIMESTAMP}, new String[]{"f0", "f1", "f2"});

        @Test
        public void testByPositionMode() {
            FieldInfoUtils.TypeInfoSchema schema = FieldInfoUtils.getFieldsInfo((TypeInformation)rowTypeInfo, (Expression[])new Expression[]{Expressions.$((String)"aa"), Expressions.$((String)"bb"), Expressions.$((String)"cc")});
            Assert.assertArrayEquals((Object[])new String[]{"aa", "bb", "cc"}, (Object[])schema.getFieldNames());
        }

        @Test
        public void testByPositionModeProcTime() {
            FieldInfoUtils.TypeInfoSchema schema = FieldInfoUtils.getFieldsInfo((TypeInformation)rowTypeInfo, (Expression[])new Expression[]{Expressions.$((String)"aa"), Expressions.$((String)"bb"), Expressions.$((String)"cc"), (Expression)((ApiExpression)Expressions.$((String)"cc").proctime()).as("proctime", new String[0])});
            Assert.assertArrayEquals((Object[])new String[]{"aa", "bb", "cc", "proctime"}, (Object[])schema.getFieldNames());
        }
    }

    @RunWith(value=Parameterized.class)
    public static final class TestByNameMode {
        @Parameterized.Parameter
        public TypeInformation typeInfo;

        @Parameterized.Parameters(name="{0}")
        public static Collection<TypeInformation> parameters() throws Exception {
            return Arrays.asList(new RowTypeInfo(new TypeInformation[]{Types.INT, Types.LONG, Types.SQL_TIMESTAMP}, new String[]{"f0", "f1", "f2"}), new PojoTypeInfo(MyPojo.class, Arrays.asList(new PojoField(MyPojo.class.getDeclaredField("f0"), Types.INT), new PojoField(MyPojo.class.getDeclaredField("f1"), Types.LONG), new PojoField(MyPojo.class.getDeclaredField("f2"), Types.SQL_TIMESTAMP))));
        }

        @Test
        public void testByNameModeReorder() {
            FieldInfoUtils.TypeInfoSchema schema = FieldInfoUtils.getFieldsInfo((TypeInformation)this.typeInfo, (Expression[])new Expression[]{Expressions.$((String)"f2"), Expressions.$((String)"f1"), Expressions.$((String)"f0")});
            Assert.assertArrayEquals((Object[])new String[]{"f2", "f1", "f0"}, (Object[])schema.getFieldNames());
        }

        @Test
        public void testByNameModeReorderAndRename() {
            FieldInfoUtils.TypeInfoSchema schema = FieldInfoUtils.getFieldsInfo((TypeInformation)this.typeInfo, (Expression[])new Expression[]{(Expression)Expressions.$((String)"f1").as("aa", new String[0]), (Expression)Expressions.$((String)"f0").as("bb", new String[0]), (Expression)Expressions.$((String)"f2").as("cc", new String[0])});
            Assert.assertArrayEquals((Object[])new String[]{"aa", "bb", "cc"}, (Object[])schema.getFieldNames());
        }

        public static class MyPojo {
            public int f0;
            public long f1;
            public Timestamp f2;
        }
    }
}

