/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.operations.CatalogQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.table.utils.FunctionLookupMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExpressionResolverTest {
    @Parameterized.Parameter
    public TestSpec testSpec;

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestSpec> parameters() {
        return Arrays.asList(TestSpec.test("Columns range").inputSchemas(TableSchema.builder().field("f0", DataTypes.BIGINT()).field("f1", DataTypes.STRING()).field("f2", DataTypes.SMALLINT()).build()).select(new Expression[]{Expressions.withColumns((Object)Expressions.range((String)"f1", (String)"f2"), (Object[])new Object[0]), Expressions.withColumns((Object)Expressions.range((int)1, (int)2), (Object[])new Object[0])}).equalTo(new ResolvedExpression[]{new FieldReferenceExpression("f1", DataTypes.STRING(), 0, 1), new FieldReferenceExpression("f2", DataTypes.SMALLINT(), 0, 2), new FieldReferenceExpression("f0", DataTypes.BIGINT(), 0, 0), new FieldReferenceExpression("f1", DataTypes.STRING(), 0, 1)}), TestSpec.test("Flatten call").inputSchemas(TableSchema.builder().field("f0", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"n0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"n1", (DataType)DataTypes.STRING())})).build()).select((Expression)Expressions.$((String)"f0").flatten()).equalTo(new ResolvedExpression[]{new CallExpression(FunctionIdentifier.of((String)"get"), (FunctionDefinition)BuiltInFunctionDefinitions.GET, Arrays.asList(new FieldReferenceExpression("f0", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"n0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"n1", (DataType)DataTypes.STRING())}), 0, 0), new ValueLiteralExpression((Object)"n0")), DataTypes.BIGINT()), new CallExpression(FunctionIdentifier.of((String)"get"), (FunctionDefinition)BuiltInFunctionDefinitions.GET, Arrays.asList(new FieldReferenceExpression("f0", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"n0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"n1", (DataType)DataTypes.STRING())}), 0, 0), new ValueLiteralExpression((Object)"n1")), DataTypes.STRING())}), TestSpec.test("Builtin function calls").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.DOUBLE()).build()).select((Expression)Expressions.$((String)"f0").isEqual((Object)Expressions.$((String)"f1"))).equalTo(new ResolvedExpression[]{new CallExpression(FunctionIdentifier.of((String)"equals"), (FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0), new FieldReferenceExpression("f1", DataTypes.DOUBLE(), 0, 1)), DataTypes.BOOLEAN())}), TestSpec.test("Lookup legacy scalar function call").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).lookupFunction("func", (FunctionDefinition)new ScalarFunctionDefinition("func", (ScalarFunction)new LegacyScalarFunc())).select(new Expression[]{Expressions.call((String)"func", (Object[])new Object[]{1, Expressions.$((String)"f0")})}).equalTo(new ResolvedExpression[]{new CallExpression(FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunctionDefinition("func", (ScalarFunction)new LegacyScalarFunc()), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)DataTypes.INT().bridgedTo(Integer.class))}), TestSpec.test("Lookup system function call").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).lookupFunction("func", (FunctionDefinition)new ScalarFunc()).select(new Expression[]{Expressions.call((String)"func", (Object[])new Object[]{1, Expressions.$((String)"f0")})}).equalTo(new ResolvedExpression[]{new CallExpression(FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunc(), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))}), TestSpec.test("Inline function call via a class").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).select(new Expression[]{Expressions.call(ScalarFunc.class, (Object[])new Object[]{1, Expressions.$((String)"f0")})}).equalTo(new ResolvedExpression[]{new CallExpression((FunctionDefinition)new ScalarFunc(), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))}), TestSpec.test("Lookup catalog function call").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).lookupFunction(ObjectIdentifier.of((String)"cat", (String)"db", (String)"func"), (FunctionDefinition)new ScalarFunc()).select(new Expression[]{Expressions.call((String)"cat.db.func", (Object[])new Object[]{1, Expressions.$((String)"f0")})}).equalTo(new ResolvedExpression[]{new CallExpression(FunctionIdentifier.of((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"func")), (FunctionDefinition)new ScalarFunc(), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))}), TestSpec.test("Deeply nested user-defined inline calls").inputSchemas(TableSchema.builder().field("f0", DataTypes.INT()).build()).lookupFunction("func", (FunctionDefinition)new ScalarFunc()).select(new Expression[]{Expressions.call((String)"func", (Object[])new Object[]{Expressions.call((UserDefinedFunction)new ScalarFunc(), (Object[])new Object[]{Expressions.call((String)"func", (Object[])new Object[]{1, Expressions.$((String)"f0")})})})}).equalTo(new ResolvedExpression[]{new CallExpression(FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunc(), Collections.singletonList(new CallExpression((FunctionDefinition)new ScalarFunc(), Collections.singletonList(new CallExpression(FunctionIdentifier.of((String)"func"), (FunctionDefinition)new ScalarFunc(), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), new FieldReferenceExpression("f0", DataTypes.INT(), 0, 0)), (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))}));
    }

    @Test
    public void testResolvingExpressions() {
        List resolvedExpressions = this.testSpec.getResolver().resolve(Arrays.asList(this.testSpec.expressions));
        Assert.assertThat((Object)resolvedExpressions, (Matcher)CoreMatchers.equalTo((Object)this.testSpec.expectedExpressions));
    }

    private static class TestSpec {
        private final String description;
        private TableSchema[] schemas;
        private Expression[] expressions;
        private List<ResolvedExpression> expectedExpressions;
        private Map<FunctionIdentifier, FunctionDefinition> functions = new HashMap<FunctionIdentifier, FunctionDefinition>();

        private TestSpec(String description) {
            this.description = description;
        }

        public static TestSpec test(String description) {
            return new TestSpec(description);
        }

        public TestSpec inputSchemas(TableSchema ... schemas) {
            this.schemas = schemas;
            return this;
        }

        public TestSpec lookupFunction(String name, FunctionDefinition functionDefinition) {
            this.functions.put(FunctionIdentifier.of((String)name), functionDefinition);
            return this;
        }

        public TestSpec lookupFunction(ObjectIdentifier identifier, FunctionDefinition functionDefinition) {
            this.functions.put(FunctionIdentifier.of((ObjectIdentifier)identifier), functionDefinition);
            return this;
        }

        public TestSpec select(Expression ... expressions) {
            this.expressions = expressions;
            return this;
        }

        public TestSpec equalTo(ResolvedExpression ... resolvedExpressions) {
            this.expectedExpressions = Arrays.asList(resolvedExpressions);
            return this;
        }

        public ExpressionResolver getResolver() {
            return ExpressionResolver.resolverFor((TableConfig)new TableConfig(), name -> Optional.empty(), (FunctionLookup)new FunctionLookupMock(this.functions), (DataTypeFactory)new DataTypeFactoryMock(), (QueryOperation[])((QueryOperation[])Arrays.stream(this.schemas).map(schema -> new CatalogQueryOperation(ObjectIdentifier.of((String)"", (String)"", (String)""), schema)).toArray(QueryOperation[]::new))).build();
        }

        public String toString() {
            return this.description;
        }
    }

    public static class LegacyScalarFunc
    extends ScalarFunction {
        public int eval(Object ... any) {
            return 0;
        }

        public TypeInformation<?> getResultType(Class<?>[] signature) {
            return Types.INT;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof ScalarFunc;
        }
    }

    @FunctionHint(input={@DataTypeHint(inputGroup=InputGroup.ANY)}, isVarArgs=true, output=@DataTypeHint(value="INTEGER NOT NULL", bridgedTo=int.class))
    public static class ScalarFunc
    extends ScalarFunction {
        public int eval(Object ... any) {
            return 0;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof ScalarFunc;
        }
    }
}

