/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.descriptors.GenericInMemoryCatalogDescriptor;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class GenericInMemoryCatalogFactoryTest
extends TestLogger {
    @Test
    public void test() throws Exception {
        String catalogName = "mycatalog";
        String databaseName = "mydatabase";
        GenericInMemoryCatalog expectedCatalog = new GenericInMemoryCatalog("mycatalog", "mydatabase");
        GenericInMemoryCatalogDescriptor catalogDescriptor = new GenericInMemoryCatalogDescriptor("mydatabase");
        Map properties = catalogDescriptor.toProperties();
        Catalog actualCatalog = ((CatalogFactory)TableFactoryService.find(CatalogFactory.class, (Map)properties)).createCatalog("mycatalog", properties);
        GenericInMemoryCatalogFactoryTest.checkEquals(expectedCatalog, (GenericInMemoryCatalog)actualCatalog);
    }

    private static void checkEquals(GenericInMemoryCatalog c1, GenericInMemoryCatalog c2) throws Exception {
        Assert.assertEquals((Object)c1.getName(), (Object)c2.getName());
        Assert.assertEquals((Object)c1.getDefaultDatabase(), (Object)c2.getDefaultDatabase());
        Assert.assertEquals((Object)c1.listDatabases(), (Object)c2.listDatabases());
        String database = c1.getDefaultDatabase();
        Assert.assertEquals((Object)c1.listTables(database), (Object)c2.listTables(database));
        Assert.assertEquals((Object)c1.listViews(database), (Object)c2.listViews(database));
        Assert.assertEquals((Object)c1.listFunctions(database), (Object)c2.listFunctions(database));
    }
}

