/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.descriptors.ConnectTableDescriptor;
import org.apache.flink.table.descriptors.FormatDescriptor;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.table.utils.ConnectorDescriptorMock;
import org.apache.flink.table.utils.FormatDescriptorMock;
import org.apache.flink.table.utils.TableEnvironmentMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TableEnvironmentTest {
    @Test
    public void testConnect() {
        TableEnvironmentMock tableEnv = TableEnvironmentMock.getStreamingInstance();
        ((ConnectTableDescriptor)((ConnectTableDescriptor)tableEnv.connect(new ConnectorDescriptorMock("table-source-factory-mock", 1, true)).withFormat((FormatDescriptor)new FormatDescriptorMock("my_format", 1))).withSchema(new Schema().field("my_field_0", "INT").field("my_field_1", "BOOLEAN").field("my_part_1", "BIGINT").field("my_part_2", "STRING")).withPartitionKeys(Arrays.asList("my_part_1", "my_part_2")).inAppendMode()).createTemporaryTable("my_table");
        CatalogManager.TableLookupResult lookupResult = (CatalogManager.TableLookupResult)tableEnv.catalogManager.getTable(ObjectIdentifier.of((String)"default_catalog", (String)"default_database", (String)"my_table")).orElseThrow(AssertionError::new);
        Assert.assertThat((Object)lookupResult.isTemporary(), (Matcher)CoreMatchers.equalTo((Object)true));
        CatalogBaseTable catalogBaseTable = lookupResult.getTable();
        Assert.assertTrue((boolean)(catalogBaseTable instanceof CatalogTable));
        CatalogTable table = (CatalogTable)catalogBaseTable;
        TableEnvironmentTest.assertCatalogTable(table);
        TableEnvironmentTest.assertCatalogTable((CatalogTable)CatalogTableImpl.fromProperties((Map)table.toProperties()));
    }

    private static void assertCatalogTable(CatalogTable table) {
        Assert.assertThat((Object)table.getSchema(), (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("my_field_0", DataTypes.INT()).field("my_field_1", DataTypes.BOOLEAN()).field("my_part_1", DataTypes.BIGINT()).field("my_part_2", DataTypes.STRING()).build()));
        Assert.assertThat((Object)table.getPartitionKeys(), (Matcher)CoreMatchers.equalTo(Arrays.asList("my_part_1", "my_part_2")));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("update-mode", "append");
        properties.put("connector.property-version", "1");
        properties.put("format.type", "my_format");
        properties.put("format.property-version", "1");
        properties.put("connector.type", "table-source-factory-mock");
        Assert.assertThat((Object)table.getProperties(), (Matcher)CoreMatchers.equalTo(properties));
    }
}

