/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.time.Duration;
import java.time.ZoneId;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.junit.Assert;
import org.junit.Test;

public class TableConfigTest {
    private static TableConfig configByMethod = new TableConfig();
    private static TableConfig configByConfiguration = new TableConfig();
    private static Configuration configuration = new Configuration();

    @Test
    public void testSetAndGetSqlDialect() {
        configuration.setString("table.sql-dialect", "HIVE");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setSqlDialect(SqlDialect.HIVE);
        Assert.assertEquals((Object)SqlDialect.HIVE, (Object)configByMethod.getSqlDialect());
        Assert.assertEquals((Object)SqlDialect.HIVE, (Object)configByConfiguration.getSqlDialect());
    }

    @Test
    public void testSetAndGetMaxGeneratedCodeLength() {
        configuration.setString("table.generated-code.max-length", "5000");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setMaxGeneratedCodeLength(Integer.valueOf(5000));
        Assert.assertEquals((Object)5000, (Object)configByMethod.getMaxGeneratedCodeLength());
        Assert.assertEquals((Object)5000, (Object)configByConfiguration.getMaxGeneratedCodeLength());
    }

    @Test
    public void testSetAndGetLocalTimeZone() {
        configuration.setString("table.local-time-zone", "Asia/Shanghai");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setLocalTimeZone(ZoneId.of("Asia/Shanghai"));
        Assert.assertEquals((Object)ZoneId.of("Asia/Shanghai"), (Object)configByMethod.getLocalTimeZone());
        Assert.assertEquals((Object)ZoneId.of("Asia/Shanghai"), (Object)configByConfiguration.getLocalTimeZone());
    }

    @Test
    public void testSetAndGetIdleStateRetention() {
        configuration.setString("table.exec.state.ttl", "1 h");
        configByConfiguration.addConfiguration(configuration);
        configByMethod.setIdleStateRetention(Duration.ofHours(1L));
        Assert.assertEquals((Object)Duration.ofHours(1L), (Object)configByMethod.getIdleStateRetention());
        Assert.assertEquals((Object)Duration.ofHours(1L), (Object)configByConfiguration.getIdleStateRetention());
    }
}

