/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.math.MathContext;
import java.time.Duration;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.table.api.PlannerConfig;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TableConfig {
    private Boolean nullCheck = true;
    private PlannerConfig plannerConfig = PlannerConfig.EMPTY_CONFIG;
    private MathContext decimalContext = MathContext.DECIMAL128;
    private Configuration configuration = new Configuration();

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addConfiguration(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configuration.addAll(configuration);
    }

    public SqlDialect getSqlDialect() {
        return SqlDialect.valueOf(this.getConfiguration().getString(TableConfigOptions.TABLE_SQL_DIALECT).toUpperCase());
    }

    public void setSqlDialect(SqlDialect sqlDialect) {
        this.getConfiguration().setString(TableConfigOptions.TABLE_SQL_DIALECT, sqlDialect.name().toLowerCase());
    }

    public ZoneId getLocalTimeZone() {
        String zone = this.configuration.getString(TableConfigOptions.LOCAL_TIME_ZONE);
        return "default".equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
    }

    public void setLocalTimeZone(ZoneId zoneId) {
        this.configuration.setString(TableConfigOptions.LOCAL_TIME_ZONE, zoneId.toString());
    }

    public Boolean getNullCheck() {
        return this.nullCheck;
    }

    public void setNullCheck(Boolean nullCheck) {
        this.nullCheck = (Boolean)Preconditions.checkNotNull((Object)nullCheck);
    }

    public PlannerConfig getPlannerConfig() {
        return this.plannerConfig;
    }

    public void setPlannerConfig(PlannerConfig plannerConfig) {
        this.plannerConfig = (PlannerConfig)Preconditions.checkNotNull((Object)plannerConfig);
    }

    public MathContext getDecimalContext() {
        return this.decimalContext;
    }

    public void setDecimalContext(MathContext decimalContext) {
        this.decimalContext = (MathContext)Preconditions.checkNotNull((Object)decimalContext);
    }

    public Integer getMaxGeneratedCodeLength() {
        return this.configuration.getInteger(TableConfigOptions.MAX_LENGTH_GENERATED_CODE);
    }

    public void setMaxGeneratedCodeLength(Integer maxGeneratedCodeLength) {
        this.configuration.setInteger(TableConfigOptions.MAX_LENGTH_GENERATED_CODE, maxGeneratedCodeLength.intValue());
    }

    @Deprecated
    public void setIdleStateRetentionTime(Time minTime, Time maxTime) {
        if (maxTime.toMilliseconds() - minTime.toMilliseconds() < 300000L && (maxTime.toMilliseconds() != 0L || minTime.toMilliseconds() != 0L)) {
            throw new IllegalArgumentException("Difference between minTime: " + minTime.toString() + " and maxTime: " + maxTime.toString() + " should be at least 5 minutes.");
        }
        this.setIdleStateRetention(Duration.ofMillis(minTime.toMilliseconds()));
    }

    public void setIdleStateRetention(Duration duration) {
        this.configuration.set(ExecutionConfigOptions.IDLE_STATE_RETENTION, (Object)duration);
    }

    @Deprecated
    public long getMinIdleStateRetentionTime() {
        return ((Duration)this.configuration.get(ExecutionConfigOptions.IDLE_STATE_RETENTION)).toMillis();
    }

    @Deprecated
    public long getMaxIdleStateRetentionTime() {
        return this.getMinIdleStateRetentionTime() * 3L / 2L;
    }

    public Duration getIdleStateRetention() {
        return (Duration)this.configuration.get(ExecutionConfigOptions.IDLE_STATE_RETENTION);
    }

    @Experimental
    public void addJobParameter(String key, String value) {
        Map params = this.getConfiguration().getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).map(HashMap::new).orElseGet(HashMap::new);
        params.put(key, value);
        this.getConfiguration().set(PipelineOptions.GLOBAL_JOB_PARAMETERS, (Object)params);
    }

    public static TableConfig getDefault() {
        return new TableConfig();
    }
}

