/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class ValuesQueryOperation
implements QueryOperation {
    private final List<List<ResolvedExpression>> values;
    private final TableSchema tableSchema;

    public ValuesQueryOperation(List<List<ResolvedExpression>> values, TableSchema tableSchema) {
        this.values = values;
        this.tableSchema = tableSchema;
    }

    public List<List<ResolvedExpression>> getValues() {
        return this.values;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("values", this.values);
        return OperationUtils.formatWithChildren("Values", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValuesQueryOperation that = (ValuesQueryOperation)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.tableSchema, that.tableSchema);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.tableSchema);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

