/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.operations.ValuesQueryOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.table.utils.FunctionLookupMock;
import org.apache.flink.types.Row;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ValuesOperationTreeBuilderTest {
    @Parameterized.Parameter
    public TestSpec testSpec;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestSpec> parameters() {
        return Arrays.asList(TestSpec.test("Flattening row constructor").values(new Expression[]{Expressions.row((Object)1, (Object[])new Object[]{"ABC"}), Expressions.row((Object)2, (Object[])new Object[]{"EFG"})}).equalTo(new ValuesQueryOperation(Arrays.asList(Arrays.asList(ApiExpressionUtils.valueLiteral((Object)1), ApiExpressionUtils.valueLiteral((Object)"ABC")), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)2), ApiExpressionUtils.valueLiteral((Object)"EFG"))), TableSchema.builder().field("f0", (DataType)DataTypes.INT().notNull()).field("f1", (DataType)DataTypes.CHAR((int)3).notNull()).build())), TestSpec.test("Finding common type").values(new Expression[]{Expressions.row((Object)1L, (Object[])new Object[]{"ABC"}), Expressions.row((Object)Float.valueOf(3.1f), (Object[])new Object[]{"DEFG"})}).equalTo(new ValuesQueryOperation(Arrays.asList(Arrays.asList(ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)1L), (DataType)DataTypes.FLOAT().notNull()), ApiExpressionUtils.valueLiteral((Object)"ABC", (DataType)((DataType)DataTypes.VARCHAR((int)4).notNull()))), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)Float.valueOf(3.1f)), ApiExpressionUtils.valueLiteral((Object)"DEFG", (DataType)((DataType)DataTypes.VARCHAR((int)4).notNull())))), TableSchema.builder().field("f0", (DataType)DataTypes.FLOAT().notNull()).field("f1", (DataType)DataTypes.VARCHAR((int)4).notNull()).build())), TestSpec.test("Explicit common type").values(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())}), new Expression[]{Expressions.row((Object)1L, (Object[])new Object[]{"ABC"}), Expressions.row((Object)Float.valueOf(3.1f), (Object[])new Object[]{"DEFG"})}).equalTo(new ValuesQueryOperation(Arrays.asList(Arrays.asList(ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)1L), DataTypes.DECIMAL((int)10, (int)2)), ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)"ABC", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.STRING())), Arrays.asList(ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)Float.valueOf(3.1f)), DataTypes.DECIMAL((int)10, (int)2)), ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)"DEFG", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.STRING()))), TableSchema.builder().field("id", DataTypes.DECIMAL((int)10, (int)2)).field("name", DataTypes.STRING()).build())), TestSpec.test("Explicit common type for nested rows").values(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"id", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"details", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"amount", (DataType)DataTypes.DECIMAL((int)10, (int)2))}))}), new Expression[]{Expressions.row((Object)1L, (Object[])new Object[]{Expressions.row((Object)"ABC", (Object[])new Object[]{3})}), Expressions.row((Object)Float.valueOf(3.1f), (Object[])new Object[]{Expressions.row((Object)"DEFG", (Object[])new Object[]{new BigDecimal("12345")})})}).equalTo(new ValuesQueryOperation(Arrays.asList(Arrays.asList(ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)1L), DataTypes.DECIMAL((int)10, (int)2)), ValuesOperationTreeBuilderTest.rowCtor(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"amount", (DataType)DataTypes.DECIMAL((int)10, (int)2))}), ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)"ABC", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.STRING()), ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)3), DataTypes.DECIMAL((int)10, (int)2)))), Arrays.asList(ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)Float.valueOf(3.1f)), DataTypes.DECIMAL((int)10, (int)2)), ValuesOperationTreeBuilderTest.rowCtor(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"amount", (DataType)DataTypes.DECIMAL((int)10, (int)2))}), ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)"DEFG", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.STRING()), ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)new BigDecimal("12345"), (DataType)((DataType)DataTypes.DECIMAL((int)10, (int)2).notNull())), DataTypes.DECIMAL((int)10, (int)2))))), TableSchema.builder().field("id", DataTypes.DECIMAL((int)10, (int)2)).field("details", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"amount", (DataType)DataTypes.DECIMAL((int)10, (int)2))})).build())), TestSpec.test("Finding a common type for nested rows").values(new Expression[]{Expressions.row((Object)1L, (Object[])new Object[]{Expressions.row((Object)1L, (Object[])new Object[]{"ABC"})}), Expressions.row((Object)Float.valueOf(3.1f), (Object[])new Object[]{Expressions.row((Object)Float.valueOf(3.1f), (Object[])new Object[]{"DEFG"})})}).equalTo(new ValuesQueryOperation(Arrays.asList(Arrays.asList(ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)1L), (DataType)DataTypes.FLOAT().notNull()), ValuesOperationTreeBuilderTest.rowCtor((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.FLOAT().notNull())), DataTypes.FIELD((String)"f1", (DataType)((DataType)DataTypes.VARCHAR((int)4).notNull()))}).notNull(), new ResolvedExpression[]{ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)1L), (DataType)DataTypes.FLOAT().notNull()), ApiExpressionUtils.valueLiteral((Object)"ABC", (DataType)((DataType)DataTypes.VARCHAR((int)4).notNull()))})), Arrays.asList(ApiExpressionUtils.valueLiteral((Object)Float.valueOf(3.1f)), ValuesOperationTreeBuilderTest.rowCtor((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.FLOAT().notNull())), DataTypes.FIELD((String)"f1", (DataType)((DataType)DataTypes.VARCHAR((int)4).notNull()))}).notNull(), new ResolvedExpression[]{ApiExpressionUtils.valueLiteral((Object)Float.valueOf(3.1f), (DataType)((DataType)DataTypes.FLOAT().notNull())), ApiExpressionUtils.valueLiteral((Object)"DEFG", (DataType)((DataType)DataTypes.VARCHAR((int)4).notNull()))}))), TableSchema.builder().field("f0", (DataType)DataTypes.FLOAT().notNull()).field("f1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.FLOAT().notNull())), DataTypes.FIELD((String)"f1", (DataType)((DataType)DataTypes.VARCHAR((int)4).notNull()))}).notNull()).build())), TestSpec.test("Finding common type. Insert cast for calls").values(new Expression[]{Expressions.call((UserDefinedFunction)new IntScalarFunction(), (Object[])new Object[0]), Expressions.row((Object)Float.valueOf(3.1f), (Object[])new Object[0])}).equalTo(new ValuesQueryOperation(Arrays.asList(Collections.singletonList(ValuesOperationTreeBuilderTest.cast((ResolvedExpression)new CallExpression((FunctionDefinition)new IntScalarFunction(), Collections.emptyList(), DataTypes.INT()), DataTypes.FLOAT())), Collections.singletonList(ValuesOperationTreeBuilderTest.cast((ResolvedExpression)ApiExpressionUtils.valueLiteral((Object)Float.valueOf(3.1f)), DataTypes.FLOAT()))), TableSchema.builder().field("f0", DataTypes.FLOAT()).build())), TestSpec.test("Row in a function result is not flattened").values(new Expression[]{Expressions.call((UserDefinedFunction)new RowScalarFunction(), (Object[])new Object[0])}).equalTo(new ValuesQueryOperation(Collections.singletonList(Collections.singletonList(new CallExpression((FunctionDefinition)new RowScalarFunction(), Collections.emptyList(), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())})))), TableSchema.builder().field("f0", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())})).build())), TestSpec.test("Cannot find a common super type").values(new Expression[]{ApiExpressionUtils.valueLiteral((Object)LocalTime.of(1, 1)), ApiExpressionUtils.valueLiteral((Object)LocalDate.of(1, 1, 1))}).expectValidationException("Types in fromValues(...) must have a common super type. Could not find a common type for all rows at column 0.\nCould not find a common super type for types: [TIME(0) NOT NULL, DATE NOT NULL]"), TestSpec.test("Cannot find a common super type in a nested row").values(new Expression[]{Expressions.row((Object)1, (Object[])new Object[]{Expressions.row((Object)3, (Object[])new Object[]{ApiExpressionUtils.valueLiteral((Object)LocalTime.of(1, 1))})}), Expressions.row((Object)1, (Object[])new Object[]{Expressions.row((Object)4, (Object[])new Object[]{ApiExpressionUtils.valueLiteral((Object)LocalTime.of(2, 1))})}), Expressions.row((Object)2.0, (Object[])new Object[]{Expressions.row((Object)2.0, (Object[])new Object[]{ApiExpressionUtils.valueLiteral((Object)LocalDate.of(1, 1, 1))})})}).expectValidationException("Types in fromValues(...) must have a common super type. Could not find a common type for all rows at column 1.\nCould not find a common super type for types: [ROW<`f0` INT NOT NULL, `f1` TIME(0) NOT NULL> NOT NULL, ROW<`f0` DOUBLE NOT NULL, `f1` DATE NOT NULL> NOT NULL]"), TestSpec.test("Cannot cast to the requested type").values(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BINARY((int)3))}), new Expression[]{Expressions.row((Object)ApiExpressionUtils.valueLiteral((Object)1), (Object[])new Object[]{ApiExpressionUtils.valueLiteral((Object)LocalTime.of(1, 1))}), Expressions.row((Object)ApiExpressionUtils.valueLiteral((Object)2), (Object[])new Object[]{ApiExpressionUtils.valueLiteral((Object)LocalDate.of(1, 1, 1))})}).expectValidationException("Could not cast the value of the 1 column: [ 01:01 ] of a row: [ 1, 01:01 ] to the requested type: BINARY(3)"), TestSpec.test("Cannot cast to the requested type in a nested row").values(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"c", (DataType)DataTypes.BINARY((int)3))}))}), new Expression[]{Expressions.row((Object)ApiExpressionUtils.valueLiteral((Object)1), (Object[])new Object[]{Expressions.row((Object)ApiExpressionUtils.valueLiteral((Object)LocalTime.of(1, 1)), (Object[])new Object[0])}), Expressions.row((Object)ApiExpressionUtils.valueLiteral((Object)2), (Object[])new Object[]{Expressions.row((Object)ApiExpressionUtils.valueLiteral((Object)LocalDate.of(1, 1, 1)), (Object[])new Object[0])})}).expectValidationException("Could not cast the value of the 1 column: [ row(01:01) ] of a row: [ 1, row(01:01) ] to the requested type: ROW<`c` BINARY(3)>"));
    }

    @Test
    public void testValues() {
        if (this.testSpec.exceptionMessage != null) {
            this.thrown.expect(ValidationException.class);
            this.thrown.expectMessage(this.testSpec.exceptionMessage);
        }
        ValuesQueryOperation operation = this.testSpec.expectedRowType != null ? (ValuesQueryOperation)this.testSpec.getTreeBuilder().values(this.testSpec.expectedRowType, this.testSpec.expressions) : (ValuesQueryOperation)this.testSpec.getTreeBuilder().values(this.testSpec.expressions);
        if (this.testSpec.queryOperation != null) {
            Assert.assertThat((Object)operation.getTableSchema(), (Matcher)CoreMatchers.equalTo((Object)this.testSpec.queryOperation.getTableSchema()));
            Assert.assertThat((Object)operation.getValues(), (Matcher)CoreMatchers.equalTo((Object)this.testSpec.queryOperation.getValues()));
        }
    }

    private static ResolvedExpression rowCtor(DataType dataType, ResolvedExpression ... expression) {
        return new CallExpression(FunctionIdentifier.of((String)"row"), (FunctionDefinition)BuiltInFunctionDefinitions.ROW, Arrays.asList(expression), dataType);
    }

    private static ResolvedExpression cast(ResolvedExpression expression, DataType dataType) {
        return new CallExpression(FunctionIdentifier.of((String)"cast"), (FunctionDefinition)BuiltInFunctionDefinitions.CAST, Arrays.asList(expression, ApiExpressionUtils.typeLiteral((DataType)dataType)), dataType);
    }

    private static class TestSpec {
        private final String description;
        private Expression[] expressions;
        @Nullable
        private ValuesQueryOperation queryOperation;
        @Nullable
        private DataType expectedRowType;
        @Nullable
        private String exceptionMessage;

        private TestSpec(String description) {
            this.description = description;
        }

        public static TestSpec test(String description) {
            return new TestSpec(description);
        }

        public TestSpec values(Expression ... expressions) {
            this.expressions = expressions;
            return this;
        }

        public TestSpec values(DataType rowType, Expression ... expressions) {
            this.expressions = expressions;
            this.expectedRowType = rowType;
            return this;
        }

        public TestSpec equalTo(ValuesQueryOperation queryOperation) {
            this.queryOperation = queryOperation;
            return this;
        }

        public TestSpec expectValidationException(String message) {
            this.exceptionMessage = message;
            return this;
        }

        public OperationTreeBuilder getTreeBuilder() {
            return OperationTreeBuilder.create((TableConfig)new TableConfig(), (FunctionLookup)new FunctionLookupMock(Collections.emptyMap()), (DataTypeFactory)new DataTypeFactoryMock(), name -> Optional.empty(), (boolean)true);
        }

        public String toString() {
            return this.description;
        }
    }

    public static class IntScalarFunction
    extends ScalarFunction {
        public Integer eval() {
            return 1;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntScalarFunction;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="ROW<f0 INT, f1 STRING>"))
    public static class RowScalarFunction
    extends ScalarFunction {
        public Row eval() {
            return Row.of((Object[])new Object[]{1, "ABC"});
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof RowScalarFunction;
        }
    }
}

