/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinitionUtil;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.junit.Assert;
import org.junit.Test;

public class FunctionDefinitionUtilTest {
    @Test
    public void testScalarFunction() {
        FunctionDefinition fd = FunctionDefinitionUtil.createFunctionDefinition((String)"test", (String)TestScalarFunction.class.getName());
        Assert.assertTrue((boolean)(fd instanceof TestScalarFunction));
    }

    @Test
    public void testTableFunction() {
        FunctionDefinition fd1 = FunctionDefinitionUtil.createFunctionDefinition((String)"test", (String)TestTableFunction.class.getName());
        Assert.assertTrue((boolean)(fd1 instanceof TestTableFunction));
        FunctionDefinition fd2 = FunctionDefinitionUtil.createFunctionDefinition((String)"test", (String)TestTableFunctionWithoutResultType.class.getName());
        Assert.assertTrue((boolean)(fd2 instanceof TestTableFunctionWithoutResultType));
    }

    @Test
    public void testAggregateFunction() {
        FunctionDefinition fd1 = FunctionDefinitionUtil.createFunctionDefinition((String)"test", (String)TestAggFunction.class.getName());
        Assert.assertTrue((boolean)(((AggregateFunctionDefinition)fd1).getAggregateFunction() instanceof TestAggFunction));
        FunctionDefinition fd2 = FunctionDefinitionUtil.createFunctionDefinition((String)"test", (String)TestAggFunctionWithoutResultType.class.getName());
        Assert.assertTrue((boolean)(((AggregateFunctionDefinition)fd2).getAggregateFunction() instanceof TestAggFunctionWithoutResultType));
        Assert.assertEquals((Object)((AggregateFunctionDefinition)fd2).getResultTypeInfo(), (Object)Types.LONG);
        Assert.assertEquals((Object)((AggregateFunctionDefinition)fd2).getAccumulatorTypeInfo(), (Object)Types.STRING);
    }

    @Test
    public void testTableAggregateFunction() {
        FunctionDefinition fd1 = FunctionDefinitionUtil.createFunctionDefinition((String)"test", (String)TestTableAggFunction.class.getName());
        Assert.assertTrue((boolean)(((TableAggregateFunctionDefinition)fd1).getTableAggregateFunction() instanceof TestTableAggFunction));
        FunctionDefinition fd2 = FunctionDefinitionUtil.createFunctionDefinition((String)"test", (String)TestTableAggFunctionWithoutResultType.class.getName());
        Assert.assertTrue((boolean)(((TableAggregateFunctionDefinition)fd2).getTableAggregateFunction() instanceof TestTableAggFunctionWithoutResultType));
        Assert.assertEquals((Object)((TableAggregateFunctionDefinition)fd2).getResultTypeInfo(), (Object)Types.LONG);
        Assert.assertEquals((Object)((TableAggregateFunctionDefinition)fd2).getAccumulatorTypeInfo(), (Object)Types.STRING);
    }

    public static class TestTableAggFunctionWithoutResultType
    extends TableAggregateFunction<Long, String> {
        public String createAccumulator() {
            return null;
        }
    }

    public static class TestTableAggFunction
    extends TableAggregateFunction {
        public Object createAccumulator() {
            return null;
        }

        public TypeInformation getResultType() {
            return TypeInformation.of(Object.class);
        }

        public TypeInformation getAccumulatorType() {
            return TypeInformation.of(Object.class);
        }
    }

    public static class TestAggFunctionWithoutResultType
    extends AggregateFunction<Long, String> {
        public String createAccumulator() {
            return null;
        }

        public Long getValue(String accumulator) {
            return null;
        }
    }

    public static class TestAggFunction
    extends AggregateFunction {
        public Object createAccumulator() {
            return null;
        }

        public TypeInformation getResultType() {
            return TypeInformation.of(Object.class);
        }

        public TypeInformation getAccumulatorType() {
            return TypeInformation.of(Object.class);
        }

        public Object getValue(Object accumulator) {
            return null;
        }
    }

    public static class TestTableFunctionWithoutResultType
    extends TableFunction<String> {
    }

    public static class TestTableFunction
    extends TableFunction {
        public TypeInformation getResultType() {
            return TypeInformation.of(Object.class);
        }
    }

    public static class TestScalarFunction
    extends ScalarFunction {
    }
}

