/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashMap;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.factories.utils.TestPlannerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ComponentFactoryServiceTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testLookingUpAmbiguousPlanners() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("class-name", TestPlannerFactory.class.getCanonicalName());
        properties.put("streaming-mode", Boolean.toString(false));
        properties.put("planner-type", "test-planner");
        PlannerFactory plannerFactory = (PlannerFactory)ComponentFactoryService.find(PlannerFactory.class, properties);
        Assert.assertThat((Object)plannerFactory, (Matcher)CoreMatchers.instanceOf(TestPlannerFactory.class));
    }

    @Test
    public void testLookingUpNonExistentClass() {
        this.thrown.expect(NoMatchingTableFactoryException.class);
        this.thrown.expectMessage("Reason: No factory supports the additional filters");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("class-name", "NoSuchClass");
        properties.put("streaming-mode", Boolean.toString(false));
        properties.put("planner-type", "test-planner");
        ComponentFactoryService.find(PlannerFactory.class, properties);
    }
}

