/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.DropOperation;

public class DropFunctionOperation
implements DropOperation {
    private final ObjectIdentifier functionIdentifier;
    private final boolean ifExists;
    private final boolean isTemporary;

    public DropFunctionOperation(ObjectIdentifier functionIdentifier, boolean ifExists, boolean isTemporary) {
        this.functionIdentifier = functionIdentifier;
        this.ifExists = ifExists;
        this.isTemporary = isTemporary;
    }

    public ObjectIdentifier getFunctionIdentifier() {
        return this.functionIdentifier;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.functionIdentifier);
        params.put("ifExists", this.ifExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("DROP FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public String getFunctionName() {
        return this.functionIdentifier.getObjectName();
    }
}

