/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.descriptors.ConnectTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;

@PublicEvolving
public interface TableEnvironment {
    public static TableEnvironment create(EnvironmentSettings settings) {
        return TableEnvironmentImpl.create(settings);
    }

    public Table fromTableSource(TableSource<?> var1);

    public void registerCatalog(String var1, Catalog var2);

    public Optional<Catalog> getCatalog(String var1);

    public void loadModule(String var1, Module var2);

    public void unloadModule(String var1);

    public void registerFunction(String var1, ScalarFunction var2);

    @Deprecated
    public void registerTable(String var1, Table var2);

    public void createTemporaryView(String var1, Table var2);

    @Deprecated
    public void registerTableSource(String var1, TableSource<?> var2);

    @Deprecated
    public void registerTableSink(String var1, String[] var2, TypeInformation<?>[] var3, TableSink<?> var4);

    @Deprecated
    public void registerTableSink(String var1, TableSink<?> var2);

    @Deprecated
    public Table scan(String ... var1);

    public Table from(String var1);

    @Deprecated
    public void insertInto(Table var1, String var2, String ... var3);

    public void insertInto(String var1, Table var2);

    public ConnectTableDescriptor connect(ConnectorDescriptor var1);

    public String[] listCatalogs();

    public String[] listModules();

    public String[] listDatabases();

    public String[] listTables();

    public String[] listTemporaryTables();

    public String[] listTemporaryViews();

    public String[] listUserDefinedFunctions();

    public String[] listFunctions();

    public boolean dropTemporaryTable(String var1);

    public boolean dropTemporaryView(String var1);

    public String explain(Table var1);

    public String explain(Table var1, boolean var2);

    public String explain(boolean var1);

    @Deprecated
    public String[] getCompletionHints(String var1, int var2);

    public Table sqlQuery(String var1);

    public void sqlUpdate(String var1);

    public String getCurrentCatalog();

    public void useCatalog(String var1);

    public String getCurrentDatabase();

    public void useDatabase(String var1);

    public TableConfig getConfig();

    public JobExecutionResult execute(String var1) throws Exception;
}

