/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.Registration;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.descriptors.ConnectTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.StreamTableDescriptor;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinitionUtil;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.CatalogQueryOperation;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;
import org.apache.flink.table.operations.ddl.AlterTablePropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropFunctionOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;

@Internal
public class TableEnvironmentImpl
implements TableEnvironment {
    private static final boolean IS_STREAM_TABLE = true;
    private final CatalogManager catalogManager;
    private final ModuleManager moduleManager;
    private final OperationTreeBuilder operationTreeBuilder;
    private final List<ModifyOperation> bufferedModifyOperations = new ArrayList<ModifyOperation>();
    protected final TableConfig tableConfig;
    protected final Executor execEnv;
    protected final FunctionCatalog functionCatalog;
    protected final Planner planner;
    protected final Parser parser;
    private static final String UNSUPPORTED_QUERY_IN_SQL_UPDATE_MSG = "Unsupported SQL query! sqlUpdate() only accepts a single SQL statement of type INSERT, CREATE TABLE, DROP TABLE, ALTER TABLE, USE CATALOG, USE [CATALOG.]DATABASE, CREATE DATABASE, DROP DATABASE, ALTER DATABASE, CREATE FUNCTION, DROP FUNCTION, ALTER FUNCTION";
    private final Registration registration = new Registration(){

        @Override
        public void createTemporaryTable(String path, CatalogBaseTable table) {
            UnresolvedIdentifier unresolvedIdentifier = TableEnvironmentImpl.this.parser.parseIdentifier(path);
            ObjectIdentifier objectIdentifier = TableEnvironmentImpl.this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
            TableEnvironmentImpl.this.catalogManager.createTemporaryTable(table, objectIdentifier, false);
        }

        @Override
        public void createTableSource(String name, TableSource<?> tableSource) {
            TableEnvironmentImpl.this.registerTableSource(name, tableSource);
        }

        @Override
        public void createTableSink(String name, TableSink<?> tableSink) {
            TableEnvironmentImpl.this.registerTableSink(name, tableSink);
        }
    };

    protected TableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, TableConfig tableConfig, Executor executor, FunctionCatalog functionCatalog, Planner planner, boolean isStreamingMode) {
        this.catalogManager = catalogManager;
        this.moduleManager = moduleManager;
        this.execEnv = executor;
        this.tableConfig = tableConfig;
        this.functionCatalog = functionCatalog;
        this.planner = planner;
        this.parser = planner.getParser();
        this.operationTreeBuilder = OperationTreeBuilder.create(tableConfig, functionCatalog, path -> {
            try {
                UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
                Optional<CatalogQueryOperation> catalogQueryOperation = this.scanInternal(unresolvedIdentifier);
                return catalogQueryOperation.map(t -> new TableReferenceExpression(path, (QueryOperation)t));
            }
            catch (SqlParserException ex) {
                return Optional.empty();
            }
        }, isStreamingMode);
    }

    public static TableEnvironmentImpl create(EnvironmentSettings settings) {
        TableConfig tableConfig = new TableConfig();
        CatalogManager catalogManager = new CatalogManager(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName()));
        ModuleManager moduleManager = new ModuleManager();
        FunctionCatalog functionCatalog = new FunctionCatalog(tableConfig, catalogManager, moduleManager);
        Map<String, String> executorProperties = settings.toExecutorProperties();
        Executor executor = ComponentFactoryService.find(ExecutorFactory.class, executorProperties).create(executorProperties);
        Map<String, String> plannerProperties = settings.toPlannerProperties();
        Planner planner = ComponentFactoryService.find(PlannerFactory.class, plannerProperties).create(plannerProperties, executor, tableConfig, functionCatalog, catalogManager);
        return new TableEnvironmentImpl(catalogManager, moduleManager, tableConfig, executor, functionCatalog, planner, settings.isStreamingMode());
    }

    @VisibleForTesting
    public Planner getPlanner() {
        return this.planner;
    }

    @Override
    public Table fromTableSource(TableSource<?> source) {
        return this.createTable(new TableSourceQueryOperation(source, false));
    }

    @Override
    public void registerCatalog(String catalogName, Catalog catalog) {
        this.catalogManager.registerCatalog(catalogName, catalog);
    }

    @Override
    public Optional<Catalog> getCatalog(String catalogName) {
        return this.catalogManager.getCatalog(catalogName);
    }

    @Override
    public void loadModule(String moduleName, Module module) {
        this.moduleManager.loadModule(moduleName, module);
    }

    @Override
    public void unloadModule(String moduleName) {
        this.moduleManager.unloadModule(moduleName);
    }

    @Override
    public void registerFunction(String name, ScalarFunction function) {
        this.functionCatalog.registerTempSystemScalarFunction(name, function);
    }

    @Override
    public void registerTable(String name, Table table) {
        UnresolvedIdentifier identifier = UnresolvedIdentifier.of((String[])new String[]{name});
        this.createTemporaryView(identifier, table);
    }

    @Override
    public void createTemporaryView(String path, Table view) {
        UnresolvedIdentifier identifier = this.parser.parseIdentifier(path);
        this.createTemporaryView(identifier, view);
    }

    private void createTemporaryView(UnresolvedIdentifier identifier, Table view) {
        if (((TableImpl)view).getTableEnvironment() != this) {
            throw new TableException("Only table API objects that belong to this TableEnvironment can be registered.");
        }
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        QueryOperation queryOperation = this.qualifyQueryOperation(tableIdentifier, view.getQueryOperation());
        QueryOperationCatalogView tableTable = new QueryOperationCatalogView(queryOperation);
        this.catalogManager.createTemporaryTable((CatalogBaseTable)tableTable, tableIdentifier, false);
    }

    @Override
    public void registerTableSource(String name, TableSource<?> tableSource) {
        this.registerTableSourceInternal(name, tableSource);
    }

    @Override
    public void registerTableSink(String name, String[] fieldNames, TypeInformation<?>[] fieldTypes, TableSink<?> tableSink) {
        this.registerTableSink(name, tableSink.configure(fieldNames, fieldTypes));
    }

    @Override
    public void registerTableSink(String name, TableSink<?> configuredSink) {
        if (configuredSink.getTableSchema().getFieldCount() == 0) {
            throw new TableException("Table schema cannot be empty.");
        }
        this.registerTableSinkInternal(name, configuredSink);
    }

    @Override
    public Table scan(String ... tablePath) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])tablePath);
        return this.scanInternal(unresolvedIdentifier).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table %s was not found.", unresolvedIdentifier)));
    }

    @Override
    public Table from(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        return this.scanInternal(unresolvedIdentifier).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table %s was not found.", unresolvedIdentifier)));
    }

    @Override
    public void insertInto(String targetPath, Table table) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(targetPath);
        this.insertIntoInternal(unresolvedIdentifier, table);
    }

    @Override
    public void insertInto(Table table, String sinkPath, String ... sinkPathContinued) {
        ArrayList<String> fullPath = new ArrayList<String>(Arrays.asList(sinkPathContinued));
        fullPath.add(0, sinkPath);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])fullPath.toArray(new String[0]));
        this.insertIntoInternal(unresolvedIdentifier, table);
    }

    private void insertIntoInternal(UnresolvedIdentifier unresolvedIdentifier, Table table) {
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        List<ModifyOperation> modifyOperations = Collections.singletonList(new CatalogSinkModifyOperation(objectIdentifier, table.getQueryOperation()));
        if (this.isEagerOperationTranslation()) {
            this.translate(modifyOperations);
        } else {
            this.buffer(modifyOperations);
        }
    }

    private Optional<CatalogQueryOperation> scanInternal(UnresolvedIdentifier identifier) {
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        return this.catalogManager.getTable(tableIdentifier).map(t -> new CatalogQueryOperation(tableIdentifier, t.getTable().getSchema()));
    }

    @Override
    public ConnectTableDescriptor connect(ConnectorDescriptor connectorDescriptor) {
        return new StreamTableDescriptor(this.registration, connectorDescriptor);
    }

    @Override
    public String[] listCatalogs() {
        return (String[])this.catalogManager.listCatalogs().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listModules() {
        return this.moduleManager.listModules().toArray(new String[0]);
    }

    @Override
    public String[] listDatabases() {
        return this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get().listDatabases().toArray(new String[0]);
    }

    @Override
    public String[] listTables() {
        return (String[])this.catalogManager.listTables().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTemporaryTables() {
        return (String[])this.catalogManager.listTemporaryTables().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTemporaryViews() {
        return (String[])this.catalogManager.listTemporaryViews().stream().sorted().toArray(String[]::new);
    }

    @Override
    public boolean dropTemporaryTable(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        return this.catalogManager.dropTemporaryTable(unresolvedIdentifier);
    }

    @Override
    public boolean dropTemporaryView(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.parser.parseIdentifier(path);
        return this.catalogManager.dropTemporaryView(unresolvedIdentifier);
    }

    @Override
    public String[] listUserDefinedFunctions() {
        return this.functionCatalog.getUserDefinedFunctions();
    }

    @Override
    public String[] listFunctions() {
        return this.functionCatalog.getFunctions();
    }

    @Override
    public String explain(Table table) {
        return this.explain(table, false);
    }

    @Override
    public String explain(Table table, boolean extended) {
        return this.planner.explain(Collections.singletonList(table.getQueryOperation()), extended);
    }

    @Override
    public String explain(boolean extended) {
        List<Operation> operations = this.bufferedModifyOperations.stream().map(o -> o).collect(Collectors.toList());
        return this.planner.explain(operations, extended);
    }

    @Override
    public String[] getCompletionHints(String statement, int position) {
        return this.planner.getCompletionHints(statement, position);
    }

    @Override
    public Table sqlQuery(String query) {
        List<Operation> operations = this.parser.parse(query);
        if (operations.size() != 1) {
            throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query.");
        }
        Operation operation = operations.get(0);
        if (operation instanceof QueryOperation && !(operation instanceof ModifyOperation)) {
            return this.createTable((QueryOperation)operation);
        }
        throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query of type SELECT, UNION, INTERSECT, EXCEPT, VALUES, and ORDER_BY.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sqlUpdate(String stmt) {
        List<Operation> operations = this.parser.parse(stmt);
        if (operations.size() != 1) {
            throw new TableException(UNSUPPORTED_QUERY_IN_SQL_UPDATE_MSG);
        }
        Operation operation = operations.get(0);
        if (operation instanceof ModifyOperation) {
            List<ModifyOperation> modifyOperations = Collections.singletonList((ModifyOperation)operation);
            if (this.isEagerOperationTranslation()) {
                this.translate(modifyOperations);
                return;
            } else {
                this.buffer(modifyOperations);
            }
            return;
        } else if (operation instanceof CreateTableOperation) {
            CreateTableOperation createTableOperation = (CreateTableOperation)operation;
            this.catalogManager.createTable((CatalogBaseTable)createTableOperation.getCatalogTable(), createTableOperation.getTableIdentifier(), createTableOperation.isIgnoreIfExists());
            return;
        } else if (operation instanceof CreateDatabaseOperation) {
            CreateDatabaseOperation createDatabaseOperation = (CreateDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(createDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(createDatabaseOperation.asSummaryString());
            try {
                catalog.createDatabase(createDatabaseOperation.getDatabaseName(), createDatabaseOperation.getCatalogDatabase(), createDatabaseOperation.isIgnoreIfExists());
                return;
            }
            catch (DatabaseAlreadyExistException e) {
                throw new ValidationException(exMsg, (Throwable)e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        } else if (operation instanceof DropTableOperation) {
            DropTableOperation dropTableOperation = (DropTableOperation)operation;
            this.catalogManager.dropTable(dropTableOperation.getTableIdentifier(), dropTableOperation.isIfExists());
            return;
        } else if (operation instanceof AlterTableOperation) {
            AlterTableOperation alterTableOperation = (AlterTableOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(alterTableOperation.getTableIdentifier().getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(alterTableOperation.asSummaryString());
            try {
                if (alterTableOperation instanceof AlterTableRenameOperation) {
                    AlterTableRenameOperation alterTableRenameOp = (AlterTableRenameOperation)operation;
                    catalog.renameTable(alterTableRenameOp.getTableIdentifier().toObjectPath(), alterTableRenameOp.getNewTableIdentifier().getObjectName(), false);
                    return;
                }
                if (!(alterTableOperation instanceof AlterTablePropertiesOperation)) return;
                AlterTablePropertiesOperation alterTablePropertiesOp = (AlterTablePropertiesOperation)operation;
                catalog.alterTable(alterTablePropertiesOp.getTableIdentifier().toObjectPath(), (CatalogBaseTable)alterTablePropertiesOp.getCatalogTable(), false);
                return;
            }
            catch (TableAlreadyExistException | TableNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        } else if (operation instanceof DropDatabaseOperation) {
            DropDatabaseOperation dropDatabaseOperation = (DropDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(dropDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(dropDatabaseOperation.asSummaryString());
            try {
                catalog.dropDatabase(dropDatabaseOperation.getDatabaseName(), dropDatabaseOperation.isIfExists(), dropDatabaseOperation.isCascade());
                return;
            }
            catch (DatabaseNotEmptyException | DatabaseNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        } else if (operation instanceof AlterDatabaseOperation) {
            AlterDatabaseOperation alterDatabaseOperation = (AlterDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(alterDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(alterDatabaseOperation.asSummaryString());
            try {
                catalog.alterDatabase(alterDatabaseOperation.getDatabaseName(), alterDatabaseOperation.getCatalogDatabase(), false);
                return;
            }
            catch (DatabaseNotExistException e) {
                throw new ValidationException(exMsg, (Throwable)e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, (Throwable)e);
            }
        } else if (operation instanceof CreateFunctionOperation) {
            CreateFunctionOperation createFunctionOperation = (CreateFunctionOperation)operation;
            this.createCatalogFunction(createFunctionOperation);
            return;
        } else if (operation instanceof CreateTempSystemFunctionOperation) {
            CreateTempSystemFunctionOperation createtempSystemFunctionOperation = (CreateTempSystemFunctionOperation)operation;
            this.createSystemFunction(createtempSystemFunctionOperation);
            return;
        } else if (operation instanceof AlterFunctionOperation) {
            AlterFunctionOperation alterFunctionOperation = (AlterFunctionOperation)operation;
            this.alterCatalogFunction(alterFunctionOperation);
            return;
        } else if (operation instanceof DropFunctionOperation) {
            DropFunctionOperation dropFunctionOperation = (DropFunctionOperation)operation;
            this.dropCatalogFunction(dropFunctionOperation);
            return;
        } else if (operation instanceof DropTempSystemFunctionOperation) {
            DropTempSystemFunctionOperation dropTempSystemFunctionOperation = (DropTempSystemFunctionOperation)operation;
            this.dropSystemFunction(dropTempSystemFunctionOperation);
            return;
        } else if (operation instanceof UseCatalogOperation) {
            UseCatalogOperation useCatalogOperation = (UseCatalogOperation)operation;
            this.catalogManager.setCurrentCatalog(useCatalogOperation.getCatalogName());
            return;
        } else {
            if (!(operation instanceof UseDatabaseOperation)) throw new TableException(UNSUPPORTED_QUERY_IN_SQL_UPDATE_MSG);
            UseDatabaseOperation useDatabaseOperation = (UseDatabaseOperation)operation;
            this.catalogManager.setCurrentCatalog(useDatabaseOperation.getCatalogName());
            this.catalogManager.setCurrentDatabase(useDatabaseOperation.getDatabaseName());
        }
    }

    private Catalog getCatalogOrThrowException(String catalogName) {
        return this.getCatalog(catalogName).orElseThrow(() -> new ValidationException(String.format("Catalog %s does not exist", catalogName)));
    }

    private String getDDLOpExecuteErrorMsg(String action) {
        return String.format("Could not execute %s", action);
    }

    @Override
    public String getCurrentCatalog() {
        return this.catalogManager.getCurrentCatalog();
    }

    @Override
    public void useCatalog(String catalogName) {
        this.catalogManager.setCurrentCatalog(catalogName);
    }

    @Override
    public String getCurrentDatabase() {
        return this.catalogManager.getCurrentDatabase();
    }

    @Override
    public void useDatabase(String databaseName) {
        this.catalogManager.setCurrentDatabase(databaseName);
    }

    @Override
    public TableConfig getConfig() {
        return this.tableConfig;
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        this.translate(this.bufferedModifyOperations);
        this.bufferedModifyOperations.clear();
        return this.execEnv.execute(jobName);
    }

    protected QueryOperation qualifyQueryOperation(ObjectIdentifier identifier, QueryOperation queryOperation) {
        return queryOperation;
    }

    protected boolean isEagerOperationTranslation() {
        return false;
    }

    protected void validateTableSource(TableSource<?> tableSource) {
        TableSourceValidation.validateTableSource(tableSource, (TableSchema)tableSource.getTableSchema());
    }

    private void translate(List<ModifyOperation> modifyOperations) {
        List<Transformation<?>> transformations = this.planner.translate(modifyOperations);
        this.execEnv.apply(transformations);
    }

    private void buffer(List<ModifyOperation> modifyOperations) {
        this.bufferedModifyOperations.addAll(modifyOperations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerTableSourceInternal(String name, TableSource<?> tableSource) {
        this.validateTableSource(tableSource);
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{name}));
        Optional<CatalogBaseTable> table = this.getTemporaryTable(objectIdentifier);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSource().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            ConnectorCatalogTable sourceAndSink = ConnectorCatalogTable.sourceAndSink(tableSource, sourceSinkTable.getTableSink().get(), false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sourceAndSink, objectIdentifier, true);
            return;
        } else {
            ConnectorCatalogTable<?, ?> source = ConnectorCatalogTable.source(tableSource, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)source, objectIdentifier, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerTableSinkInternal(String name, TableSink<?> tableSink) {
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of((String[])new String[]{name}));
        Optional<CatalogBaseTable> table = this.getTemporaryTable(objectIdentifier);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSink().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            ConnectorCatalogTable sourceAndSink = ConnectorCatalogTable.sourceAndSink(sourceSinkTable.getTableSource().get(), tableSink, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sourceAndSink, objectIdentifier, true);
            return;
        } else {
            ConnectorCatalogTable<?, ?> sink = ConnectorCatalogTable.sink(tableSink, false);
            this.catalogManager.createTemporaryTable((CatalogBaseTable)sink, objectIdentifier, false);
        }
    }

    private Optional<CatalogBaseTable> getTemporaryTable(ObjectIdentifier identifier) {
        return this.catalogManager.getTable(identifier).filter(CatalogManager.TableLookupResult::isTemporary).map(CatalogManager.TableLookupResult::getTable);
    }

    private void createCatalogFunction(CreateFunctionOperation createFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(createFunctionOperation.asSummaryString());
        try {
            CatalogFunction function = createFunctionOperation.getCatalogFunction();
            if (createFunctionOperation.isTemporary()) {
                boolean exist = this.functionCatalog.hasTemporaryCatalogFunction(createFunctionOperation.getFunctionIdentifier());
                if (!exist) {
                    FunctionDefinition functionDefinition = FunctionDefinitionUtil.createFunctionDefinition(createFunctionOperation.getFunctionName(), function.getClassName());
                    this.registerCatalogFunctionInFunctionCatalog(createFunctionOperation.getFunctionIdentifier(), functionDefinition);
                } else if (!createFunctionOperation.isIgnoreIfExists()) {
                    throw new ValidationException(String.format("Temporary catalog function %s is already defined", createFunctionOperation.getFunctionIdentifier().asSerializableString()));
                }
            } else {
                Catalog catalog = this.getCatalogOrThrowException(createFunctionOperation.getFunctionIdentifier().getCatalogName());
                catalog.createFunction(createFunctionOperation.getFunctionIdentifier().toObjectPath(), createFunctionOperation.getCatalogFunction(), createFunctionOperation.isIgnoreIfExists());
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionAlreadyExistException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private void alterCatalogFunction(AlterFunctionOperation alterFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(alterFunctionOperation.asSummaryString());
        try {
            CatalogFunction function = alterFunctionOperation.getCatalogFunction();
            if (alterFunctionOperation.isTemporary()) {
                throw new ValidationException("Alter temporary catalog function is not supported");
            }
            Catalog catalog = this.getCatalogOrThrowException(alterFunctionOperation.getFunctionIdentifier().getCatalogName());
            catalog.alterFunction(alterFunctionOperation.getFunctionIdentifier().toObjectPath(), function, alterFunctionOperation.isIfExists());
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionNotExistException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private void dropCatalogFunction(DropFunctionOperation dropFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(dropFunctionOperation.asSummaryString());
        try {
            if (dropFunctionOperation.isTemporary()) {
                this.functionCatalog.dropTempCatalogFunction(dropFunctionOperation.getFunctionIdentifier(), dropFunctionOperation.isIfExists());
            } else {
                Catalog catalog = this.getCatalogOrThrowException(dropFunctionOperation.getFunctionIdentifier().getCatalogName());
                catalog.dropFunction(dropFunctionOperation.getFunctionIdentifier().toObjectPath(), dropFunctionOperation.isIfExists());
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionNotExistException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private void createSystemFunction(CreateTempSystemFunctionOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            boolean exist = this.functionCatalog.hasTemporarySystemFunction(operation.getFunctionName());
            if (!exist) {
                FunctionDefinition functionDefinition = FunctionDefinitionUtil.createFunctionDefinition(operation.getFunctionName(), operation.getFunctionClass());
                this.registerSystemFunctionInFunctionCatalog(operation.getFunctionName(), functionDefinition);
            } else if (!operation.isIgnoreIfExists()) {
                throw new ValidationException(String.format("Temporary system function %s is already defined", operation.getFunctionName()));
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private void dropSystemFunction(DropTempSystemFunctionOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            this.functionCatalog.dropTempSystemFunction(operation.getFunctionName(), operation.isIfExists());
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TableException(exMsg, (Throwable)e);
        }
    }

    private <T, ACC> void registerCatalogFunctionInFunctionCatalog(ObjectIdentifier functionIdentifier, FunctionDefinition functionDefinition) {
        if (functionDefinition instanceof ScalarFunctionDefinition) {
            ScalarFunctionDefinition scalarFunction = (ScalarFunctionDefinition)functionDefinition;
            this.functionCatalog.registerTempCatalogScalarFunction(functionIdentifier, scalarFunction.getScalarFunction());
        } else if (functionDefinition instanceof AggregateFunctionDefinition) {
            AggregateFunctionDefinition aggregateFunctionDefinition = (AggregateFunctionDefinition)functionDefinition;
            AggregateFunction aggregateFunction = aggregateFunctionDefinition.getAggregateFunction();
            TypeInformation typeInfo = UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(aggregateFunction);
            TypeInformation accTypeInfo = UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(aggregateFunction);
            this.functionCatalog.registerTempCatalogAggregateFunction(functionIdentifier, aggregateFunction, typeInfo, accTypeInfo);
        } else if (functionDefinition instanceof TableFunctionDefinition) {
            TableFunctionDefinition tableFunctionDefinition = (TableFunctionDefinition)functionDefinition;
            TableFunction tableFunction = tableFunctionDefinition.getTableFunction();
            TypeInformation typeInfo = UserDefinedFunctionHelper.getReturnTypeOfTableFunction(tableFunction);
            this.functionCatalog.registerTempCatalogTableFunction(functionIdentifier, tableFunction, typeInfo);
        }
    }

    private <T, ACC> void registerSystemFunctionInFunctionCatalog(String functionName, FunctionDefinition functionDefinition) {
        if (functionDefinition instanceof ScalarFunctionDefinition) {
            ScalarFunctionDefinition scalarFunction = (ScalarFunctionDefinition)functionDefinition;
            this.functionCatalog.registerTempSystemScalarFunction(functionName, scalarFunction.getScalarFunction());
        } else if (functionDefinition instanceof AggregateFunctionDefinition) {
            AggregateFunctionDefinition aggregateFunctionDefinition = (AggregateFunctionDefinition)functionDefinition;
            AggregateFunction aggregateFunction = aggregateFunctionDefinition.getAggregateFunction();
            TypeInformation typeInfo = UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(aggregateFunction);
            TypeInformation accTypeInfo = UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(aggregateFunction);
            this.functionCatalog.registerTempSystemAggregateFunction(functionName, aggregateFunction, typeInfo, accTypeInfo);
        } else if (functionDefinition instanceof TableFunctionDefinition) {
            TableFunctionDefinition tableFunctionDefinition = (TableFunctionDefinition)functionDefinition;
            TableFunction tableFunction = tableFunctionDefinition.getTableFunction();
            TypeInformation typeInfo = UserDefinedFunctionHelper.getReturnTypeOfTableFunction(tableFunction);
            this.functionCatalog.registerTempSystemTableFunction(functionName, tableFunction, typeInfo);
        }
    }

    protected TableImpl createTable(QueryOperation tableOperation) {
        return TableImpl.createTable(this, tableOperation, this.operationTreeBuilder, this.functionCatalog);
    }
}

