/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.utils.EncodingUtils;

@Internal
public class ShowCreateUtil {
    private ShowCreateUtil() {
    }

    public static String buildShowCreateTableRow(ResolvedCatalogBaseTable<?> table, ObjectIdentifier tableIdentifier, boolean isTemporary) {
        if (table.getTableKind() == CatalogBaseTable.TableKind.VIEW) {
            throw new TableException(String.format("SHOW CREATE TABLE is only supported for tables, but %s is a view. Please use SHOW CREATE VIEW instead.", tableIdentifier.asSerializableString()));
        }
        String printIndent = "  ";
        StringBuilder sb = new StringBuilder().append(ShowCreateUtil.buildCreateFormattedPrefix("TABLE", isTemporary, tableIdentifier));
        sb.append(ShowCreateUtil.extractFormattedColumns(table, "  "));
        ShowCreateUtil.extractFormattedWatermarkSpecs(table, "  ").ifPresent(watermarkSpecs -> sb.append(",\n").append((String)watermarkSpecs));
        ShowCreateUtil.extractFormattedPrimaryKey(table, "  ").ifPresent(pk -> sb.append(",\n").append((String)pk));
        sb.append("\n) ");
        ShowCreateUtil.extractFormattedComment(table).ifPresent(c -> sb.append(String.format("COMMENT '%s'%s", c, System.lineSeparator())));
        ShowCreateUtil.extractFormattedDistributedInfo((ResolvedCatalogTable)table).ifPresent(sb::append);
        ShowCreateUtil.extractFormattedPartitionedInfo((ResolvedCatalogTable)table).ifPresent(partitionedInfoFormatted -> sb.append("PARTITIONED BY (").append((String)partitionedInfoFormatted).append(")\n"));
        ShowCreateUtil.extractFormattedOptions(table.getOptions(), "  ").ifPresent(v -> sb.append("WITH (\n").append((String)v).append("\n)\n"));
        return sb.toString();
    }

    public static String buildShowCreateViewRow(ResolvedCatalogBaseTable<?> view, ObjectIdentifier viewIdentifier, boolean isTemporary) {
        if (view.getTableKind() != CatalogBaseTable.TableKind.VIEW) {
            throw new TableException(String.format("SHOW CREATE VIEW is only supported for views, but %s is a table. Please use SHOW CREATE TABLE instead.", viewIdentifier.asSerializableString()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (view.getOrigin() instanceof QueryOperationCatalogView) {
            throw new TableException("SHOW CREATE VIEW is not supported for views registered by Table API.");
        }
        stringBuilder.append(String.format("CREATE %sVIEW %s%s as%s%s", isTemporary ? "TEMPORARY " : "", viewIdentifier.asSerializableString(), String.format("(%s)", ShowCreateUtil.extractFormattedColumnNames(view)), System.lineSeparator(), ((CatalogView)view.getOrigin()).getExpandedQuery()));
        ShowCreateUtil.extractFormattedComment(view).ifPresent(c -> stringBuilder.append(String.format(" COMMENT '%s'%s", c, System.lineSeparator())));
        return stringBuilder.toString();
    }

    public static String buildShowCreateCatalogRow(CatalogDescriptor catalogDescriptor) {
        String printIndent = "  ";
        String comment = catalogDescriptor.getComment().orElse(null);
        return String.format("CREATE CATALOG %s %sWITH (%s%s%s)%s", EncodingUtils.escapeIdentifier(catalogDescriptor.getCatalogName()), StringUtils.isNotEmpty((CharSequence)comment) ? String.format("COMMENT '%s' ", EncodingUtils.escapeSingleQuotes(comment)) : "", System.lineSeparator(), ShowCreateUtil.extractFormattedOptions(catalogDescriptor.getConfiguration().toMap(), "  ").orElse(""), System.lineSeparator(), System.lineSeparator());
    }

    static String buildCreateFormattedPrefix(String tableType, boolean isTemporary, ObjectIdentifier identifier) {
        return String.format("CREATE %s%s %s (%s", isTemporary ? "TEMPORARY " : "", tableType, identifier.asSerializableString(), System.lineSeparator());
    }

    static Optional<String> extractFormattedPrimaryKey(ResolvedCatalogBaseTable<?> table, String printIndent) {
        Optional<UniqueConstraint> primaryKey = table.getResolvedSchema().getPrimaryKey();
        return primaryKey.map(uniqueConstraint -> String.format("%s%s", printIndent, uniqueConstraint));
    }

    static String getColumnString(Column column) {
        StringBuilder sb = new StringBuilder();
        sb.append(EncodingUtils.escapeIdentifier(column.getName()));
        sb.append(" ");
        if (column instanceof Column.ComputedColumn) {
            sb.append(column.explainExtras().orElseThrow(() -> new TableException(String.format("Column expression can not be null for computed column '%s'", column.getName()))));
        } else {
            sb.append(column.getDataType().getLogicalType().asSerializableString());
            column.explainExtras().ifPresent(e -> {
                sb.append(" ");
                sb.append((String)e);
            });
        }
        column.getComment().ifPresent(comment -> {
            if (StringUtils.isNotEmpty((CharSequence)comment)) {
                sb.append(" ");
                sb.append(String.format("COMMENT '%s'", EncodingUtils.escapeSingleQuotes(comment)));
            }
        });
        return sb.toString();
    }

    static String extractFormattedColumns(ResolvedCatalogBaseTable<?> table, String printIndent) {
        return table.getResolvedSchema().getColumns().stream().map(column -> String.format("%s%s", printIndent, ShowCreateUtil.getColumnString(column))).collect(Collectors.joining(",\n"));
    }

    static Optional<String> extractFormattedWatermarkSpecs(ResolvedCatalogBaseTable<?> table, String printIndent) {
        if (table.getResolvedSchema().getWatermarkSpecs().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(table.getResolvedSchema().getWatermarkSpecs().stream().map(watermarkSpec -> String.format("%sWATERMARK FOR %s AS %s", printIndent, EncodingUtils.escapeIdentifier(watermarkSpec.getRowtimeAttribute()), watermarkSpec.getWatermarkExpression().asSerializableString())).collect(Collectors.joining("\n")));
    }

    static Optional<String> extractFormattedComment(ResolvedCatalogBaseTable<?> table) {
        String comment = table.getComment();
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            return Optional.of(EncodingUtils.escapeSingleQuotes(comment));
        }
        return Optional.empty();
    }

    static Optional<String> extractFormattedDistributedInfo(ResolvedCatalogTable catalogTable) {
        return catalogTable.getDistribution().map(TableDistribution::toString);
    }

    static Optional<String> extractFormattedPartitionedInfo(ResolvedCatalogTable catalogTable) {
        if (!catalogTable.isPartitioned()) {
            return Optional.empty();
        }
        return Optional.of(catalogTable.getPartitionKeys().stream().map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", ")));
    }

    static Optional<String> extractFormattedOptions(Map<String, String> conf, String printIndent) {
        if (Objects.isNull(conf) || conf.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(conf.entrySet().stream().map(entry -> String.format("%s'%s' = '%s'", printIndent, EncodingUtils.escapeSingleQuotes((String)entry.getKey()), EncodingUtils.escapeSingleQuotes((String)entry.getValue()))).collect(Collectors.joining("," + System.lineSeparator())));
    }

    static String extractFormattedColumnNames(ResolvedCatalogBaseTable<?> baseTable) {
        return baseTable.getResolvedSchema().getColumns().stream().map(Column::getName).map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", "));
    }
}

