/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.PlatformName;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class KerberosUtil {
    public static String getKrb5LoginModuleName() {
        return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
    }

    public static Oid getOidInstance(String oidName) throws ClassNotFoundException, GSSException, NoSuchFieldException, IllegalAccessException {
        Class<?> oidClass;
        if (PlatformName.IBM_JAVA) {
            if ("NT_GSS_KRB5_PRINCIPAL".equals(oidName)) {
                return new Oid("1.2.840.113554.1.2.2.1");
            }
            oidClass = Class.forName("com.ibm.security.jgss.GSSUtil");
        } else {
            oidClass = Class.forName("sun.security.jgss.GSSUtil");
        }
        Field oidField = oidClass.getDeclaredField(oidName);
        return (Oid)oidField.get(oidClass);
    }

    public static String getDefaultRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> classRef = System.getProperty("java.vendor").contains("IBM") ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method getInstanceMethod = classRef.getMethod("getInstance", new Class[0]);
        Object kerbConf = getInstanceMethod.invoke(classRef, new Object[0]);
        Method getDefaultRealmMethod = classRef.getDeclaredMethod("getDefaultRealm", new Class[0]);
        return (String)getDefaultRealmMethod.invoke(kerbConf, new Object[0]);
    }

    public static String getDefaultRealmProtected() {
        String realmString = null;
        try {
            realmString = KerberosUtil.getDefaultRealm();
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return realmString;
    }

    public static String getDomainRealm(String shortprinc) {
        String realmString = null;
        try {
            Class<?> classRef = System.getProperty("java.vendor").contains("IBM") ? Class.forName("com.ibm.security.krb5.PrincipalName") : Class.forName("sun.security.krb5.PrincipalName");
            int tKrbNtSrvHst = classRef.getField("KRB_NT_SRV_HST").getInt(null);
            Object principalName = classRef.getConstructor(String.class, Integer.TYPE).newInstance(shortprinc, tKrbNtSrvHst);
            realmString = (String)classRef.getMethod("getRealmString", new Class[0]).invoke(principalName, new Object[0]);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == realmString || realmString.equals("")) {
            return KerberosUtil.getDefaultRealmProtected();
        }
        return realmString;
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static final String getServicePrincipal(String service, String hostname) throws UnknownHostException {
        String fqdn = hostname;
        String shortprinc = null;
        String realmString = null;
        if (null == fqdn || fqdn.equals("") || fqdn.equals("0.0.0.0")) {
            fqdn = KerberosUtil.getLocalHostName();
        }
        fqdn = fqdn.toLowerCase(Locale.ENGLISH);
        shortprinc = service + "/" + fqdn;
        realmString = KerberosUtil.getDomainRealm(shortprinc);
        if (null == realmString || realmString.equals("")) {
            return shortprinc;
        }
        return shortprinc + "@" + realmString;
    }

    static final String[] getPrincipalNames(String keytabFileName) throws IOException {
        Keytab keytab = Keytab.read((File)new File(keytabFileName));
        HashSet<String> principals = new HashSet<String>();
        List entries = keytab.getEntries();
        for (KeytabEntry entry : entries) {
            principals.add(entry.getPrincipalName().replace("\\", "/"));
        }
        return principals.toArray(new String[0]);
    }

    public static final String[] getPrincipalNames(String keytab, Pattern pattern) throws IOException {
        String[] principals = KerberosUtil.getPrincipalNames(keytab);
        if (principals.length != 0) {
            ArrayList<String> matchingPrincipals = new ArrayList<String>();
            for (String principal : principals) {
                if (!pattern.matcher(principal).matches()) continue;
                matchingPrincipals.add(principal);
            }
            principals = matchingPrincipals.toArray(new String[0]);
        }
        return principals;
    }

    public static boolean hasKerberosKeyTab(Subject subject) {
        return !subject.getPrivateCredentials(KeyTab.class).isEmpty();
    }

    public static boolean hasKerberosTicket(Subject subject) {
        return !subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
    }
}

