/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.security;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SaslInputStream
extends InputStream
implements ReadableByteChannel {
    public static final Log LOG = LogFactory.getLog(SaslInputStream.class);
    private final DataInputStream inStream;
    private final boolean useWrap;
    private byte[] saslToken;
    private final SaslClient saslClient;
    private final SaslServer saslServer;
    private byte[] lengthBuf = new byte[4];
    private byte[] obuffer;
    private int ostart = 0;
    private int ofinish = 0;
    private boolean isOpen = true;

    private static int unsignedBytesToInt(byte[] buf) {
        if (buf.length != 4) {
            throw new IllegalArgumentException("Cannot handle byte array other than 4 bytes");
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            result |= buf[i] & 0xFF;
        }
        return result;
    }

    private int readMoreData() throws IOException {
        try {
            this.inStream.readFully(this.lengthBuf);
            int length = SaslInputStream.unsignedBytesToInt(this.lengthBuf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Actual length is " + length);
            }
            this.saslToken = new byte[length];
            this.inStream.readFully(this.saslToken);
        }
        catch (EOFException e) {
            return -1;
        }
        try {
            this.obuffer = this.saslServer != null ? this.saslServer.unwrap(this.saslToken, 0, this.saslToken.length) : this.saslClient.unwrap(this.saslToken, 0, this.saslToken.length);
        }
        catch (SaslException se) {
            try {
                this.disposeSasl();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
            throw se;
        }
        this.ostart = 0;
        this.ofinish = this.obuffer == null ? 0 : this.obuffer.length;
        return this.ofinish;
    }

    private void disposeSasl() throws SaslException {
        if (this.saslClient != null) {
            this.saslClient.dispose();
        }
        if (this.saslServer != null) {
            this.saslServer.dispose();
        }
    }

    public SaslInputStream(InputStream inStream, SaslServer saslServer) {
        this.inStream = new DataInputStream(inStream);
        this.saslServer = saslServer;
        this.saslClient = null;
        String qop = (String)saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        this.useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
    }

    public SaslInputStream(InputStream inStream, SaslClient saslClient) {
        this.inStream = new DataInputStream(inStream);
        this.saslServer = null;
        this.saslClient = saslClient;
        String qop = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        this.useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
    }

    @Override
    public int read() throws IOException {
        if (!this.useWrap) {
            return this.inStream.read();
        }
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.readMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        return this.obuffer[this.ostart++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (!this.useWrap) {
            return this.inStream.read(b, off, len);
        }
        if (this.ostart >= this.ofinish) {
            int i = 0;
            while (i == 0) {
                i = this.readMoreData();
            }
            if (i == -1) {
                return -1;
            }
        }
        if (len <= 0) {
            return 0;
        }
        int available = this.ofinish - this.ostart;
        if (len < available) {
            available = len;
        }
        if (b != null) {
            System.arraycopy(this.obuffer, this.ostart, b, off, available);
        }
        this.ostart += available;
        return available;
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.useWrap) {
            return this.inStream.skip(n);
        }
        int available = this.ofinish - this.ostart;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.ostart = (int)((long)this.ostart + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        if (!this.useWrap) {
            return this.inStream.available();
        }
        return this.ofinish - this.ostart;
    }

    @Override
    public void close() throws IOException {
        this.disposeSasl();
        this.ostart = 0;
        this.ofinish = 0;
        this.inStream.close();
        this.isOpen = false;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytesRead = 0;
        if (dst.hasArray()) {
            bytesRead = this.read(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining());
            if (bytesRead > -1) {
                dst.position(dst.position() + bytesRead);
            }
        } else {
            byte[] buf = new byte[dst.remaining()];
            bytesRead = this.read(buf);
            if (bytesRead > -1) {
                dst.put(buf, 0, bytesRead);
            }
        }
        return bytesRead;
    }
}

