/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.lib;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.MetricsTag;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.metrics2.lib.MetricsInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Interns {
    private static final Logger LOG = LoggerFactory.getLogger(Interns.class);
    static final int MAX_INFO_NAMES = 2010;
    static final int MAX_INFO_DESCS = 100;
    static final int MAX_TAG_NAMES = 100;
    static final int MAX_TAG_VALUES = 1000;

    public static MetricsInfo info(String name, String description) {
        return Info.INSTANCE.cache.add(name, description);
    }

    public static MetricsTag tag(MetricsInfo info, String value) {
        return Tags.INSTANCE.cache.add(info, value);
    }

    public static MetricsTag tag(String name, String description, String value) {
        return Tags.INSTANCE.cache.add(Interns.info(name, description), value);
    }

    static enum Tags {
        INSTANCE;

        final CacheWith2Keys<MetricsInfo, String, MetricsTag> cache = new CacheWith2Keys<MetricsInfo, String, MetricsTag>(){

            @Override
            protected boolean expireKey1At(int size) {
                return size > 100;
            }

            @Override
            protected boolean expireKey2At(int size) {
                return size > 1000;
            }

            @Override
            protected MetricsTag newValue(MetricsInfo info, String value) {
                return new MetricsTag(info, value);
            }
        };
    }

    static enum Info {
        INSTANCE;

        final CacheWith2Keys<String, String, MetricsInfo> cache = new CacheWith2Keys<String, String, MetricsInfo>(){

            @Override
            protected boolean expireKey1At(int size) {
                return size > 2010;
            }

            @Override
            protected boolean expireKey2At(int size) {
                return size > 100;
            }

            @Override
            protected MetricsInfo newValue(String name, String desc) {
                return new MetricsInfoImpl(name, desc);
            }
        };
    }

    private static abstract class CacheWith2Keys<K1, K2, V> {
        private final Map<K1, Map<K2, V>> k1Map = new LinkedHashMap<K1, Map<K2, V>>(){
            private static final long serialVersionUID = 1L;
            private boolean gotOverflow = false;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K1, Map<K2, V>> e) {
                boolean overflow = CacheWith2Keys.this.expireKey1At(this.size());
                if (overflow && !this.gotOverflow) {
                    LOG.info("Metrics intern cache overflow at {} for {}", (Object)this.size(), e);
                    this.gotOverflow = true;
                }
                return overflow;
            }
        };

        private CacheWith2Keys() {
        }

        protected abstract boolean expireKey1At(int var1);

        protected abstract boolean expireKey2At(int var1);

        protected abstract V newValue(K1 var1, K2 var2);

        synchronized V add(K1 k1, K2 k2) {
            V v;
            LinkedHashMap k2Map = this.k1Map.get(k1);
            if (k2Map == null) {
                k2Map = new LinkedHashMap<K2, V>(){
                    private static final long serialVersionUID = 1L;
                    private boolean gotOverflow = false;

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<K2, V> e) {
                        boolean overflow = CacheWith2Keys.this.expireKey2At(this.size());
                        if (overflow && !this.gotOverflow) {
                            LOG.info("Metrics intern cache overflow at {} for {}", (Object)this.size(), e);
                            this.gotOverflow = true;
                        }
                        return overflow;
                    }
                };
                this.k1Map.put(k1, k2Map);
            }
            if ((v = k2Map.get(k2)) == null) {
                v = this.newValue(k1, k2);
                k2Map.put(k2, v);
            }
            return v;
        }
    }
}

