/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.collect.ComparisonChain;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.namenode.FSImage;

@InterfaceAudience.Private
public class CheckpointSignature
extends StorageInfo
implements Comparable<CheckpointSignature> {
    private static final String FIELD_SEPARATOR = ":";
    private static final int NUM_FIELDS = 7;
    String blockpoolID = "";
    long mostRecentCheckpointTxId;
    long curSegmentTxId;

    CheckpointSignature(FSImage fsImage) {
        super(fsImage.getStorage());
        this.blockpoolID = fsImage.getBlockPoolID();
        this.mostRecentCheckpointTxId = fsImage.getStorage().getMostRecentCheckpointTxId();
        this.curSegmentTxId = fsImage.getEditLog().getCurSegmentTxId();
    }

    CheckpointSignature(String str) {
        super(HdfsServerConstants.NodeType.NAME_NODE);
        String[] fields = str.split(FIELD_SEPARATOR);
        assert (fields.length == 7) : "Must be 7 fields in CheckpointSignature";
        int i = 0;
        this.layoutVersion = Integer.parseInt(fields[i++]);
        this.namespaceID = Integer.parseInt(fields[i++]);
        this.cTime = Long.parseLong(fields[i++]);
        this.mostRecentCheckpointTxId = Long.parseLong(fields[i++]);
        this.curSegmentTxId = Long.parseLong(fields[i++]);
        this.clusterID = fields[i++];
        this.blockpoolID = fields[i];
    }

    public CheckpointSignature(StorageInfo info, String blockpoolID, long mostRecentCheckpointTxId, long curSegmentTxId) {
        super(info);
        this.blockpoolID = blockpoolID;
        this.mostRecentCheckpointTxId = mostRecentCheckpointTxId;
        this.curSegmentTxId = curSegmentTxId;
    }

    @Override
    public String getClusterID() {
        return this.clusterID;
    }

    public String getBlockpoolID() {
        return this.blockpoolID;
    }

    public long getMostRecentCheckpointTxId() {
        return this.mostRecentCheckpointTxId;
    }

    public long getCurSegmentTxId() {
        return this.curSegmentTxId;
    }

    public void setBlockpoolID(String blockpoolID) {
        this.blockpoolID = blockpoolID;
    }

    @Override
    public String toString() {
        return String.valueOf(this.layoutVersion) + FIELD_SEPARATOR + String.valueOf(this.namespaceID) + FIELD_SEPARATOR + String.valueOf(this.cTime) + FIELD_SEPARATOR + String.valueOf(this.mostRecentCheckpointTxId) + FIELD_SEPARATOR + String.valueOf(this.curSegmentTxId) + FIELD_SEPARATOR + this.clusterID + FIELD_SEPARATOR + this.blockpoolID;
    }

    boolean storageVersionMatches(StorageInfo si) throws IOException {
        return this.layoutVersion == si.layoutVersion && this.cTime == si.cTime;
    }

    boolean isSameCluster(FSImage si) {
        return this.namespaceID == si.getStorage().namespaceID && this.clusterID.equals(si.getClusterID()) && this.blockpoolID.equals(si.getBlockPoolID());
    }

    boolean namespaceIdMatches(FSImage si) {
        return this.namespaceID == si.getStorage().namespaceID;
    }

    void validateStorageInfo(FSImage si) throws IOException {
        if (!this.isSameCluster(si) || !this.storageVersionMatches(si.getStorage())) {
            throw new IOException("Inconsistent checkpoint fields.\nLV = " + this.layoutVersion + " namespaceID = " + this.namespaceID + " cTime = " + this.cTime + " ; clusterId = " + this.clusterID + " ; blockpoolId = " + this.blockpoolID + ".\nExpecting respectively: " + si.getStorage().layoutVersion + "; " + si.getStorage().namespaceID + "; " + si.getStorage().cTime + "; " + si.getClusterID() + "; " + si.getBlockPoolID() + ".");
        }
    }

    @Override
    public int compareTo(CheckpointSignature o) {
        return ComparisonChain.start().compare(this.layoutVersion, o.layoutVersion).compare(this.namespaceID, o.namespaceID).compare(this.cTime, o.cTime).compare(this.mostRecentCheckpointTxId, o.mostRecentCheckpointTxId).compare(this.curSegmentTxId, o.curSegmentTxId).compare((Comparable<?>)((Object)this.clusterID), (Comparable<?>)((Object)o.clusterID)).compare((Comparable<?>)((Object)this.blockpoolID), (Comparable<?>)((Object)o.blockpoolID)).result();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CheckpointSignature)) {
            return false;
        }
        return this.compareTo((CheckpointSignature)o) == 0;
    }

    public int hashCode() {
        return this.layoutVersion ^ this.namespaceID ^ (int)(this.cTime ^ this.mostRecentCheckpointTxId ^ this.curSegmentTxId) ^ this.clusterID.hashCode() ^ this.blockpoolID.hashCode();
    }
}

