/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import java.beans.ConstructorProperties;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class StorageTypeStats {
    private long capacityTotal = 0L;
    private long capacityUsed = 0L;
    private long capacityNonDfsUsed = 0L;
    private long capacityRemaining = 0L;
    private long blockPoolUsed = 0L;
    private int nodesInService = 0;

    @ConstructorProperties(value={"capacityTotal", "capacityUsed", "capacityNonDfsUsed", "capacityRemaining", "blockPoolUsed", "nodesInService"})
    public StorageTypeStats(long capacityTotal, long capacityUsed, long capacityNonDfsUsedUsed, long capacityRemaining, long blockPoolUsed, int nodesInService) {
        this.capacityTotal = capacityTotal;
        this.capacityUsed = capacityUsed;
        this.capacityNonDfsUsed = capacityNonDfsUsedUsed;
        this.capacityRemaining = capacityRemaining;
        this.blockPoolUsed = blockPoolUsed;
        this.nodesInService = nodesInService;
    }

    public long getCapacityTotal() {
        return this.capacityTotal;
    }

    public long getCapacityUsed() {
        return this.capacityUsed;
    }

    public long getCapacityNonDfsUsed() {
        return this.capacityNonDfsUsed;
    }

    public long getCapacityRemaining() {
        return this.capacityRemaining;
    }

    public long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    public int getNodesInService() {
        return this.nodesInService;
    }

    StorageTypeStats() {
    }

    StorageTypeStats(StorageTypeStats other) {
        this.capacityTotal = other.capacityTotal;
        this.capacityUsed = other.capacityUsed;
        this.capacityNonDfsUsed = other.capacityNonDfsUsed;
        this.capacityRemaining = other.capacityRemaining;
        this.blockPoolUsed = other.blockPoolUsed;
        this.nodesInService = other.nodesInService;
    }

    void addStorage(DatanodeStorageInfo info, DatanodeDescriptor node) {
        this.capacityUsed += info.getDfsUsed();
        this.capacityNonDfsUsed += info.getNonDfsUsed();
        this.blockPoolUsed += info.getBlockPoolUsed();
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            this.capacityTotal += info.getCapacity();
            this.capacityRemaining += info.getRemaining();
        } else {
            this.capacityTotal += info.getDfsUsed();
        }
    }

    void addNode(DatanodeDescriptor node) {
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            ++this.nodesInService;
        }
    }

    void subtractStorage(DatanodeStorageInfo info, DatanodeDescriptor node) {
        this.capacityUsed -= info.getDfsUsed();
        this.capacityNonDfsUsed -= info.getNonDfsUsed();
        this.blockPoolUsed -= info.getBlockPoolUsed();
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            this.capacityTotal -= info.getCapacity();
            this.capacityRemaining -= info.getRemaining();
        } else {
            this.capacityTotal -= info.getDfsUsed();
        }
    }

    void subtractNode(DatanodeDescriptor node) {
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            --this.nodesInService;
        }
    }
}

