/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.snative;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.BlockLocation;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.exceptions.SwiftConfigurationException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.exceptions.SwiftOperationFailedException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.exceptions.SwiftUnsupportedFeatureException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.snative.StrictBufferedFSInputStream;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.snative.SwiftNativeFileSystemStore;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.snative.SwiftNativeInputStream;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.snative.SwiftNativeOutputStream;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.util.DurationStats;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.util.SwiftObjectPath;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.util.SwiftUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.Progressable;

public class SwiftNativeFileSystem
extends FileSystem {
    public static final String SWIFT = "swift";
    private static final Log LOG = LogFactory.getLog(SwiftNativeFileSystem.class);
    private Path workingDir;
    private URI uri;
    private SwiftNativeFileSystemStore store;

    public SwiftNativeFileSystem() {
    }

    public SwiftNativeFileSystem(SwiftNativeFileSystemStore store) {
        this.store = store;
    }

    public SwiftNativeFileSystemStore getStore() {
        return this.store;
    }

    @Override
    public String getScheme() {
        return SWIFT;
    }

    @Override
    public void initialize(URI fsuri, Configuration conf) throws IOException {
        super.initialize(fsuri, conf);
        this.setConf(conf);
        if (this.store == null) {
            this.store = new SwiftNativeFileSystemStore();
        }
        this.uri = fsuri;
        String username = System.getProperty("user.name");
        this.workingDir = new Path("/user", username).makeQualified(this.uri, new Path(username));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing SwiftNativeFileSystem against URI " + this.uri + " and working dir " + this.workingDir);
        }
        this.store.initialize(this.uri, conf);
        LOG.debug("SwiftFileSystem initialized");
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return "Swift FileSystem " + this.store;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path dir) {
        this.workingDir = this.makeAbsolute(dir);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SwiftFileSystem.setWorkingDirectory to " + dir);
        }
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        Path absolutePath = this.makeAbsolute(path);
        return this.store.getObjectMetadata(absolutePath);
    }

    @Override
    public long getDefaultBlockSize() {
        return this.store.getBlocksize();
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        return this.store.getBlocksize();
    }

    @Override
    public long getBlockSize(Path path) throws IOException {
        return this.store.getBlocksize();
    }

    @Override
    public boolean isFile(Path f) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            return !SwiftUtils.isDirectory(fileStatus);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isDirectory(Path f) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            return SwiftUtils.isDirectory(fileStatus);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Negative start or len parameter to getFileBlockLocations");
        }
        if (file.getLen() <= start) {
            return new BlockLocation[0];
        }
        FileStatus[] listOfFileBlocks = this.store.listSubPaths(file.getPath(), false, true);
        List<Object> locations = new ArrayList();
        if (listOfFileBlocks.length > 1) {
            for (FileStatus fileStatus : listOfFileBlocks) {
                if (SwiftObjectPath.fromPath(this.uri, fileStatus.getPath()).equals(SwiftObjectPath.fromPath(this.uri, file.getPath()))) continue;
                locations.addAll(this.store.getObjectLocation(fileStatus.getPath()));
            }
        } else {
            locations = this.store.getObjectLocation(file.getPath());
        }
        if (locations.isEmpty()) {
            LOG.debug("No locations returned for " + file.getPath());
            String[] name = new String[]{"/default-rack/swift"};
            String[] host = new String[]{"localhost"};
            String[] topology = new String[]{"/swift/unknown"};
            return new BlockLocation[]{new BlockLocation(name, host, topology, 0L, file.getLen())};
        }
        String[] names = new String[locations.size()];
        String[] hosts = new String[locations.size()];
        int i = 0;
        for (URI uRI : locations) {
            hosts[i] = uRI.getHost();
            names[i] = uRI.getAuthority();
            ++i;
        }
        return new BlockLocation[]{new BlockLocation(names, hosts, 0L, file.getLen())};
    }

    @Override
    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SwiftFileSystem.mkdirs: " + path);
        }
        Path directory = this.makeAbsolute(path);
        ArrayList<Path> paths = new ArrayList<Path>();
        while (this.shouldCreate(directory)) {
            paths.add(0, directory);
            directory = directory.getParent();
        }
        for (Path p : paths) {
            if (!this.isNotRoot(p)) continue;
            this.forceMkdir(p);
        }
        return true;
    }

    private boolean isNotRoot(Path absolutePath) {
        return !this.isRoot(absolutePath);
    }

    private boolean isRoot(Path absolutePath) {
        return absolutePath.getParent() == null;
    }

    private boolean mkdir(Path path) throws IOException {
        Path directory = this.makeAbsolute(path);
        boolean shouldCreate = this.shouldCreate(directory);
        if (shouldCreate) {
            this.forceMkdir(directory);
        }
        return shouldCreate;
    }

    private boolean shouldCreate(Path directory) throws IOException {
        boolean shouldCreate;
        if (this.isRoot(directory)) {
            return false;
        }
        try {
            FileStatus fileStatus = this.getFileStatus(directory);
            if (!SwiftUtils.isDirectory(fileStatus)) {
                throw new ParentNotDirectoryException(String.format("%s: can't mkdir since it exists and is not a directory: %s", directory, fileStatus));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("skipping mkdir(" + directory + ") as it exists already");
            }
            shouldCreate = false;
        }
        catch (FileNotFoundException e) {
            shouldCreate = true;
        }
        return shouldCreate;
    }

    private void forceMkdir(Path absolutePath) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Making dir '" + absolutePath + "' in Swift");
        }
        this.store.createDirectory(absolutePath);
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SwiftFileSystem.listStatus for: " + path);
        }
        return this.store.listSubPaths(this.makeAbsolute(path), false, true);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        LOG.debug("SwiftFileSystem.append");
        throw new SwiftUnsupportedFeatureException("Not supported: append()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FSDataOutputStream create(Path file, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        LOG.debug("SwiftFileSystem.create");
        FileStatus fileStatus = null;
        Path absolutePath = this.makeAbsolute(file);
        try {
            fileStatus = this.getFileStatus(absolutePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fileStatus != null) {
            if (fileStatus.isDirectory() && LOG.isDebugEnabled()) {
                LOG.debug("Overwriting either an empty file or a directory");
            }
            if (!overwrite) throw new FileAlreadyExistsException("Path exists: " + file);
            this.store.delete(absolutePath, true);
        } else {
            Path parent = file.getParent();
            if (parent != null && !this.mkdirs(parent)) {
                throw new SwiftOperationFailedException("Mkdirs failed to create " + parent);
            }
        }
        SwiftNativeOutputStream out = this.createSwiftOutputStream(file);
        return new FSDataOutputStream(out, this.statistics);
    }

    protected SwiftNativeOutputStream createSwiftOutputStream(Path path) throws IOException {
        long partSizeKB = this.getStore().getPartsizeKB();
        return new SwiftNativeOutputStream(this.getConf(), this.getStore(), path.toUri().toString(), partSizeKB);
    }

    @Override
    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        int bufferSizeKB = this.getStore().getBufferSizeKB();
        long readBlockSize = (long)bufferSizeKB * 1024L;
        return this.open(path, bufferSize, readBlockSize);
    }

    public FSDataInputStream open(Path path, int bufferSize, long readBlockSize) throws IOException {
        if (readBlockSize <= 0L) {
            throw new SwiftConfigurationException("Bad remote buffer size");
        }
        Path absolutePath = this.makeAbsolute(path);
        return new FSDataInputStream(new StrictBufferedFSInputStream(new SwiftNativeInputStream(this.store, this.statistics, absolutePath, readBlockSize), bufferSize));
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        try {
            this.store.rename(this.makeAbsolute(src), this.makeAbsolute(dst));
            return true;
        }
        catch (SwiftOperationFailedException e) {
            return false;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            return this.store.delete(path, recursive);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    protected Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public List<DurationStats> getOperationStatistics() {
        return this.store.getOperationStatistics();
    }

    @InterfaceAudience.Private
    public FileStatus[] listRawFileStatus(Path path, boolean newest) throws IOException {
        return this.store.listSubPaths(this.makeAbsolute(path), true, newest);
    }

    @InterfaceAudience.Private
    public static int getPartitionsWritten(FSDataOutputStream outputStream) {
        SwiftNativeOutputStream snos = SwiftNativeFileSystem.getSwiftNativeOutputStream(outputStream);
        return snos.getPartitionsWritten();
    }

    private static SwiftNativeOutputStream getSwiftNativeOutputStream(FSDataOutputStream outputStream) {
        OutputStream wrappedStream = outputStream.getWrappedStream();
        return (SwiftNativeOutputStream)wrappedStream;
    }

    @InterfaceAudience.Private
    public static long getPartitionSize(FSDataOutputStream outputStream) {
        SwiftNativeOutputStream snos = SwiftNativeFileSystem.getSwiftNativeOutputStream(outputStream);
        return snos.getFilePartSize();
    }

    @InterfaceAudience.Private
    public static long getBytesWritten(FSDataOutputStream outputStream) {
        SwiftNativeOutputStream snos = SwiftNativeFileSystem.getSwiftNativeOutputStream(outputStream);
        return snos.getBytesWritten();
    }

    @InterfaceAudience.Private
    public static long getBytesUploaded(FSDataOutputStream outputStream) {
        SwiftNativeOutputStream snos = SwiftNativeFileSystem.getSwiftNativeOutputStream(outputStream);
        return snos.getBytesUploaded();
    }
}

