/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.http;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;

public class ExceptionDiags {
    private static final Log LOG = LogFactory.getLog(ExceptionDiags.class);
    private static final String FOR_MORE_DETAILS_SEE = " For more details see:  ";
    public static final String UNKNOWN_HOST = "(unknown)";
    public static final String HADOOP_WIKI = "http://wiki.apache.org/hadoop/";

    public static IOException wrapException(String dest, String operation, IOException exception) {
        String action = operation + " " + dest;
        String xref = null;
        if (exception instanceof ConnectException) {
            xref = "ConnectionRefused";
        } else if (exception instanceof UnknownHostException) {
            xref = "UnknownHost";
        } else if (exception instanceof SocketTimeoutException) {
            xref = "SocketTimeout";
        } else if (exception instanceof NoRouteToHostException) {
            xref = "NoRouteToHost";
        }
        String msg = action + " failed on exception: " + exception;
        if (xref != null) {
            msg = msg + ";" + ExceptionDiags.see(xref);
        }
        return ExceptionDiags.wrapWithMessage(exception, msg);
    }

    private static String see(String entry) {
        return " For more details see:  http://wiki.apache.org/hadoop/" + entry;
    }

    private static <T extends IOException> T wrapWithMessage(T exception, String msg) {
        Class<?> clazz = exception.getClass();
        try {
            Constructor<?> ctor = clazz.getConstructor(String.class);
            Throwable t = (Throwable)ctor.newInstance(msg);
            return (T)((IOException)t.initCause(exception));
        }
        catch (Throwable e) {
            LOG.warn("Unable to wrap exception of type " + clazz + ": it has no (String) constructor", e);
            return exception;
        }
    }
}

